<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * Setting General Currency
 */
class General_Currency extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'general';
        $this->name = 'currency';
        $this->label = __('Currency', 'salesloo');
    }

    public function fields()
    {
        \salesloo_field_heading([
            'label' => __('Currency options', 'salesloo'),
            'description' => __('The following options affect how prices are displayed on the frontend.', 'salesloo'),
        ]);

        $currency_desc = get_option('salesloo_currency') ? __('Make change this currency maybe affected with payment, commisions, pricing and other. make sure you understand what you are going to do. !', 'salesloo') : '';

        \salesloo_field_select([
            'label' => __('Currency', 'salesloo'),
            'name' => 'currency',
            'description' => $currency_desc,
            'options' => salesloo_currencies(),
            'value' => \salesloo_get_option('currency'),
        ]);

        \salesloo_field_text([
            'label' => __('Currency Symbol', 'salesloo'),
            'name' => 'currency_symbol',
            'value' => \salesloo_get_option('currency_symbol'),
        ]);

        \salesloo_field_select([
            'label' => __('Currency Position', 'salesloo'),
            'name' => 'currency_position',
            'description' => '',
            'options' => [
                'left' => 'Left',
                'right' => 'Right'
            ],
            'value' => \salesloo_get_option('currency_position')
        ]);

        \salesloo_field_text([
            'label' => __('Thousand separator', 'salesloo'),
            'name' => 'thousand_separator',
            'value' => \salesloo_get_option('thousand_separator'),
            'class' => 'small-text'
        ]);

        \salesloo_field_text([
            'label' => __('Decimal separator', 'salesloo'),
            'name' => 'decimal_separator',
            'value' => \salesloo_get_option('decimal_separator'),
            'class' => 'small-text'
        ]);

        \salesloo_field_number([
            'label' => __('Number of Decimal', 'salesloo'),
            'name'  => 'number_of_decimal',
            'value' => intval(salesloo_get_option('number_of_decimal')),
            'class' => 'small-text',
            'min'   => 0,
            'max'   => 4
        ]);

        \salesloo_field_submit();
    }
}
