<?php

namespace Salesloo\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Salesloo\Abstracts\Setting_Page;

/**
 * Setting invoice
 */
class Invoice_General extends Setting_Page
{
    /**
     * Setting General constructor
     */
    public function __construct()
    {
        $this->tab = 'invoice';
        $this->name = 'general';
        $this->label = __('General', 'salesloo');
    }

    public function fields()
    {
        $available_invoice_shortcodes = [
            'Avvailable shortcode :',
            '<span style="font-weight:bold">{year}</span> = will be replaced with current Year',
            '<span style="font-weight:bold">{month}</span> = will be replaced with current Month',
            '<span style="font-weight:bold">{date}</span> = will be replaced with current Date',
            '<span style="font-weight:bold">{number}</span> = will be replaced with current invoice number'
        ];

        \salesloo_field_text([
            'label'       => __('Format', 'salesloo'),
            'name'        => 'invoice_format',
            'description' => 'Invoice number format',
            'before'      => implode('<br/>', $available_invoice_shortcodes) . '<br/><br/>',
            'value'       => \salesloo_get_option('invoice_format')
        ]);

        \salesloo_field_number([
            'label' => __('Due date duration', 'salesloo'),
            'name' => 'invoice_due_date_duration',
            'description' => '',
            'class' => 'small-text',
            'after' => 'Days',
            'value' => \salesloo_get_option('invoice_due_date_duration')
        ]);

        \salesloo_field_editor([
            'label'       => __('Invoice information', 'salesloo'),
            'name'        => 'invoice_information',
            'description' => '',
            'value'       => \salesloo_get_option('invoice_information')
        ]);

        \salesloo_field_submit();
    }
}
