<?php

namespace Salesloo\Setting_Page;

use Salesloo\Abstracts\Setting_Page;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Setting Notification Email
 */
class Notification_Email extends Setting_Page
{
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tab = 'notification';
        $this->name = 'email';
        $this->label = __('Email', 'salesloo');
    }

    public function fields()
    {

        \salesloo_field_text([
            'label'       => __('From Name', 'salesloo'),
            'name'        => 'notification_email_from_name',
            'value'       => \salesloo_get_option('notification_email_from_name')
        ]);

        \salesloo_field_text([
            'label'       => __('From Email', 'salesloo'),
            'name'        => 'notification_email_from_email',
            'value'       => \salesloo_get_option('notification_email_from_email')
        ]);

        \salesloo_field_text([
            'label'       => __('Reply To Name', 'salesloo'),
            'name'        => 'notification_email_reply_to_name',
            'value'       => \salesloo_get_option('notification_email_reply_to_name')
        ]);

        \salesloo_field_text([
            'label'       => __('Reply To Email', 'salesloo'),
            'name'        => 'notification_email_reply_to_email',
            'value'       => \salesloo_get_option('notification_email_reply_to_email')
        ]);

        // \salesloo_field_textarea([
        //     'label'       => __('Admin Email', 'salesloo'),
        //     'name'        => 'notification_email_admin_emails',
        //     'description' => 'Email admin for notification purpose, sparate by comma',
        //     'value'       => \salesloo_get_option('notification_email_admin_emails')
        // ]);

        \salesloo_field_editor([
            'label'       => __('Footer', 'salesloo'),
            'name'        => 'notification_email_footer',
            'description' => '',
            'value'       => \salesloo_get_option('notification_email_footer')
        ]);

        $column = 'customer';
        $tabbing = [];

        $tabs = [
            'customer'  => __('Email for Customer', 'salesloo'),
            'affiliate' => __('Email for Affiliate', 'salesloo'),
            'admin'     => __('Email for Admin', 'salesloo')
        ];

        if (isset($_GET['column']) && isset($tabs[$_GET['column']])) {
            $column = sanitize_text_field($_GET['column']);
        }


        foreach ($tabs as $key => $label) {
            $url = admin_url('admin.php' . salesloo_current_query_args(['column' => $key]));
            $class = $key == $column ? 'current' : '';
            $tabbing[] = '<li><a class="button ' . $class . '" href="' . $url . '">' . $label . '</a></li>';
        }

        echo '<div class="salesloo-field"><ul class="subsubsub">';
        echo implode(' | ', $tabbing);
        echo '</ul></div>';

        if ($column == 'customer') {
            salesloo_field_link([
                'label'       => __('Register', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=register'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Place order', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=place_order'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice checking payment', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=invoice_checking_payment'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice completed', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=invoice_completed'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice refunded', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=invoice_refunded'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice cancelled', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=invoice_cancelled'),
                'class' => 'button button-primary'
            ]);

            \salesloo_field_heading([
                'label' => __('Unpaid invoice reminder', 'salesloo'),
                'description' => __('Send reminder email for unpaid invoice', 'salesloo'),
            ]);

            $duration = \salesloo_get_option('invoice_due_date_duration');
            $day = 1;
            while ($day < $duration) {
                \salesloo_field_toggle([
                    'label'           => sprintf(__('Reminder day %s', 'salesloo'), $day),
                    'name'            => 'notification_email_invoice_unpaid_reminder_' . $day,
                    'description'     => sprintf(__('If this is enable, sistem will automatically send unpaid reminder email on %s days after purchase', 'salesloo'), $day),
                    'value'   => \salesloo_get_option('notification_email_invoice_unpaid_reminder_' . $day),
                ]);

                salesloo_field_link([
                    'label'       => '',
                    'placeholder' => __('Edit email template', 'salesloo'),
                    'description' => '<span style="color:red">Save this page options first before edit this template</span>',
                    'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=invoice_unpaid_reminder&day=' . $day),
                    'class' => 'button button-primary',
                    'conditional' => [
                        [
                            'field'   => 'notification_email_invoice_unpaid_reminder_' . $day,
                            'value'   => '1',
                            'compare' => '=='
                        ],
                    ],
                ]);

                $day++;
            }

            \salesloo_field_heading([
                'label' => __('Order expired reminder', 'salesloo'),
                'description' => __('Send reminder email for expired order access', 'salesloo'),
            ]);

            $before_day = [7, 1];

            foreach ($before_day as $key => $day) {
                \salesloo_field_toggle([
                    'label'           => sprintf(__('Reminder %s days before expired', 'salesloo'), $day),
                    'name'            => 'notification_email_order_expired_reminder_' . $day . '_before',
                    'description'     => sprintf(__('If this is enable, sistem will automatically send reminder email on %s days before access expired', 'salesloo'), $day),
                    'value'   => \salesloo_get_option('notification_email_order_expired_reminder_' . $day . '_before'),
                ]);

                salesloo_field_link([
                    'label'       => '',
                    'placeholder' => __('Edit email template', 'salesloo'),
                    'description' => '<span style="color:red">Save this page options first before edit this template</span>',
                    'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=order_expired_reminder&day=' . $day . '_before'),
                    'class' => 'button button-primary',
                    'conditional' => [
                        [
                            'field'   => 'notification_email_order_expired_reminder_' . $day . '_before',
                            'value'   => '1',
                            'compare' => '=='
                        ],
                    ],
                ]);
            }

            salesloo_field_link([
                'label'       => __('Order has expired', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=customer&event=order_expired'),
                'class' => 'button button-primary'
            ]);
        }

        if ($column == 'affiliate') {
            salesloo_field_link([
                'label'       => __('New Lead', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=affiliate&event=new_lead'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('New Sales', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=affiliate&event=new_sales'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Commission paid', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=affiliate&event=commission_paid'),
                'class' => 'button button-primary'
            ]);
        }

        if ($column == 'admin') {
            salesloo_field_link([
                'label'       => __('Register', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=admin&event=register'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Place order', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=admin&event=place_order'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice checking payment', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=admin&event=invoice_checking_payment'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Invoice completed', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=admin&event=invoice_completed'),
                'class' => 'button button-primary'
            ]);

            salesloo_field_link([
                'label'       => __('Affiliate earn commission', 'salesloo'),
                'placeholder' => __('Edit email template', 'salesloo'),
                'description' => '',
                'value'       => admin_url('customize.php?action=salesloo-email-editor&target=admin&event=affiliate_commission'),
                'class' => 'button button-primary'
            ]);
        }

        \salesloo_field_submit();
    }
}
