<?php

namespace Salesloo;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


/**
 * Upgrade
 */
class Upgrade
{
    /**
     * Instance.
     *
     * @since 1.0.0
     * @access public
     */
    public static $instance = null;

    /**
     * Init
     *
     * @since 1.0.0
     */
    public static function init()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * upgrade
     *
     * @return void
     */
    public function upgrade()
    {
        do_action('salesloo/upgrade');
    }

    /**
     * upgrade_notice
     *
     * @return void
     */
    public function upgrade_notice()
    {
        do_action('salesloo/upgrade/notice');
    }

    /**
     * __construct
     *
     * @return void
     */
    public function __construct()
    {
        add_action('admin_notices', [$this, 'upgrade_notice']);
        add_action('admin_init', [$this, 'upgrade']);
    }
}
