<?php

/**
 * Plugin Name:       Salesloo
 * Plugin URI:        https://www.salesloo.com
 * Description:       Powerful Membership & Affiliate Plugin For selling digital product with WordPress
 * Version:           2.6.0
 * Author:            Salesloo
 * Author URI:        https://www.salesloo.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       salesloo
 * Domain Path:       /languages
 */

// If this file is called directly, aborted.
if (!defined('WPINC')) {
    die;
}

if (!defined('SALESLOO_VERSION')) {
    /**
     * Currently plugin version.
     */
    define('SALESLOO_VERSION', '2.6.0');
    define('SALESLOO_UPGRADE_VERSION', '1.1.19');
    define('SALESLOO_URL', plugin_dir_url(__FILE__));
    define('SALESLOO_PATH', plugin_dir_path(__FILE__));
    define('SALESLOO_ROOT', __FILE__);
    define('SALESLOO_ASSETS', SALESLOO_URL . 'assets/');


    register_activation_hook(__FILE__, 'activate_salesloo');
    register_deactivation_hook(__FILE__, 'deactivate_salesloo');

    if (!version_compare(PHP_VERSION, '7.4', '>=')) {
        add_action('admin_notices', 'salesloo_fail_php_version');
    } elseif (!version_compare(get_bloginfo('version'), '5.0', '>=')) {
        add_action('admin_notices', 'salesloo_fail_wp_version');
    } elseif (is_multisite()) {
        add_action('admin_notices', 'salesloo_fail_wp_multisite');
    } else {
        if (!version_compare(get_bloginfo('salesloo_upgrade'), SALESLOO_UPGRADE_VERSION, '>=')) {
            salesloo_upgrade_database();
        }

        require __DIR__ . '/vendor/autoload.php';
        require SALESLOO_PATH . 'libraries/form-parser.php';
        require SALESLOO_PATH . 'libraries/user-info.php';
        require SALESLOO_PATH . 'libraries/mail.php';
        require SALESLOO_PATH . 'includes/plugin.php';
        require SALESLOO_PATH . 'updater.php';

        SaleslooUpdater::init(__FILE__);
    }
}


/**
 * The code that runs during plugin activation.
 */
function activate_salesloo()
{
    require_once SALESLOO_PATH . '/salesloo-activator.php';
    Salesloo_Activator::run();
}

/**
 * The code that runs during plugin deactivation.
 */
function deactivate_salesloo()
{
    require_once SALESLOO_PATH . '/salesloo-deactivator.php';
    Salesloo_Deactivator::run();
}

/**
 * Load Salesloo Digital textdomain.
 *
 * Load gettext translate for Salesloo Digital text domain.
 *
 * @since 1.0.0
 *
 * @return void
 */
function salesloo_load_plugin_textdomain()
{
    load_plugin_textdomain(
        'salesloo',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages'
    );
}

add_action('init', 'salesloo_load_plugin_textdomain');

/**
 * Salesloo admin notice for minimum PHP version.
 *
 * Warning when the site doesn't have the minimum required PHP version.
 *
 * @since 1.0.0
 *
 * @return void
 */
function salesloo_fail_php_version()
{
    /* translators: %s: PHP version */
    $message = sprintf(esc_html__('Salesloo Digital requires PHP version %s+ or higher, plugin is currently NOT RUNNING.', 'salesloo-digital'), '7.3');
    $html_message = sprintf('<div class="error"><p>%s</p></div>', wpautop($message));
    echo wp_kses_post($html_message);
}

/**
 * Salesloo admin notice for minimum WordPress version.
 *
 * Warning when the site doesn't have the minimum required WordPress version.
 *
 * @since 1.0.0
 *
 * @return void
 */
function salesloo_fail_wp_version()
{
    /* translators: %s: WordPress version */
    $message = sprintf(esc_html__('Salesloo requires WordPress version %s+. Because you are using an earlier version, the plugin is currently NOT RUNNING.', 'salesloo'), '5.0');
    $html_message = sprintf('<div class="error"><p>%s</p></div>', wpautop($message));
    echo wp_kses_post($html_message);
}

/**
 * Salesloo admin notice for multisite.
 *
 * Warning when the site is multisite.
 *
 * @since 1.0.0
 *
 * @return void
 */
function salesloo_fail_wp_multisite()
{
    $message = sprintf(esc_html__('Salesloo can\'t running on multisite please change to single site version', 'salesloo'));
    $html_message = sprintf('<div class="error"><p>%s</p></div>', wpautop($message));
    echo wp_kses_post($html_message);
}

/**
 * salesloo_upgrade_database
 *
 * @return void
 */
function salesloo_upgrade_database()
{
    require_once SALESLOO_PATH . '/salesloo-activator.php';
    Salesloo_Activator::run();
    update_option('salesloo_upgrade', SALESLOO_UPGRADE_VERSION);
}

/**
 * setup cronjob
 *
 * @return void
 */
function salesloo_setup_cron()
{
    /**
     * remove old cron event
     */
    if (wp_next_scheduled('salesloo/cron/hourly/event')) {
        wp_clear_scheduled_hook('salesloo/cron/hourly/event');
    }
    if (wp_next_scheduled('salesloo/cron/minute/event')) {
        wp_clear_scheduled_hook('salesloo/cron/minute/event');
    }

    /**
     * setup new cron
     */

    if (!wp_next_scheduled('salesloo/cron/minute')) {
        wp_schedule_event(time(), 'salesloo_every_minute', 'salesloo/cron/minute');
    }

    if (!wp_next_scheduled('salesloo/cron/hourly')) {
        wp_schedule_event(time(), 'hourly', 'salesloo/cron/hourly');
    }
}

salesloo_setup_cron();


/**
 * debuging function
 */
if (!function_exists('__debug')) {
    function __debug()
    {
        echo '<pre>';
        print_r(func_get_args());
        echo '</pre>';
    }
}


add_filter('doing_it_wrong_trigger_error', '__return_false');
