<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="<?php echo salesloo_make_json($x_data); ?>">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-start space-x-5">
                    <div class="flex-initial">
                        <div class="relative">
                            <h1 class="text-lg font-bold leading-5" style="padding: 0"><?php echo salesloo_user_get_name($user->ID); ?></h1>
                        </div>
                    </div>
                    <div class="flex-initial">
                        <div class="relative h-full flex items-center">
                            <a href="<?php echo admin_url('user_edit.php?user_id=' . $user->ID); ?>" class="text-purple-500 bg-transparent border border-solid border-purple-500 hover:bg-purple-500 hover:text-white active:bg-purple-600 font-bold uppercase text-xs px-4 py-2 rounded outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150 flex items-center justify-center space-x-3">
                                <span class="text-xs"><?php _e('Edit Profil', 'salesloo'); ?></span>
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0 text-sm">
                    <div class="flex-1">
                        <div class="relative text-right">
                            <span><?php echo $user->user_login; ?></span>
                        </div>
                    </div>
                    <div class="flex-1">
                        <div class="relative text-right">
                            <span>@</span>&nbsp;<span><?php echo $user->user_email; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center sm:space-x-3 flex-col sm:flex-row space-y-2 sm:space-y-0">
                    <div class="flex-1 w-full relative border" x-data="{mode:'select', rangepicker: filter.daterange}" x-effect="if(rangepicker == 'custom'){mode =rangepicker}else{filter.daterange = rangepicker;};">
                        <div class="relative w-full" :class="{'opacity-0' : mode=='custom'}" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <select class="w-full max-w-full" x-model="rangepicker">
                                <?php foreach (salesloo_daterange_picker() as $value => $label) : ?>
                                    <option value="<?php echo $value ?>"><?php echo $label; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="absolute left-0 top-0 w-full h-full z-10" x-show="mode== 'custom'" style="display:none" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform scale-90" x-transition:enter-end="opacity-100 transform scale-100" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform scale-100" x-transition:leave-end="opacity-0 transform scale-90">
                            <div class="relative w-full">
                                <input type="text" x-data="rangedatepicker()" x-model="filter.daterange" style="width:100%">
                                <div class="absolute cursor-pointer top-4 right-8 z-10" title="Clear" @click="mode='select';rangepicker=''">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-red-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div class="absolute right-3 top-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-secondary" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-1 w-full">
                        <div class="relative w-full">
                            <select class="w-full max-w-full" x-model="filter.product_id">
                                <option value="all"><?php _e('All Product', 'salesloo'); ?></option>
                                <?php foreach (Salesloo\Models\Product::get() as $product) : ?>
                                    <option value="<?php echo $product->ID; ?>"><?php echo $product->title; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-10 relative">
        <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
            <div class="flex-grow bg-secondary py-5">
                <div class="w-full" x-data="getChartVisit()" x-apexchart="option" x-effect="inite()">
                </div>
            </div>
            <div class="flex-none w-full md:w-1/3">
                <div class="flex flex-col space-y-5 h-full" x-data="getStatVisit" x-effect="fetch()">
                    <div class="py-8 px-5 rounded shadow-sm bg-secondary text-secondary w-full lg:flex-1">
                        <div class="h-full flex items-centers">
                            <div class="flex items-center justify-center w-full">
                                <div class="flex-1 text-center">
                                    <p class="text-4xl font-bold tracking-wider" x-html="click">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                    <p class="text-sm text-secondary"><?php _e('Total Link Click', 'salesloo'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-8 px-5 rounded shadow-sm bg-secondary text-secondary w-full lg:flex-1">
                        <div class="h-full flex items-centers">
                            <div class="flex items-center justify-center w-full">
                                <div class="flex-1 text-center">
                                    <p class="text-4xl font-bold tracking-wider" x-html="uclick">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                    <p class="text-sm text-secondary"><?php _e('Total Unique Link Click', 'salesloo'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="relative mt-5">
        <div class="" x-data="getStatAff()" x-effect="fetch()">
            <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                <div class="flex-grow">
                    <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-blue-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-blue-200 bg-blue-100 text-blue-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 15l-2 5L9 9l11 4-5 2zm0 0l5 5M7.188 2.239l.777 2.897M5.136 7.965l-2.898-.777M13.95 4.05l-2.122 2.122m-5.657 5.656l-2.12 2.122" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Leads', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-html="leads">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-green-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-green-200 bg-green-100 text-green-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Sales', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="sales">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-none w-full md:w-1/3">
                    <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-orange-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-orange-200 bg-orange-100 text-orange-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 3.055A9.001 9.001 0 1020.945 13H11V3.055z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.488 9H15V3.512A9.025 9.025 0 0120.488 9z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Conversion', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="conversion">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="relative mt-5">
        <div class="" x-data="getStatCommission()" x-effect="fetch()">
            <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                <div class="flex-grow">
                    <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0 sm:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-indigo-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-indigo-200 bg-indigo-100 text-indigo-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Total Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-html="total">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-teal-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-teal-200 bg-teal-100 text-teal-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Paid Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="paid">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex-none w-full md:w-1/3">
                    <div class="flex flex-col md:flex-row space-y-5 md:space-y-0 md:space-x-5">
                        <div class="py-8 px-5 rounded shadow-sm bg-secondary text-pink-400 w-full lg:flex-1">
                            <div class="flex items-center justify-center space-x-4">
                                <div class="w-14 h-14 border-4 border-pink-200 bg-pink-100 text-pink-400 rounded-full flex justify-center items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 8V4m0 0h4M4 4l5 5m11-1V4m0 0h-4m4 0l-5 5M4 16v4m0 0h4m-4 0l5-5m11 5l-5-5m5 5v-4m0 4h-4" />
                                    </svg>
                                </div>
                                <div class="flex-grow">
                                    <p class="text-sm text-secondary"><?php _e('Unpaid Commission', 'salesloo'); ?></p>
                                    <p class="text-2xl font-bold tracking-wider" x-text="unpaid">
                                        <?php echo $x_data['loader']; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="relative mt-20">
        <div>
            <h3 class="text-2xl text-primary"><?php _e('Commission', 'salesloo'); ?></h3>
        </div>
        <div class="" x-data="getCommissions()">
            <div class="w-full relative">
                <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                    <div class="w-full sm:flex-1">
                    </div>
                    <div class="w-full sm:flex-1">
                        <template x-if="pages > 1 && items.length > 0">
                            <div class="w-full text-secondary">
                                <div class="flex h-10 items-center justify-end space-x-2">
                                    <div class="h-10 w-16">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="paged = 1">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="if(paged > 1){paged = paged - 1}">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span x-text="paged"></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-14">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="if(paged < pages){paged = paged + 1}">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="paged = pages">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
            <div class="w-full mb-5">
                <template x-if="loader">
                    <div class="my-20 flex justify-center items-center">
                        <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
                    </div>
                </template>
                <div class="flex flex-col space-y-5">
                    <template x-for="item in items">
                        <div class="w-full bg-secondary shadow-sm rounded relative">
                            <div class="w-full flex flex-col lg:flex-row">
                                <div class="flex-none h-24 w-full lg:w-1/2 rounded">
                                    <div class="h-full pl-5">
                                        <div class="w-full h-full flex flex-col justify-center items-start overflow-hidden">
                                            <div class="text-base text-secondary" x-text="item.created_at"></div>
                                            <div class="max-w-full text-sm break-words text-gray-4"><span x-text="item.note"></span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-grow text-secondary rounded h-24">
                                    <div class="relative flex flex-col items-center justify-center h-full">
                                        <div class="flex w-full pr-5">
                                            <div class="flex-1 h-full flex flex-col justify-center items-center">
                                                <div class="text-sm text-right w-full"><?php _e('Amount', 'salesloo'); ?></div>
                                                <div class="text-base font-bold text-secondary w-full text-right" x-text="item.amount"></div>
                                            </div>
                                            <div class="flex-1 h-full flex flex-col justify-end items-center">
                                                <div class="text-sm text-right w-full"><?php _e('Status', 'salesloo'); ?></div>
                                                <div class="text-sm text-secondary w-full text-right">
                                                    <span class="py-1 px-2 rounded" :class="item.status.bg" x-text="item.status.value"></span>
                                                </div>
                                            </div>
                                            <div class="flex-1 h-full flex flex-col justify-end items-center">
                                                <div class="text-sm text-right w-full">&nbsp;</div>
                                                <div class="text-sm text-secondary w-full text-right">
                                                    <span x-show="item.status.value === 'Unpaid'" class="py-1 px-2 rounded bg-red-500 text-white cursor-pointer" @click="cancelCommission(item)">Cancel</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
            <div class="w-full relative">
                <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                    <div class="w-full sm:flex-1">

                    </div>
                    <div class="w-full sm:flex-1">
                        <template x-if="pages > 1 && items.length > 0">
                            <div class="w-full text-secondary">
                                <div class="flex h-10 items-center justify-end space-x-2">
                                    <div class="h-10 w-16">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="paged = 1">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="if(paged > 1){paged = paged - 1}">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span x-text="paged"></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-14">
                                        <div class="h-full w-full flex justify-center items-center">
                                            <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="if(paged < pages){paged = paged + 1}">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="h-10 w-10 rounded shadow-sm bg-secondary cursor-pointer" @click="paged = pages">
                                        <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function cancelCommission(commission) {
            if (confirm('Are you sure you want to cancel this commission?')) {
                fetch('<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_cancel_commission'); ?>', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            id: commission.ID
                        }),
                    })
                    .then(response => {
                        //reload page
                        location.reload();
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });
            }
        }

        function rangedatepicker() {
            return {
                init() {
                    const picker = new Litepicker({
                        element: this.$el,
                        plugins: ['mobilefriendly'],
                        ranges: {
                            position: 'left',
                        },
                        singleMode: false,
                        numberOfColumns: 2,
                        numberOfMonths: 2,
                        format: 'YYYY-MM-DD',
                    });
                    picker.on('hide', (date1, date2) => {
                        this.$el.dispatchEvent(new Event('input'));
                    });
                }
            }
        }

        function getStatVisit() {
            return {
                click: this.loader,
                uclick: this.loader,
                ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_stat_visits'); ?>',
                source: '',
                fetch() {
                    this.click = this.loader;
                    this.uclick = this.loader;
                    fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id + '&affiliate_id=' + this.filter.affiliate_id)
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.json();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(res => {
                            this.click = res.click;
                            this.uclick = res.uclick;
                        })
                        .catch((error) => {
                            console.log(error);
                            throw error;
                        });
                }
            }
        }

        function getChartVisit() {
            return {
                ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_chart_visits'); ?>',
                option: null,
                inite() {
                    let ajax = this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id + '&affiliate_id=' + this.filter.affiliate_id;
                    fetch(ajax)
                        .then(res => {
                            return res.json()
                        })
                        .then(res => {
                            let options = {
                                tooltip: {
                                    shared: true,
                                    intersect: false
                                },
                                fill: {
                                    type: ['gradient', 'gradient'],
                                    opacity: 0.6,
                                    gradient: {
                                        shadeIntensity: 1,
                                        inverseColors: false,
                                        opacityFrom: 0.45,
                                        opacityTo: 0.05,
                                        stops: [20, 100, 100, 100]
                                    },
                                },
                            }
                            this.option = {}
                            this.option = {
                                ...options,
                                ...res
                            }
                        })
                }
            }
        }

        function getStatAff() {
            return {
                leads: this.loader,
                sales: this.loader,
                conversion: this.loader,
                ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_stat_aff'); ?>',
                source: '',
                fetch() {
                    this.leads = this.loader;
                    this.sales = this.loader;
                    this.conversion = this.loader;
                    fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id + '&affiliate_id=' + this.filter.affiliate_id)
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.json();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(res => {
                            this.leads = res.leads;
                            this.sales = res.sales;
                            this.conversion = res.conversion
                        })
                        .catch((error) => {
                            console.log(error);
                            throw error;
                        });
                }
            }
        }

        function getStatCommission() {
            return {
                total: this.loader,
                paid: this.loader,
                unpaid: this.loader,
                ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_stat_commission'); ?>',
                source: '',
                fetch() {
                    this.total = this.loader;
                    this.paid = this.loader;
                    this.unpaid = this.loader;
                    fetch(this.ajax_url + '&date=' + this.filter.daterange + '&product_id=' + this.filter.product_id + '&affiliate_id=' + this.filter.affiliate_id)
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.json();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(res => {
                            this.total = res.total;
                            this.paid = res.paid;
                            this.unpaid = res.unpaid;
                        })
                        .catch((error) => {
                            console.log(error);
                            throw error;
                        });
                }
            }
        }

        function getCommissions() {

            return {
                loader: true,
                items: [],
                total: 0,
                pages: 0,
                paged: 1,
                search: '',
                ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_commissions'); ?>',
                init() {
                    this.get();
                    this.$watch('paged', (val) => {
                        this.get();
                    })
                    this.$watch('search', (val) => {
                        this.paged = 1;
                        this.get();
                    })
                },
                get() {
                    this.loader = true;
                    this.items = [];
                    fetch(this.ajax_url + '&paged=' + this.paged + '&search=' + this.search + '&affiliate_id=' + this.filter.affiliate_id)
                        .then(response => {
                            if (response.status >= 200 && response.status <= 299) {
                                return response.json();
                            } else {
                                return response.json().then(error => {
                                    throw error;
                                });
                            }
                        })
                        .then(res => {
                            this.loader = false;
                            this.items = res.items;
                            this.total = res.total;
                            this.paged = res.paged;
                            this.pages = res.pages;
                        })
                        .catch((error) => {
                            console.log(error);
                            throw error;
                        });

                }
            }

        }
    </script>