<div id="salesloo" class="wrap min-h-screen text-secondary relative" x-data="<?php echo salesloo_make_json($x_data); ?>">
    <div class="border-b border-gray-200 pb-5 mb-5">
        <div class="flex justify-center items-center flex-col md:flex-row space-x-0 space-y-2 md:sapce-y-0 md:space-x-5">
            <div class="w-full xl:w-1/2">
                <div class="flex items-center justify-center space-x-5">
                    <div class="flex-1">
                        <div class="relative">
                            <h1 class="wp-heading-inline text-lg font-bold"><?php echo esc_html(__('Affiliate Payout', 'salesloo')); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full xl:w-1/2">
            </div>
        </div>
    </div>

    <div class="mt-10" x-data="getAffiliatePayout()">
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                    <div class="w-full text-secondary relative">
                        <input type="text" x-model="search" placeholder="Find Affiliate" class="w-full placeholder-opacity-50 placeholder-gray-300">
                        <span class="absolute top-3 right-3 text-gray-300">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16l2.879-2.879m0 0a3 3 0 104.243-4.242 3 3 0 00-4.243 4.242zM21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </span>
                    </div>
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
        <div class="w-full mb-5">
            <template x-if="loader">
                <div class="my-20 flex justify-center items-center">
                    <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
                </div>
            </template>
            <template x-if="!loader && items.length < 1">
                <div class="my-20 flex justify-center items-center">
                    <?php _e('No unpaid commission found', 'salesloo'); ?>
                </div>
            </template>
            <div class="flex flex-col space-y-5">
                <template x-for="item in items">
                    <div class="w-full bg-secondary shadow-sm rounded relative">
                        <div class="w-full flex flex-col lg:flex-row">
                            <div class="flex-grow h-24 rounded">
                                <div class="h-full">
                                    <div class="w-full flex flex-col xs:flex-row h-full">
                                        <div class="w-2/3 h-24 xs:h-full pl-5">
                                            <div class="w-full h-full flex space-x-3">
                                                <div class="w-12 flex-none">
                                                    <div class="w-full h-full flex justify-center items-center">
                                                        <img class="w-12 h-12 rounded-full border border-white bg-secondary" :src="item.avatar">
                                                    </div>
                                                </div>
                                                <div class="flex-1">
                                                    <div class="w-full h-full flex flex-col justify-center items-start text-secondary overflow-hidden">
                                                        <div class="text-base font-bold" x-text="item.name"></div>
                                                        <div class="max-w-full text-sm break-words">@<span x-text="item.username"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="w-full xs:w-1/3 h-24 xs:h-full pr-5 lg:pr-0">
                                            <div class="w-full flex items-center justify-end h-full text-secondary">
                                                <button class="text-purple-500 bg-transparent border border-solid border-purple-500 hover:bg-purple-500 hover:text-white active:bg-purple-600 font-bold uppercase text-xs px-4 py-2 rounded outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150 flex items-center justify-center space-x-3" @click="item.class = 'flex'">
                                                    <span class="text-xs"><?php _e('PAYOUT NOW', 'salesloo'); ?></span>
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </span>
                                                </button>
                                                <div class="overflow-x-hidden overflow-y-auto fixed inset-0 z-50 outline-none focus:outline-none justify-center items-center top-0 left-0 h-screen" :class="item.class" style="z-index: 999999">
                                                    <div class="relative w-auto my-6 mx-auto max-w-sm max-h-screen">
                                                        <!--content-->
                                                        <div class="border-0 rounded-lg shadow-lg relative flex flex-col w-full bg-secondary outline-none focus:outline-none bg-white">
                                                            <!--header-->
                                                            <div class="flex items-start justify-between p-5 border-b border-solid border-gray-200 rounded-t">
                                                                <h3 class="text-xl font-semibold text-primary">
                                                                    <?php _e('Payout Commission', 'salesloo'); ?>
                                                                </h3>
                                                                <button class="p-1 ml-auto bg-transparent border-0 text-gray-300 float-right text-3xl leading-none font-semibold outline-none focus:outline-none" @click="item.class='hidden'">
                                                                    <span class="bg-transparent h-6 w-6 text-2xl block outline-none focus:outline-none">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                                        </svg>
                                                                    </span>
                                                                </button>
                                                            </div>
                                                            <!--body-->
                                                            <div class="relative p-6 flex-auto">
                                                                <div class="flex flex-col space-y-5">
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Affiliate Name', 'salesloo'); ?></p>
                                                                        <p class="text-lg font-semibold" x-text="item.name">
                                                                        </p>
                                                                    </div>
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Affiliate Username', 'salesloo'); ?></p>
                                                                        <p class="text-lg font-semibold" x-text="item.username">
                                                                        </p>
                                                                    </div>
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Commission Amount', 'salesloo'); ?></p>
                                                                        <p class="text-lg font-semibold" x-text="item.unpaid">
                                                                        </p>
                                                                    </div>
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Payout Method', 'salesloo'); ?></p>
                                                                        <p class="text-base">
                                                                            <template x-for="method in item.payout_methods">
                                                                                <div>
                                                                                    <input x-model="item.payout.method" type="radio" :value="method.value" :id="method.id" name="payout_method">
                                                                                    <label :for="method.id" x-text="method.label"></label>
                                                                                </div>
                                                                            </template>
                                                                            <template x-if="item.payout_methods.length <= 0">
                                                                                <div class="bg-red-200 text-red-400 text-sm rounded p-3">
                                                                                    <?php _e('Empty payout method, please ask affiliate to add their payout method!', 'salesloo'); ?>
                                                                                </div>
                                                                            </template>
                                                                        </p>
                                                                    </div>
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Proof of payment', 'salesloo'); ?></p>
                                                                        <div class="text-base">
                                                                            <label class="flex flex-col items-center py-3 bg-secondary rounded-md shadow-md text-xs tracking-wide uppercase border border-blue cursor-pointer hover:bg-purple-600 hover:text-white text-purple-600 ease-linear transition-all duration-150 w-full">
                                                                                <span class="text-sm leading-normal"><?php _e('Select a file', 'salesloo'); ?></span>
                                                                                <input type='file' class="hidden" accept="image/*" @change="uploadImage(event).then(res=>{item.payout.pop.id = res.id; item.payout.pop.url = res.url});" />
                                                                            </label>
                                                                            <p class="w-full mt-1">
                                                                                <template x-if="item.payout.pop.url">
                                                                                    <img class="w-full rounded" :src="item.payout.pop.url" />
                                                                                </template>
                                                                            </p>
                                                                        </div>
                                                                    </div>
                                                                    <div class="w-full">
                                                                        <p class="text-sm text-secondary"><?php _e('Note', 'salesloo'); ?></p>
                                                                        <p class="text-base tracking-wider">
                                                                            <textarea x-model="item.payout.note" class="w-full rounded" rows="3" placeholder=""></textarea>
                                                                        </p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!--footer-->
                                                            <div class="flex items-center justify-end p-6 border-t border-solid border-gray-200 rounded-b">
                                                                <button class="text-purple-500 background-transparent font-bold uppercase px-6 py-2 text-sm outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150" @click="item.class='hidden'">
                                                                    <?php _e('Cancel', 'salesloo'); ?>
                                                                </button>
                                                                <button class="bg-purple-500 text-white active:bg-purple-600 font-bold uppercase text-xs px-4 py-4 rounded shadow hover:shadow-md outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150" type="button" @click="pay(item.payout).then(res=>{reload=true});">
                                                                    <?php echo _e('Mark as Paid', 'salesloo'); ?>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="opacity-50 fixed inset-0 z-40 bg-black" :class="item.class" @click="item.class='hidden'"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-48 text-secondary rounded h-24">
                                <div class="pr-5 h-full">
                                    <div class="relative flex flex-col items-end justify-center h-full">
                                        <div class="text-sm"><?php _e('Unpaid Commission', 'salesloo'); ?></div>
                                        <div class="text-base font-bold text-orange-400" x-text="item.unpaid"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-10" x-data="getWithdrawals">
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                    <div class="w-full text-secondary relative">
                        <input type="text" x-model="search" placeholder="Find Affiliate" class="w-full placeholder-opacity-50 placeholder-gray-300">
                        <span class="absolute top-3 right-3 text-gray-300">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16l2.879-2.879m0 0a3 3 0 104.243-4.242 3 3 0 00-4.243 4.242zM21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </span>
                    </div>
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
        <div class="w-full my-5">
            <template x-if="loader">
                <div class="my-20 flex justify-center items-center">
                    <div class="animate-spin rounded-full h-20 w-20 border-t-2 border-b-2 border-gray-500"></div>
                </div>
            </template>
            <template x-if="!loader && items.length < 1">
                <div class="my-20 flex justify-center items-center">
                    <?php _e('No data found', 'salesloo'); ?>
                </div>
            </template>
            <div class="flex flex-col">
                <template x-for="item in items">
                    <div class="w-full bg-secondary shadow-sm rounded relative border border-b border-gray-200">
                        <div class="w-full flex flex-col lg:flex-row">
                            <div class="flex-grow h-auto md:h-24">
                                <div class="h-full">
                                    <div class="w-full flex flex-wrap md:flex-row h-full">
                                        <div class="flex-none w-1/2 md:flex-1 h-24 pl-5">
                                            <div class="relative flex flex-col items-start justify-center h-full">
                                                <div class="text-sm font-bold text-secondary" x-text="item.created_at"></div>
                                            </div>
                                        </div>
                                        <div class="flex-none w-1/2 md:flex-1 h-24">
                                            <div class="pr-5 h-full">
                                                <div class="relative flex flex-col items-start justify-center h-full">
                                                    <div class="text-sm"><?php _e('Affiliate', 'salesloo'); ?></div>
                                                    <div class="text-base font-bold text-secondary" x-text="item.username"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex-none w-1/2 md:flex-1 h-24">
                                            <div class="pr-5 h-full">
                                                <div class="relative flex flex-col items-start justify-center h-full">
                                                    <div class="text-sm"><?php _e('Method', 'salesloo'); ?></div>
                                                    <div class="text-base font-bold text-secondary" x-text="item.method"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex-none w-1/2 md:flex-1">
                                            <div class="w-full flex items-center justify-end h-full text-secondary">
                                                <a :href="item.proof_of_payment" target="__blank" class="text-purple-500 hover:underline active:bg-purple-600 font-bold uppercase text-xs rounded outline-none focus:outline-none mr-1 mb-1 ease-linear transition-all duration-150 flex items-center justify-center space-x-3 cursor-pointer">
                                                    <span class="text-xs"><?php _e('See Screenshot', 'salesloo'); ?></span>
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-full xl:w-1/3 text-secondary rounded h-24">
                                <div class="px-5 h-full">
                                    <div class="relative flex flex-col items-start lg:items-end justify-center h-full">
                                        <div class="text-sm text-secondary" x-text="item.note"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div class="w-full relative">
            <div class="flex flex-col sm:flex-row items-center space-y-5 sm:space-y-0">
                <div class="w-full sm:flex-1">
                </div>
                <div class="w-full sm:flex-1">
                    <template x-if="pages > 1 && items.length > 0">
                        <div class="w-full text-secondary">
                            <div class="flex h-10 items-center justify-end space-x-2">
                                <div class="h-10 w-16">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="total"></span>&nbsp;<span><?php _e('items', 'salesloo'); ?></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = 1">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 19l-7-7 7-7m8 14l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged > 1){paged = paged - 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged > 1}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span x-text="paged"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-14">
                                    <div class="h-full w-full flex justify-center items-center">
                                        <span><?php _e('of', 'salesloo'); ?></span>&nbsp;<span x-text="pages"></span>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="if(paged < pages){paged = paged + 1}">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                                <div class="h-10 w-10 rounded shadow-sm bg-secondary" @click="paged = pages">
                                    <div class="h-full w-full flex justify-center items-center" :class="{'text-primary': paged < pages}">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 5l7 7-7 7M5 5l7 7-7 7" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function getAffiliatePayout() {
        return {
            loader: true,
            items: [],
            total: 0,
            pages: 0,
            paged: 1,
            search: '',
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_affiliate_payout'); ?>',
            init() {
                this.get();
                this.$watch('paged', (val) => {
                    this.get();
                })
                this.$watch('search', (val) => {
                    this.paged = 1;
                    this.get();
                })
                this.$watch('reload', (val) => {
                    if (val) {
                        this.paged = 1;
                        this.get();
                    }
                })
            },
            get() {
                this.loader = true;
                this.items = [];
                fetch(this.ajax_url + '&paged=' + this.paged + '&search=' + this.search)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.loader = false;
                        this.items = res.items;
                        this.total = res.total;
                        this.paged = res.paged;
                        this.pages = res.pages;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });

            },
            pay(data) {
                return fetch('<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_mark_commission_paid'); ?>', {
                        method: 'post',
                        body: JSON.stringify(data),
                        headers: {
                            'Content-Type': 'application/json'
                        }
                    })
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(response => {
                        return response;
                    })
                    .catch((error) => {
                        throw error;
                    });
            },
            uploadImage(event) {
                const formData = new FormData()
                formData.append('media', event.target.files[0]);
                return fetch('<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_upload_media'); ?>', {
                        method: 'post',
                        body: formData,
                    })
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(response => {
                        return response;
                    })
                    .catch((error) => {
                        throw error;
                    });

            }
        }

    }

    function getWithdrawals() {
        return {
            loader: true,
            items: [],
            total: 0,
            pages: 0,
            paged: 1,
            search: '',
            ajax_url: '<?php echo \Salesloo\Plugin::instance()->admin_ajax->url('salesloo_get_withdrawals'); ?>',
            init() {
                this.get();
                this.$watch('paged', (val) => {
                    this.get();
                })
                this.$watch('search', (val) => {
                    this.paged = 1;
                    this.get();
                })
                this.$watch('reload', (val) => {
                    if (val) {
                        this.paged = 1;
                        this.get();
                    }
                })
            },
            get() {
                this.loader = true;
                this.items = [];
                fetch(this.ajax_url + '&paged=' + this.paged + '&search=' + this.search)
                    .then(response => {
                        if (response.status >= 200 && response.status <= 299) {
                            return response.json();
                        } else {
                            return response.json().then(error => {
                                throw error;
                            });
                        }
                    })
                    .then(res => {
                        this.loader = false;
                        this.items = res.items;
                        this.total = res.total;
                        this.paged = res.paged;
                        this.pages = res.pages;
                    })
                    .catch((error) => {
                        console.log(error);
                        throw error;
                    });

            }
        }

    }
</script>