<?php

$commissions = [];

foreach (___salesloo('commissions') as $comm) {
    $amount = salesloo_convert_money($comm->amount);

    $order    = salesloo_get_order($comm->order_id);
    $invoice = \Salesloo\Models\Invoice::join('RIGHT', 'salesloo_invoice_order', ['ID', 'invoice_id', '='])
        ->select(
            ['salesloo_invoice.*'],
            ['salesloo_invoice_order.order_id']
        )
        ->query('WHERE order_id = %s', $order->ID)
        ->first();
    $customer = get_userdata($order->user_id);
    $product  = salesloo_get_product($comm->product_id);

    $commissions[] = [
        'date'   => $comm->created_at,
        'amount' => $amount,
        'order'  => [
            'invoice'        => $invoice->number,
            'customer_email' => $customer->user_email,
            'product'        => $product->title
        ],
        'status' => [
            'value' => $comm->status,
            'print' => salesloo_get_commission_statuses($comm->status)
        ],
    ];
}

$pagination = ___salesloo('commissions')->pagination(salesloo_url_affiliate('commission/'));
$data = [
    'found'       => count($commissions) > 0 ? true : false,
    'commissions' => $commissions,
    'pagination'  => $pagination,
    'search'      => isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '',
]

?>
<div class="w-full h-full">
    <div class="text-secondary" x-data="<?php echo salesloo_make_json($data); ?>">
        <div class="flex justify-center items-center mb-10 space-y-5 sm:space-y-0">
            <div class="w-full sm:w-2/6">
                <div class="flex">
                    <div class="mr-2 relative">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z" />
                        </svg>
                    </div>
                    <h2 class="font-semibold text-lg mr-auto"><?php _e('Commission', 'salesloo'); ?></h2>
                </div>
            </div>
            <div class="w-full sm:w-4/6">
                <form method="get">
                    <div class="relative w-full">
                        <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search commission', 'salesloo'); ?>" x-model="search">

                        <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                            <span>
                                <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="bg-secondary rounded-lg shadow-sm">
            <div class="px-5 sm:px-10">
                <template x-for="[key, val] in Object.entries(commissions)">
                    <div class="py-10 duration-500 border-b border-gray-100">
                        <div class="flex items-center flex-col space-y-5 sm:flex-row">
                            <div class="w-full flex-none sm:w-auto sm:flex-grow">
                                <div class="flex items-center flex-row space-x-5">
                                    <div class="flex-1 space-y-5">
                                        <div>
                                            <div class="text-sm text-secondary"><?php _e('Invoice Number'); ?></div>
                                            <div class="text-sm font-bold" x-text="val.order.invoice"></div>
                                        </div>
                                        <div class="">
                                            <div class="text-sm text-secondary"><?php _e('Customer'); ?></div>
                                            <div class="text-sm" x-text="val.order.customer_email"></div>
                                        </div>
                                    </div>
                                    <div class="flex-1 space-y-5">
                                        <div>
                                            <div class="text-sm text-secondary"><?php _e('Date'); ?></div>
                                            <div class="text-sm" x-text="val.date"></div>
                                        </div>
                                        <div>
                                            <div class="text-sm text-secondary"><?php _e('Products'); ?></div>
                                            <div class="text-sm" x-text="val.order.product"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="w-full sm:w-1/3">
                                <div class="flex items-center flex-row space-x-5 justify-end">
                                    <div class="flex-1">
                                        <div>
                                            <div class="text-sm text-secondary"><?php _e('Amount'); ?></div>
                                            <div class="text-base font-bold text-green-500" x-text="val.amount"></div>
                                        </div>
                                    </div>
                                    <div class="flex-1">
                                        <div class="text-sm text-right font-bold">
                                            <span class="inline-block rounded-full px-4 py-1 bg-opacity-30" :class="{'text-red-400 bg-red-400': val.status.value == 'pending', 'text-yellow-400 bg-yellow-400': val.status.value== 'unpaid','text-green-400 bg-green-400': val.status.value== 'paid', 'text-purple-400 bg-purple-400': val.status.value== 'cancelled'}" x-text="val.status.print">
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
                <template x-if="!found">
                    <div class="px-5">
                        <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                            <div class="flex justify-center items-center">
                                <div class="w-full">
                                    <?php _e('No data found', 'salesloo'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
        <div x-show="pagination.show">
            <div class="p-5">
                <div class="flex text-base justify-end">
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.prev ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.prev ? pagination.prev_url : '#';">
                        <svg class="h-5 w-5 mr-2 fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_10_" d="M438,372H36.355l72.822-72.822c9.763-9.763,9.763-25.592,0-35.355c-9.763-9.764-25.593-9.762-35.355,0 l-115.5,115.5C-46.366,384.01-49,390.369-49,397s2.634,12.989,7.322,17.678l115.5,115.5c9.763,9.762,25.593,9.763,35.355,0 c9.763-9.763,9.763-25.592,0-35.355L36.355,422H438c13.808,0,25-11.193,25-25S451.808,372,438,372z"></path>
                        </svg>
                        <?php _e('Previous page', 'salesloo'); ?>
                    </a>
                    <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.next ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.next ? pagination.next_url : '#';">
                        <?php _e('Next page', 'salesloo'); ?>
                        <svg class="h-5 w-5 ml-2 fill-current" clasversion="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                            <path id="XMLID_11_" d="M-24,422h401.645l-72.822,72.822c-9.763,9.763-9.763,25.592,0,35.355c9.763,9.764,25.593,9.762,35.355,0
            l115.5-115.5C460.366,409.989,463,403.63,463,397s-2.634-12.989-7.322-17.678l-115.5-115.5c-9.763-9.762-25.593-9.763-35.355,0
            c-9.763,9.763-9.763,25.592,0,35.355l72.822,72.822H-24c-13.808,0-25,11.193-25,25S-37.808,422-24,422z"></path>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>