<?php

$browsers = ___salesloo('doughnut')->browsers;
$browsers_label = [];
$browsers_color = [];
$browsers_data = [];

foreach ((array)$browsers as $browser) {
    $browsers_label[] = $browser->name;
    $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    while (in_array($color, $browsers_color)) {
        $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    }
    $browsers_color[] = $color;
    $browsers_data[] = $browser->count;
}

$browser = [
    'labels' => $browsers_label,
    'datasets' => [
        [
            'label' => 'Browser',
            'backgroundColor' => $browsers_color,
            'data' => $browsers_data
        ],
    ]
];

$platforms = ___salesloo('doughnut')->platforms;
$platforms_label = [];
$platforms_color = [];
$platforms_data = [];

foreach ((array)$platforms as $platform) {
    $platforms_label[] = $platform->name;
    $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    while (in_array($color, $platforms_color)) {
        $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    }
    $platforms_color[] = $color;
    $platforms_data[] = $platform->count;
}

$platform = [
    'labels' => $platforms_label,
    'datasets' => [
        [
            'label' => 'platform',
            'backgroundColor' => $platforms_color,
            'data' => $platforms_data
        ],
    ]
];

$devices = ___salesloo('doughnut')->devices;
$devices_label = [];
$devices_color = [];
$devices_data = [];

foreach ((array)$devices as $device) {
    $devices_label[] = $device->name;
    $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    while (in_array($color, $devices_color)) {
        $color = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
    }
    $devices_color[] = $color;
    $devices_data[] = $device->count;
}

$device = [
    'labels' => $devices_label,
    'datasets' => [
        [
            'label' => 'device',
            'backgroundColor' => $devices_color,
            'data' => $devices_data
        ],
    ]
];


?>
<div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5">
    <div class="flex-1 shadow-sm" x-data="<?php echo salesloo_make_json($browser); ?>" x-init="$chartdoughnut($refs.chart, labels, datasets);">
        <div class="rounded-lg overflow-hidden w-full text-secondary bg-secondary py-5 px-2">
            <div class="w-full rounded-lg">
                <h3 class="text-center text-xl mb-3 font-bold"><?php _e('Browsers', 'salesloo'); ?></h3>
                <canvas x-ref="chart" class="w-full text-white"></canvas>
            </div>
        </div>
    </div>

    <div class="flex-1 shadow-sm" x-data="<?php echo salesloo_make_json($platform); ?>" x-init="$chartdoughnut($refs.chart, labels, datasets);">
        <div class="rounded-lg overflow-hidden w-full text-secondary bg-secondary py-5 px-2">
            <div class="w-full rounded-lg">
                <h3 class="text-center text-xl mb-3 font-bold"><?php _e('Platforms', 'salesloo'); ?></h3>
                <canvas x-ref="chart" class="w-full text-white"></canvas>
            </div>
        </div>
    </div>

    <div class="flex-1 shadow-sm" x-data="<?php echo salesloo_make_json($device); ?>" x-init="$chartdoughnut($refs.chart, labels, datasets);">
        <div class="rounded-lg overflow-hidden w-full text-secondary bg-secondary py-5 px-2">
            <div class="w-full rounded-lg">
                <h3 class="text-center text-xl mb-3 font-bold"><?php _e('Devices', 'salesloo'); ?></h3>
                <canvas x-ref="chart" class="w-full text-white"></canvas>
            </div>
        </div>
    </div>
</div>