<?php

$data = [
    'referers' => ___salesloo('list')->referers,
    'uris' => ___salesloo('list')->uris,
];

?>
<div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5" x-data="<?php echo salesloo_make_json($data); ?>">
    <div class="flex-1 shadow-sm bg-secondary">
        <div class="rounded-lg overflow-hidden w-full text-secondary p-5">
            <div class="w-full rounded-lg">
                <h3 class="text-base mb-3 font-bold border-b border-dashed"><?php _e('Referer', 'salesloo'); ?></h3>
                <div>
                    <template x-for="[key, val] in Object.entries(referers)">
                        <div class="flex justify-start cursor-pointer text-gray-700 hover:text-blue-400 hover:bg-gray-100 px-2 py-2 my-2">
                            <div class="flex-grow text-sm" x-text="val.domain"></div>
                            <div class="text-sm font-normal text-secondary tracking-wide" x-text="val.count"></div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>

    <div class="flex-1 shadow-sm bg-secondary">
        <div class="rounded-lg overflow-hidden w-full text-secondary p-5">
            <div class="w-full rounded-lg">
                <h3 class="text-base mb-3 font-bold border-b border-dashed"><?php _e('Page', 'salesloo'); ?></h3>
                <div>
                    <template x-for="[key, val] in Object.entries(uris)">
                        <div class="flex justify-start cursor-pointer text-gray-700 hover:text-blue-400 hover:bg-gray-100 px-2 py-2 my-2">
                            <div class="flex-grow text-sm" x-text="val.path"></div>
                            <div class="text-sm font-normal text-secondary tracking-wide" x-text="val.count"></div>
                        </div>
                    </template>
                </div>
            </div>
        </div>
    </div>
</div>