<?php
$login = salesloo_url_login('checkout/' . salesloo_get_current_product_slug());
?>
<div class="w-full text-gray-800">
    <div class="w-ful">
        <p class="mb-4"><?php echo sprintf(__('Returning Customer? %s Click here to log in %s', 'salesloo'), '<a href="' . $login . '" class="cursor-pointer text-blue-600 hover:underline">', '</a>') ?></p>
    </div>
    <div class="py-2">
        <div class="flex flex-col mb-5">
            <div class="relative">
                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>

                <input type="text" name="user[name]" class="placeholder-gray-400 pl-10 pr-4 border border-gray-200 w-full py-4 rounded focus:outline-none" placeholder="<?php _e('Full Name', 'salesloo'); ?>" required>
            </div>
        </div>

        <div class="flex flex-col mb-5">
            <div class="relative">
                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                    </svg>
                </div>

                <input type="email" name="user[email]" class="placeholder-gray-400 pl-10 pr-4 border border-gray-200 w-full py-4 rounded focus:outline-none" :class="{'border-red-500' : guest.email.error}" placeholder="<?php _e('Email', 'salesloo'); ?>" required x-model="guest.email.check.value" x-on:input.debounce="$post('', guest.email.check).then(data=>{guest.email.error = false;}).catch(error=>{guest.email.error = true});">
            </div>
        </div>

        <div class="flex flex-col mb-5">
            <div class="relative">
                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </div>

                <input type="text" name="user[phone]" class="placeholder-gray-400 pl-10 pr-4 border border-gray-200 w-full py-4 rounded focus:outline-none" placeholder="<?php _e('Phone number', 'salesloo'); ?>" required>
            </div>
        </div>

        <div class="flex flex-col mb-5">
            <div class="relative">
                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                    <span>
                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                        </svg>
                    </span>
                </div>

                <input :type="guest.password.show ? 'text' : 'password'" name="user[pass]" class="placeholder-gray-400 pl-10 pr-4 border border-gray-200 w-full py-4 rounded focus:outline-none" placeholder="<?php _e('Password', 'salesloo'); ?>" required>

                <div class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                    <span x-show="!guest.password.show" @click="guest.password.show = true">
                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                        </svg>
                    </span>
                    <span x-show="guest.password.show" style="display:none" @click="guest.password.show = false">
                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                        </svg>
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>