<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php do_action('salesloo/head'); ?>
</head>

<body class="bg-gray-200">
    <style>
        .gradient {
            background-image: linear-gradient(135deg, #684ca0 35%, #1c4ca0 100%);
        }
    </style>

    <div class="bg-gradient-to-r from-purple-900 via-purple-800 to-blue-700 text-white min-h-screen flex items-center">
        <div class="container mx-auto p-4 flex flex-wrap items-center">
            <div class="w-full md:w-5/12 text-center p-4">
                <svg class="w-40 h-40 text-gray-300 mx-auto" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
            <div class="w-full md:w-7/12 text-center md:text-left p-4">
                <div class="text-xl md:text-3xl font-medium mb-4">
                    <?php _e('Oops. This product is inactive or closed.', 'salesloo'); ?>
                </div>
                <div class="text-lg mb-8">
                    <?php _e('Looking for other product?', 'salesloo'); ?>
                </div>
                <a href="<?php echo salesloo_get_option('affiliate_general_redirect'); ?>" class="border border-white rounded p-4"><?php _e('Go to Products Page', 'salesloo'); ?></a>
            </div>
        </div>
    </div>
</body>

</html>