<?php
$data = [
    'pagination' => ___salesloo('access_pagination')
];
?>
<div class="w-full">
    <div class="border-b border-gray-200 mb-10">
        <div class="pb-10 border-blue-500 border-b-4 inline-block">
            <div class="text-4xl text-primary font-bold"><?php echo sprintf(__('Hi %s', 'salesloo'), salesloo_user_get_name(wp_get_current_user())); ?></div>
            <div class="text-lg text-secondary"><?php echo sprintf(__('Welcome to %s member area', 'salesloo'), get_bloginfo('name')); ?></div>
        </div>
    </div>
    <?php if (___salesloo('unpaid_invoices')) : ?>
        <div class="mb-20">
            <div class="rounded-lg text-secondary bg-secondary px-5 py-10 sm:px-10 shadow-sm">
                <div class="flex items-center space-x-5">
                    <div class="flex-grow">
                        <div class="flex items-cente">
                            <div class="mr-2 relative">
                                <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 14l6-6m-5.5.5h.01m4.99 5h.01M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16l3.5-2 3.5 2 3.5-2 3.5 2zM10 8.5a.5.5 0 11-1 0 .5.5 0 011 0zm5 5a.5.5 0 11-1 0 .5.5 0 011 0z" />
                                </svg>
                                <span class="flex h-2 w-2 absolute top-0 right-0">
                                    <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-red-500 opacity-75"></span>
                                    <span class="relative inline-flex rounded-full h-2 w-2 bg-red-500"></span>
                                </span>
                            </div>
                            <h2 class="font-semibold text-lg mr-auto"><?php _e('Unpaid Invoice', 'salesloo'); ?></h2>
                        </div>
                    </div>
                    <div class="flex-none">
                        <a href="<?php echo salesloo_url_transaction('invoice/'); ?>" class="text-blue-400 text-sm hover:underline">
                            <span><?php _e('See all Invoice', 'salesloo'); ?></span>
                            <svg class="w-4 h-4 inline-block" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                            </svg>
                        </a>
                    </div>
                </div>
                <div class="text-blue-600 bg-blue-100 border border-blue-400 p-5 rounded my-10">
                    <?php _e('You have an unpaid Invoice, You can pay now the invoice before it automatically cancelled on due date', 'salesloo'); ?>
                </div>
                <div class="" x-data>
                    <?php foreach (___salesloo('unpaid_invoices') as $invoice) : ?>
                        <div class="">
                            <div class="py-10 md:py-5 rounded-lg duration-500 border-b border-gray-100">
                                <div class="flex justify-center items-center flex-row">
                                    <div class="flex-grow">
                                        <div class="flex items-center justify-end w-full text-base space-x-0 space-y-5 md:space-y-0 md:space-x-5 flex-col md:flex-row">
                                            <div class="w-full md:w-1/2">
                                                <div class="text-sm text-secondary"><?php echo $invoice->created_at; ?></div>
                                                <div class="mt-1 text-secondary font-bold"><?php echo $invoice->number; ?></div>
                                                <div class="text-sm text-secondary"><?php echo $invoice->payment['method']; ?></div>
                                            </div>
                                            <div class="w-full md:w-1/2">
                                                <div class="text-secondary font-semibold">
                                                    <?php echo $invoice->products; ?>
                                                </div>
                                                <div class="text-quaternary font-bold">
                                                    <?php echo $invoice->total['print']; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-none md:w-1/3">
                                        <div class="flex items-center justify-end w-full space-x-0 sm:space-x-2 space-y-5 sm:space-y-0 flex-col sm:flex-row">
                                            <div class="flex-none sm:flex-grow text-sm text-center">
                                                <div class="text-secondary">
                                                    <?php _e('Due date on :', 'salesloo'); ?>
                                                </div>
                                                <div class="font-semibold text-tertiary" x-countdown="'<?php echo $invoice->due_date_at; ?>'"></div>
                                            </div>
                                            <a target="__blank" href="<?php echo $invoice->payment['link']; ?>" class="flex-none py-2 px-4 rounded border button-primary text-sm">
                                                <?php _e('Pay Now', 'salesloo'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="mb-20" x-data="<?php echo salesloo_make_json($data); ?>">
        <div class="text-secondary">
            <div class="flex items-center mb-10 space-y-5 sm:space-y-0">
                <div class="flex-grow">
                    <div class="flex items-center">
                        <div class="mr-2 relative">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                            </svg>
                        </div>
                        <h2 class="font-bold text-lg mr-auto text-secondary"><?php _e('Your Access', 'salesloo'); ?></h2>
                    </div>
                </div>
                <div class="w-1/3 flex-none hidden">
                    <form method="get">
                        <div class="relative w-full">
                            <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search Access', 'salesloo'); ?>" value="<?php echo ___salesloo('access_search'); ?>">

                            <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                                <span>
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                    </svg>
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="grid mt-8  gap-8 grid-cols-1 md:grid-cols-2 xl:grid-cols-2">
                <?php foreach (___salesloo('access') as $order) : ?>
                    <div class="flex flex-col">
                        <div class="bg-secondary shadow-md rounded-lg py-10 px-5">
                            <div class="flex-none lg:flex space-x-5">
                                <div class="flex-auto justify-evenly">
                                    <div class="flex flex-wrap mb-2">
                                        <div class="w-full flex-none text-xs font-medium text-gray-300">
                                            <?php _e('Purchase code', 'salesloo'); ?>
                                        </div>
                                        <div class="flex-auto text-xs text-secondary">
                                            <?php echo $order->code; ?>
                                        </div>
                                    </div>
                                    <div class="flex flex-wrap">
                                        <h2 class="flex-auto text-base font-semibold text-secondary h-8">
                                            <?php echo $order->product['title']; ?>
                                        </h2>
                                    </div>
                                    <p class="mt-3"></p>
                                    <div class="flex py-4 text-xs text-secondary" x-data="{status:'<?php echo $order->status; ?>'}">
                                        <div class="flex-1 inline-flex items-center">
                                            <p class="" :class="status == 'active' ? 'text-green-400' : 'text-tertiary'">
                                                <?php echo ucfirst($order->status); ?>
                                            </p>
                                        </div>
                                        <div class="flex-1 inline-flex items-center" x-data="{renew:'<?php echo $order->renew; ?>'}">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" :class="renew ? 'text-tertiary': 'text-secondary'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                            <p :class="renew ? 'text-tertiary': 'text-secondary'">
                                                <?php echo $order->expired_at; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex p-4 pb-2 border-t border-gray-200 "></div>
                                    <div class="flex text-sm font-medium" x-data="{renew:'<?php echo $order->renew; ?>',status:'<?php echo $order->status; ?>'}">
                                        <div class="flex-auto flex">
                                            <a href="<?php echo $order->renew ?>" target="__blank" class="mb-2 mr-2 md:mb-0 px-4 py-2 shadow-sm tracking-wider border rounded-lg button-primary inline-flex items-center" :class="renew ? '': 'hidden'">
                                                <?php _e('Renew Access', 'salesloo'); ?>
                                            </a>
                                            <a href="<?php echo $order->access; ?>" class="mb-2 md:mb-0 bg-secondary px-4 py-2 shadow-sm tracking-wider border rounded-lg button-tertiary inline-flex items-center" :class="renew && status == 'expired' ? 'hidden': ''">
                                                <?php _e('Access Product', 'salesloo'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class=" hidden lg:block h-full w-full lg:h-44 lg:w-44">
                                    <img src="<?php echo $order->product['thumbnail']; ?>" class="w-full  object-scale-down lg:object-cover">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div x-show="pagination.show">
                <div class="p-5">
                    <div class="flex text-base justify-end">
                        <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.prev ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.prev ? pagination.prev_url : '#';">
                            <svg class="h-5 w-5 mr-2 fill-current" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                                <path id="XMLID_10_" d="M438,372H36.355l72.822-72.822c9.763-9.763,9.763-25.592,0-35.355c-9.763-9.764-25.593-9.762-35.355,0 l-115.5,115.5C-46.366,384.01-49,390.369-49,397s2.634,12.989,7.322,17.678l115.5,115.5c9.763,9.762,25.593,9.763,35.355,0 c9.763-9.763,9.763-25.592,0-35.355L36.355,422H438c13.808,0,25-11.193,25-25S451.808,372,438,372z"></path>
                            </svg>
                            <?php _e('Previous page', 'salesloo'); ?>
                        </a>
                        <a class="border border-gray-300 text-gray-300 rounded-lg py-3 px-6 mr-2 flex items-center font-bold" :class="pagination.next ? 'hover:bg-blue-500 hover:text-white border-blue-500 text-quaternary' : 'cursor-not-allowed'" x-bind:href="pagination.next ? pagination.next_url : '#';">
                            <?php _e('Next page', 'salesloo'); ?>
                            <svg class="h-5 w-5 ml-2 fill-current" clasversion="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="-49 141 512 512" style="enable-background:new -49 141 512 512;" xml:space="preserve">
                                <path id="XMLID_11_" d="M-24,422h401.645l-72.822,72.822c-9.763,9.763-9.763,25.592,0,35.355c9.763,9.764,25.593,9.762,35.355,0
            l115.5-115.5C460.366,409.989,463,403.63,463,397s-2.634-12.989-7.322-17.678l-115.5-115.5c-9.763-9.762-25.593-9.763-35.355,0
            c-9.763,9.763-9.763,25.592,0,35.355l72.822,72.822H-24c-13.808,0-25,11.193-25,25S-37.808,422-24,422z"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>