<div class="w-full h-full" x-data="<?php salesloo_make_json(___salesloo('data')); ?>">
    <div class="border-b border-gray-200 mb-10">
        <div class="flex items-center mb-10">
            <h1 class="text-2xl font-bold text-secondary flex-grow" x-text="code">
                <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
            </h1>
            <div class="flex-none" x-show="renewed">
                <a target="__blank" x-bind:href="renewed" class="text-sm font-bold border rounded-lg bg-blue-500 text-white px-5 py-3 border-blue-500 hover:bg-secondary hover:text-quaternary"><?php _e('Renew Access', 'salesloo'); ?></a>
            </div>
        </div>
    </div>
    <div class="flex flex-col space-y-10">
        <div class="text-secondary bg-secondary rounded-lg shadow-sm px-5 sm:px-10 py-10 space-y-10">
            <div class="flex flex-col space-y-5">
                <div class="flex flex-col sm:flex-row space-y-5 sm:space-y-0">
                    <div class="w-full sm:w-1/2">
                        <div class="text-sm text-secondary"><?php _e('Product', 'salesloo'); ?></div>
                        <div class="text-base font-bold text-quaternary">
                            <div class="inline-block rounded" x-text="product.title">
                                <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex flex-col sm:flex-row">
                    <div class="w-full sm:w-1/2">
                        <div class="text-sm text-secondary"><?php _e('Affiliated By', 'salesloo'); ?></div>
                        <div class="text-sm font-bold">
                            <div class="text-base font-bold text-secondary" x-text="affiliated_by">
                                <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                            </div>
                        </div>
                    </div>
                    <div class="w-full sm:w-1/2">
                        <div class="text-sm text-secondary"><?php _e('Expired at', 'salesloo'); ?></div>
                        <div class="text-sm font-bold">
                            <div class="text-base font-bold text-secondary" x-text="expired_at">
                                <div class="animate-pulse h-8 mt-1 bg-gray-200 rounded w-28 border"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if (___salesloo('order')->status != 'expired') : ?>
            <?php foreach (___salesloo('access') as $access) : ?>
                <div class="bg-secondary w-full rounded-lg shadow-md p-10 flex md:flex-row flex-col space-x-2">
                    <div class="flex-grow flex items-center">
                        <h3 class="font-semibold text-lg tracking-wide text-secondary"><?php echo $access['name']; ?></h3>
                    </div>
                    <div class="md:px-2 mt-3 md:mt-0 items-center flex-none">
                        <a href="<?php echo $access['link']; ?>" class="bg-blue-500 text-white font-bold px-5 py-3 text-xs uppercase rounded-lg tracking-wider focus:outline-none hover:bg-blue-600"><?php echo $access['label']; ?></a>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php do_action('salesloo/order/access/after'); ?>
        <?php endif; ?>
        <?php do_action('salesloo/order/end'); ?>
    </div>
</div>