<?php
global $___invoice;

foreach ($___invoice->summary['products'] as $product_id => $p) {
    $product = salesloo_get_product($product_id);
    $checkout = salesloo_url_checkout($product->slug);
    break;
}

$buyer = get_userdata($___invoice->user_id);

$data = [
    'recipient' => [
        'say'     => sprintf(__('Hello %s', 'salesloo'), sanitize_text_field($buyer->first_name)),
        'message' => __('Sorry, your invoice has been canceled because it has exceeded the payment duedate. Please do repurchase!', 'salesloo'),
    ]
];
?>
<?php salesloo_header(); ?>
<div class="min-h-screen w-full bg-blue-50">
    <div class="py-5">
        <div class="justify-center items-center flex">
            <?php salesloo_template_branding(); ?>
        </div>
    </div>
    <main class="text-gray-800 mb-10" x-data="<?php salesloo_make_json($data); ?>">
        <div class=" mx-auto" style="width: 99%; max-width: 640px;">
            <div class="w-full px-3">
                <div class="p-5 bg-secondary shadow-sm rounded-lg">
                    <div class="mb-5 pb-5 border-b border-dashed">
                        <div class="text-xl font-bold" x-html="recipient.say">
                            <div class="animate-pulse h-8 bg-gray-200 rounded w-28 border"></div>
                        </div>
                        <div class="text-sm" x-html="recipient.message">
                            <div class="animate-pulse h-6 mt-1 bg-gray-200 rounded w-full border"></div>
                        </div>
                    </div>
                    <div class="flex w-full mt-5">
                        <a href="<?php echo $checkout; ?>" type="submit" class="flex items-center justify-center focus:outline-none text-white text-sm sm:text-base rounded-lg py-4 w-full transition duration-150 ease-in shadow-md bg-blue-600 hover:bg-blue-700">
                            <span class="font-bold text-base tracking-wider"><?php echo _e('Purchase Again', 'salesloo'); ?></span>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </main>
</div>
<?php salesloo_footer(); ?>