<div class="text-primary">
    <div class="flex items-center mb-10 space-y-5 sm:space-y-0">
        <div class="w-full sm:w-2/6">
            <div class="flex items-center">
                <div class="mr-2 relative">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                    </svg>
                </div>
                <h2 class="font-semibold text-lg mr-auto"><?php _e('All Products', 'salesloo'); ?></h2>
            </div>
        </div>
        <div class="w-full sm:w-4/6">
            <form method="get">
                <div class="relative w-full">
                    <input name="s" class="text-base placeholder-gray-300 pl-4 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Search Product', 'salesloo'); ?>" value="<?php echo salesloo_get_current_search(); ?>">

                    <button type="submit" class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
    <div class="flex flex-col space-y-5">
        <?php foreach (___salesloo('products') as $p) : ?>
            <div class="bg-secondary shadow-sm rounded-lg w-full py-10 px-5 sm:px-10">
                <div class="overflow-hidden flex flex-col md:flex-row space-x-0 md:space-x-5 space-y-5 md:space-y-0 items-center">
                    <div class="w-full flex-none md:w-auto md:flex-grow">
                        <div class="flex items-center space-x-5">
                            <div class="bg-center h-20 w-20 bg-contain bg-no-repeat rounded-full" style="background-image: url('<?php echo $p->thumbnail; ?>')">
                                <div class="justify-end hidden">
                                    <svg class="h-6 w-6 text-white fill-current" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                        <path d="M12.76 3.76a6 6 0 0 1 8.48 8.48l-8.53 8.54a1 1 0 0 1-1.42 0l-8.53-8.54a6 6 0 0 1 8.48-8.48l.76.75.76-.75zm7.07 7.07a4 4 0 1 0-5.66-5.66l-1.46 1.47a1 1 0 0 1-1.42 0L9.83 5.17a4 4 0 1 0-5.66 5.66L12 18.66l7.83-7.83z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="flex-grow">
                                <div class="text-md font-bold text-secondary"><?php echo $p->title; ?></div>
                                <div class="mt-1">
                                    <span class="text-sm text-pink-700 font-semibold"><?php echo $p->price; ?></span>
                                    <span class="text-secondary text-sm"><?php echo $p->duration; ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="w-full md:w-auto flex-none">
                        <div class="flex items-center justify-end space-x-2">
                            <div class="flex-1 md:flex-none">
                                <a target="__blank" class="justify-center flex items-center px-4 py-2 text-sm font-semibold rounded-lg border border-blue-400 text-blue-400 hover:opacity-50" href="<?php echo $p->salespage; ?>">
                                    <span class="ml-2 text-sm"><?php _e('See detail', 'salesloo'); ?></span>
                                </a>
                            </div>
                            <div class="flex-1 md:flex-none">
                                <a target="__blank" class="justify-center flex items-center px-4 py-2 text-sm font-semibold rounded-lg border border-blue-400 bg-blue-400 text-white hover:opacity-50" href="<?php echo $p->buy; ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                    </svg>
                                    <span class="ml-2 text-sm"><?php echo _e('Buy now', 'salesloo'); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
        <?php if (!___salesloo('products')) : ?>
            <div class="px-5">
                <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                    <div class="flex justify-center items-center">
                        <div class="w-full">
                            <?php _e('Ups no product found', 'salesloo'); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php salesloo_query_pagination(___salesloo('collection'), salesloo_url_product()); ?>
</div>