<div class="bg-secondary rounded-lg text-secondary mt-8 shadow-sm" x-data="<?php salesloo_make_json(___salesloo('data')); ?>">
    <div class="flex items-center py-5 px-5 sm:px-10 border-b border-gray-100 dark:border-dark-5">
        <div class="w-full">
            <div class="flex items-center text-secondary">
                <div class="mr-2 relative">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                    </svg>
                </div>
                <h2 class="font-semibold text-lg mr-auto"><?php _e('Edit Profile', 'salesloo'); ?></h2>
            </div>
        </div>
    </div>
    <div class="px-5 sm:px-10 py-5">
        <form action="#" method="POST" x-on:submit="$store.loading = true;$post('',ajax.data).then((response) => {$store.loading = false}).catch(error => {$store.loading = false;});event.preventDefault();">
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label class="text-base tracking-wide font-bold"><?php _e('Avatar', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <img :src="ajax.data.avatar" class="object-cover rounded border border-gray-200" style="width: 100px; height: 100px;">
                                <input class="mt-2" name="avatar" type="file" accept="image/*" x-on:change="(event)=>{upload.file = event.target.files[0];$upload('',upload);ajax.data.avatar = URL.createObjectURL(event.target.files[0]); }">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label class="text-base tracking-wide font-bold"><?php _e('Username', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <input type="text" name="username" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900 bg-gray-100" placeholder="<?php _e('Email or Username', 'salesloo'); ?>" x-model="ajax.data.username" readonly>
                            </div>
                            <div class="text-sm italic text-secondary">
                                <?php _e('Username can\'t be changed', 'salesloo'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label class="mb-1 text-base tracking-wide font-bold"><?php _e('Full Name', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <input type="text" name="first_name" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('First Name', 'salesloo'); ?>" x-model="ajax.data.first_name">
                            </div>
                        </div>
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.121 17.804A13.937 13.937 0 0112 16c2.5 0 4.847.655 6.879 1.804M15 10a3 3 0 11-6 0 3 3 0 016 0zm6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <input type="text" name="last_name" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Last Name', 'salesloo'); ?>" x-model="ajax.data.last_name">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label class="mb-1 text-base tracking-wide font-bold"><?php _e('Email', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                    </svg>
                                </div>

                                <input type="email" name="email" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900 bg-gray-100" placeholder="<?php _e('Email', 'salesloo'); ?>" x-model="ajax.data.email">
                            </div>
                            <div class="text-sm italic text-secondary">
                                <?php _e('Email can\'t be changed', 'salesloo'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label for="username" class="mb-1 text-base tracking-wide font-bold"><?php _e('Phone', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                    </svg>
                                </div>

                                <input type="text" name="user" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" placeholder="<?php _e('Phone number', 'salesloo'); ?>" x-model="ajax.data.phone">
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="flex w-full flex-row-reverse">
                <div class="w-1/2">
                    <button type="submit" class="flex items-center justify-center focus:outline-none text-white text-sm sm:text-base bg-blue-900 hover:bg-blue-800 rounded-lg py-4 w-full transition duration-150 ease-in">
                        <span class="mr-2 font-bold text-sm"><?php _e('Update', 'salesloo'); ?></span>
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4" />
                            </svg>
                        </span>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>