<?php

$data = [
    'ajax' => [
        'url'    => '',
        'method' => 'post',
        'data'   => [
            'pass1'      => '',
            'pass2'      => '',
            'nonce'      => salesloo_create_nonce(),
            'action'     => 'update_password'
        ]
    ],
    'pass1_show' => false,
    'pass2_show' => false,
];
?>
<div class="bg-secondary rounded-lg text-secondary mt-8 shadow-sm" x-data="<?php salesloo_make_json($data); ?>">
    <div class="flex items-center py-5 px-5 sm:px-10 border-b border-gray-100 dark:border-dark-5">
        <div class="w-full">
            <div class="flex items-center text-secondary">
                <div class="mr-2 relative">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 11V7a4 4 0 118 0m-4 8v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2z" />
                    </svg>
                </div>
                <h2 class="font-semibold text-lg mr-auto"><?php _e('Update Password', 'salesloo'); ?></h2>
            </div>
        </div>
    </div>
    <div class="py-5 px-5 sm:px-10">
        <form action="#" method="POST" x-on:submit="$store.loading = true;$post('', ajax.data).then((response) => {$store.loading = false}).catch(error => {$store.loading = false;});event.preventDefault();">
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label class="text-base tracking-wide font-bold"><?php _e('Password', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                    </svg>
                                </div>

                                <input type="password" :type="pass1_show ? 'text' : 'password'" name="password" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" x-model="ajax.data.pass1" required placeholder="********">

                                <div class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                                    <span x-show="!pass1_show" @click="pass1_show = true">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </span>
                                    <span x-show="pass1_show" @click="pass1_show = false" style="display:none">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="flex space-x-5 mb-6">
                <div class="w-40">
                    <div class="flex items-center py-3">
                        <label for="username" class="mb-1 text-base tracking-wide font-bold"><?php _e('Confirm Password', 'salesloo'); ?></label>
                    </div>
                </div>
                <div class="flex-grow">
                    <div class="flex space-x-4">
                        <div class="flex-1">
                            <div class="relative">
                                <div class="inline-flex items-center justify-center absolute left-0 top-0 h-full w-10 text-secondary">
                                    <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                    </svg>
                                </div>

                                <input type="password" :type="pass2_show ? 'text' : 'password'" name="password" class="text-base placeholder-gray-300 pl-10 pr-4 rounded-lg border border-gray-200 w-full py-3 focus:outline-none focus:border-blue-900" x-model="ajax.data.pass2" required placeholder="********">

                                <div class="inline-flex items-center justify-center absolute right-0 top-0 h-full w-10 text-secondary cursor-pointer">
                                    <span x-show="!pass2_show" @click="pass2_show = true">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </span>
                                    <span x-show="pass2_show" @click="pass2_show = false" style="display:none">
                                        <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21" />
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="flex w-full flex-row-reverse">
                <div class="w-1/2">
                    <button type="submit" class="flex items-center justify-center focus:outline-none text-white text-sm sm:text-base bg-blue-900 hover:bg-blue-800 rounded-lg py-4 w-full transition duration-150 ease-in">
                        <span class="mr-2 font-bold text-sm"><?php _e('Update', 'salesloo'); ?></span>
                        <span>
                            <svg class="h-4 w-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v9a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-3m-1 4l-3 3m0 0l-3-3m3 3V4" />
                            </svg>
                        </span>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>