<div class="min-h-screen w-full" x-data="{reload: 'start', nonce:'<?php echo salesloo_create_nonce(); ?>', warning: '<?php echo Salesloo\Renew::instance()->get_warning(); ?>', submit: false}">
    <div class="relative">
        <div class="h-full w-full max-w-screen-xl mx-auto px-2 sm:px-5">
            <template x-if="warning">
                <div class="my-3 text-sm text-left text-orange-400 bg-orange-200 h-12 flex items-center p-4 rounded-lg border border-orange-300" role="alert">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" class="w-6 h-6 mx-2 stroke-current">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                    <span x-text="warning"></span>
                </div>
            </template>
        </div>
    </div>
    <form method="post">
        <div class="relative pt-10">
            <div class="h-full w-full max-w-screen-sm mx-auto px-2 sm:px-5">
                <div class="h-full w-full flex flex-col space-x-0 space-y-5">
                    <div class="flex-1">
                        <div class="flex flex-col space-y-5">
                            <div class="bg-secondary shadow-sm rounded-lg p-5">
                                <div class="flex flex-col space-y-5">
                                    <div class="relative">
                                        <div class="flex justify-center">
                                            <div class="flex-grow">
                                                <h3 class="text-base text-gray-700 font-semibold"><?php _e('Renew Access', 'salesloo'); ?></h3>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="relative">
                                        <div class="flex flex-col space-y-5">
                                            <?php foreach (Salesloo\Renew::instance()->get_items() as $product) : ?>
                                                <div class="border rounded-lg border-gray-100 px-5 py-5 xs:px-5">
                                                    <div class="w-full flex justify-center space-x-5">
                                                        <div class="w-16 h-16 xs:w-20 sm:h-auto sm:w-24">
                                                            <div class="flex justify-center items-center h-full w-full rounded-lg bg-blue-200 p-1">
                                                                <img class="object-cover object-center rounded-lg w-full" src="<?php echo $product->get_thumbnail_url(); ?>">
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow">
                                                            <div class="flex flex-col justify-center items-center space-x-0 h-full">
                                                                <div class="w-full flex-none">
                                                                    <h1 class="text-base sm:text-lg font-semibold text-primary"><?php echo $product->title; ?></h1>
                                                                </div>
                                                                <div class="w-full flex-none">
                                                                    <div class="flex flex-row items-center justify-center h-full">
                                                                        <div class="text-base sm:text-lg text-blue-600 font-bold flex-none">
                                                                            <?php echo salesloo_convert_money(Salesloo\Renew::instance()->get_price()); ?>
                                                                        </div>
                                                                        <div class="text-xs sm:text-base text-secondary flex-grow pl-2">
                                                                            /<?php echo salesloo_translate_product_duration($product->duration); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex-1">
                        <div class="flex flex-col space-y-5">
                            <div class="bg-secondary shadow-sm rounded-lg p-5">
                                <div class="flex flex-col space-y-10">
                                    <div class="w-full" x-data="{payment_method: '<?php echo \Salesloo\Renew::instance()->payment_method; ?>',open: false, close_height: 96, open_height: 0}" @click.outside="open = false" x-effect="if(payment_method){$post('',{nonce: nonce, action: 'choose_payment_method', method:payment_method}).then(res=>{reload = payment_method; submit= true}).catch(err=>{reload = payment_method;})}">
                                        <div class="flex flex-col space-y-5">
                                            <div class="relative">
                                                <div class="flex justify-center items-center">
                                                    <div class="flex-grow">
                                                        <h3 class="text-base sm:text-xl text-gray-700 font-semibold"><?php _e('Payment Method', 'salesloo'); ?></h3>
                                                    </div>
                                                    <div class="w-20">
                                                        <div class="text-right w-full cursor-pointer" x-show="payment_method" x-data="{tooltip:'<?php _e('Change payment method', 'salesloo'); ?>'}" @click="payment_method = '';open=true;">
                                                            <span class="text-quaternary text-xs sm:text-sm font-bold" x-tooltip="tooltip"><?php echo _e('Change', 'salesloo'); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="relative transition-all duration-150 ease-in overflow-hidden" :style="open ? {height: 'auto'}:{height: close_height+'px'}">
                                                <div class="w-full">
                                                    <div class="mb-5 w-full" x-show="open==false && !payment_method" x-transition>
                                                        <button type="button" class="w-full border border-gray-100 rounded-lg h-24" @click="open = !open">
                                                            <div class="w-full h-full flex flex-col sm:flex-row justify-center space-x-0 sm:space-x-5">
                                                                <div class="flex-grow">
                                                                    <div class="flex justify-center items-center">
                                                                        <div class="flex-1">
                                                                            <div class="w-full flex flex-col items-start space-y-0 pr-5">
                                                                                <div class="text-sm sm:text-base font-semibold text-primary w-full text-left pl-10">
                                                                                    <span class="text-blue-700"><?php _e('Choose payment method', 'salesloo'); ?></span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="w-12 h-24">
                                                                            <div class="w-full h-full flex items-center justify-center text-secondary">
                                                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                                                                                </svg>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </button>
                                                    </div>

                                                    <div class="flex flex-col space-y-5 overflow-hidden transition-all duration-150 ease-in pb-5" x-ref="payment_methods">
                                                        <?php foreach (\Salesloo\Plugin::instance()->payment_method->active() as $key => $method) : ?>
                                                            <button type="button" x-data="" x-if="if(payment_method == '<?php echo $key; ?>'){$el.parentNode.prepend($el);}" class="w-full border border-gray-100 rounded-lg h-24 hover:shadow-lg" @click="payment_method = '<?php echo $key; ?>';$el.parentNode.prepend($el);open=!open">
                                                                <div class="w-full h-full flex flex-col sm:flex-row justify-center space-x-0 sm:space-x-5">
                                                                    <div class="flex-grow">
                                                                        <div class="flex justify-center items-center">
                                                                            <div class="w-12 lg:w-20 h-24">
                                                                                <div class="flex justify-center items-center h-full w-full">
                                                                                    <template x-if="payment_method == '<?php echo $key; ?>'">
                                                                                        <div class="w-6 h-6 text-quaternary rounded-full">
                                                                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                                                                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                                                                                            </svg>
                                                                                        </div>
                                                                                    </template>
                                                                                    <template x-if="payment_method != '<?php echo $key; ?>'">
                                                                                        <div class="w-5 h-5 border border-gray-400 rounded-full"></div>
                                                                                    </template>
                                                                                </div>
                                                                            </div>
                                                                            <div class="flex-1">
                                                                                <div class="w-full flex flex-col items-start space-y-0 pr-5">
                                                                                    <div class="text-sm lg:text-base font-semibold text-primary w-full text-left">
                                                                                        <?php echo $method->get_title(); ?>
                                                                                    </div>
                                                                                    <div class="text-xs lg:text-sm text-secondary w-full text-left">
                                                                                        <?php echo $method->get_description(); ?>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="hidden sm:block w-28 lg:w-36 h-24 pr-4 lg:pr-10">
                                                                        <div class="w-full h-full flex items-center justify-end">
                                                                            <img src="<?php echo $method->get_icon(); ?>" class="h-3 lg:h-4">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </button>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="w-full">
                                        <div class="flex flex-col space-y-5">
                                            <div class="relative">
                                                <div class="flex justify-center">
                                                    <div class="flex-grow">
                                                        <h3 class="text-base sm:text-xl text-gray-700 font-semibold"><?php _e('Order Summary', 'salesloo'); ?></h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="relative">
                                                <div class="flex flex-col space-y-5">
                                                    <div class="relative" x-data="{skeleton:true, summary: [], total: ''}" x-effect="if(reload){skeleton=true;$get('?action=summary&nonce='+nonce).then(res=>{summary = res.summaries; total = res.total; skeleton=false}).catch(error=>{console.log(error)})};">
                                                        <template x-if="skeleton">
                                                            <div class="w-full">
                                                                <div class="animate-pulse flex space-x-4">
                                                                    <div class="flex-1 py-1">
                                                                        <div class="space-y-4">
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-1 py-1">
                                                                        <div class="space-y-4">
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                                                                            <div class="h-4 bg-gray-300 rounded w-5/6 ml-auto"></div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="animate-pulse flex space-x-4 mt-10">
                                                                    <div class="flex-1 py-1">
                                                                        <div class="space-y-2">
                                                                            <div class="h-6 bg-gray-300 rounded w-5/6"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="flex-1 py-1">
                                                                        <div class="space-y-2">
                                                                            <div class="h-6 bg-gray-300 rounded w-5/6 ml-auto"></div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </template>
                                                        <div class="text-sm sm:text-base" x-show="!skeleton">
                                                            <template x-for="[key, val] in Object.entries(summary)" :key="key">
                                                                <div class="my-5">
                                                                    <div class="flex items-center justify-center w-full cursor-pointer text-gray-100" x-show="val.value">
                                                                        <div class="w-1/2">
                                                                            <div class="text-secondary font-semibold" x-html="val.label"></div>
                                                                        </div>
                                                                        <div class="w-1/2">
                                                                            <div class="font-bold text-right" :class="{'text-secondary' : val.operation == '+', 'text-green-400' : val.operation == '-', 'text-primary' : !val.operation}" x-html="val.print"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="text-xs italic text-blue-400" x-show="val.message" x-html="val.message"></div>
                                                                </div>
                                                            </template>
                                                        </div>
                                                        <template x-if="total && !skeleton">
                                                            <div class="text-sm sm:text-base border-t border-dashed mt-5 sm:mt-10 pt-5 sm:pt-10">
                                                                <div class="flex items-center justify-center w-full cursor-pointer text-gray-100">
                                                                    <div class="flex-grow">
                                                                        <div class="text-gray-700 font-bold" x-html="total.label"></div>
                                                                    </div>
                                                                    <div class="flex-none">
                                                                        <div class="font-bold text-right text-tertiary text-lg sm:text-2xl" x-html="total.value > 0 && total.converted.print ? total.converted.print : total.print"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="text-xs italic text-secondary" x-show="total.message" x-html="total.value > 0 ? total.message : ''"></div>
                                                            </div>
                                                        </template>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex flex-col-reverse space-y-5 space-y-reverse space-x-0">
                                <div class="flex-1 text-secondary" x-data="{fullname: '', username: ''}" x-effect="if(reload){$get('?action=affiliated_by&nonce='+nonce).then(res=>{fullname = res.fullname;username = res.username}).catch(error=>{console.log(error)})};">
                                    <template x-if="username">
                                        <div class="w-full h-full flex flex-col items-center justify-center">
                                            <div class="text-sm text-secondary">
                                                <?php _e('Affiliated By', 'salesloo'); ?>
                                            </div>
                                            <div class="text-sm font-semibold">
                                                <span x-text="fullname"></span>
                                            </div>
                                            <div class="text-xs text-secondary">
                                                (<span x-text="username"></span>)
                                            </div>
                                        </div>
                                    </template>
                                </div>
                                <div class="flex-1">
                                    <div class="flex flex-col space-y-3">
                                        <div class="w-full">
                                            <button :type="submit ? 'submit' : 'button'" class="w-full px-auto py-5 button-primary outline-none md:px-4 hover:bg-gray-600 focus:outline-none active:outline-none border border-blue-600 rounded-lg">
                                                <span class="text-sm font-bold"><?php echo salesloo_get_option('checkout_button_label'); ?></span>
                                            </button>
                                        </div>
                                        <div class="w-full">
                                            <div class="text-base flex items-center justify-center space-x-2 text-secondary">
                                                <span>
                                                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M20.91 11.1203C20.91 16.0103 17.36 20.5903 12.51 21.9303C12.18 22.0203 11.82 22.0203 11.49 21.9303C6.63999 20.5903 3.09 16.0103 3.09 11.1203V6.73028C3.09 5.91028 3.71001 4.98028 4.48001 4.67028L10.05 2.39031C11.3 1.88031 12.71 1.88031 13.96 2.39031L19.53 4.67028C20.29 4.98028 20.92 5.91028 20.92 6.73028L20.91 11.1203Z" stroke="#888888" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M12 12.5C13.1046 12.5 14 11.6046 14 10.5C14 9.39543 13.1046 8.5 12 8.5C10.8954 8.5 10 9.39543 10 10.5C10 11.6046 10.8954 12.5 12 12.5Z" stroke="#888888" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M12 12.5V15.5" stroke="#888888" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                                    </svg>

                                                </span>
                                                <span class="font-semibold">
                                                    <?php _e('Secure Payment', 'salesloo'); ?>
                                                </span>
                                            </div>
                                            <div class="prose-sm text-secondary text-center">
                                                <?php echo salesloo_get_option('checkout_information'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php wp_nonce_field('salesloo-checkout', '__nonce'); ?>
    </form>
    <div class="h-10">

    </div>
</div>