<div>
    <div class="text-primary">
        <div class="flex items-center mb-5 space-y-5 sm:space-y-0">
            <div class="w-full sm:w-2/6">
                <div class="flex items-center">
                    <div class="mr-2 relative">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                        </svg>
                    </div>
                    <h2 class="font-semibold text-lg mr-auto text-secondary"><?php _e('License', 'salesloo'); ?></h2>
                </div>
            </div>
        </div>
        <div class="shadow-sm p-10 rounded-lg bg-secondary">
            <div class="mb-10 flex space-y-10 flex-col">
                <div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5 justify-center items-center">
                    <div class="text-secondary w-full lg:flex-1">
                        <div class="flex items-center justify-center space-x-4">
                            <div class="w-14 h-14 border-4 border-gray-200 bg-gray-400 text-white rounded-full flex justify-center items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <p class="text-sm text-secondary"><?php _e('License Code', 'salesloo'); ?></p>
                                <p class="text-lg font-semibold"><?php echo ___salesloo('purchase_code'); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="text-green-500 w-full lg:flex-1">
                        <div class="flex items-center justify-center space-x-4">
                            <div class="w-14 h-14 border-4 border-green-200 bg-green-400 text-white rounded-full flex justify-center items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <p class="text-sm text-secondary"><?php _e('Activated', 'salesloo'); ?></p>
                                <p class="text-2xl font-bold tracking-wider"><?php echo ___salesloo('license')->used . '/' . ___salesloo('license')->limit; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex flex-col lg:flex-row space-y-5 lg:space-y-0 lg:space-x-5 justify-center items-center">
                    <div class="text-secondary w-full lg:flex-1">
                        <div class="flex items-center justify-center space-x-4">
                            <div class="w-14 h-14 border-4 border-gray-200 bg-gray-400 text-white rounded-full flex justify-center items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <p class="text-sm text-secondary"><?php _e('Expired', 'salesloo'); ?></p>
                                <p class="text-lg font-semibold"><?php echo ___salesloo('license')->expired; ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="text-quaternary w-full lg:flex-1">
                        <div class="flex items-center justify-center space-x-4">
                            <div class="w-14 h-14 border-4 border-blue-200 bg-blue-400 text-white rounded-full flex justify-center items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5.636 18.364a9 9 0 010-12.728m12.728 0a9 9 0 010 12.728m-9.9-2.829a5 5 0 010-7.07m7.072 0a5 5 0 010 7.07M13 12a1 1 0 11-2 0 1 1 0 012 0z" />
                                </svg>
                            </div>
                            <div class="flex-grow">
                                <p class="text-sm text-secondary"><?php _e('Status', 'salesloo'); ?></p>
                                <p class="text-2xl font-bold tracking-wider"><?php echo salesloo_get_order_statuses(___salesloo('access')->status); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="" x-data>
                <template x-for="[key, val] in Object.entries(<?php salesloo_make_json(___salesloo('active_hosts')); ?>)">
                    <div class="py-5 rounded-lg duration-500 border-b border-gray-100">
                        <div class="flex justify-start md:justify-center items-center flex-col md:flex-row md:space-x-5 space-y-5 md:space-y-0">
                            <div class="flex-1 w-full md:w-auto md:flex-none">
                                <div class="mt-1 text-base text-secondary font-bold" x-text="val.number"></div>
                            </div>
                            <div class="flex-1 w-full md:w-auto md:flex-none">
                                <div class="text-sm text-secondary">
                                    <?php _e('Host', 'salesloo'); ?>
                                </div>
                                <div class="mt-1 text-base text-secondary font-bold" x-text="val.host"></div>
                            </div>
                            <div class="flex-1 w-full md:w-auto md:flex-grow">
                                <div class="flex items-center justify-start md:justify-end w-full text-sm text-secondary">
                                    <div class="w-full">
                                        <div class="flex flex-col items-center justify-start md:justify-end w-full">
                                            <div class="text-base w-full text-left md:text-right" x-text="val.activate_at"></div>
                                            <div class="text-base w-full text-left md:text-right" x-text="val.last_checked"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-1 w-full md:w-auto md:flex-none" @click="$confirm('want to deactivate license', function(){$post('', val.delete).then(res=>{$el.parentNode.parentNode.remove();})})">
                                <div class="flex items-center justify-end w-full text-base text-quaternary hover:underline">
                                    <div class="w-full">
                                        <div class="flex flex-col items-center justify-end w-full cursor-pointer">
                                            <?php _e('Deactivate License', 'salesloo'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div>