<?php

$expired = '';

if (___salesloo('order')->status == 'active') {
    $expired = __('Expired: ', 'salesloo') . date('Y-m-d H:00', strtotime(___salesloo('order')->expired_at));
}

$logs = [];

foreach (___salesloo('order')->log() as $log) {
    $logs[] = [
        'date' => $log->created_at,
        'note' => $log->note
    ];
}


?>
<div class="">
    <div class="flex flex-col text-primary">
        <div class="w-full border-b border-dashed py-5">
            <div class="text-sm text-secondary">
                <?php _e('Status', 'salesloo'); ?>
            </div>
            <div class="text-base font-bold">
                <?php echo salesloo_get_order_statuses(___salesloo('order')->status); ?>
            </div>
        </div>
        <div class="w-full border-b border-dashed py-5">
            <div class="text-sm text-secondary">
                <?php _e('Purchase Code', 'salesloo'); ?>
            </div>
            <div class="text-base font-bold">
                <?php echo ___salesloo('order')->code; ?>
            </div>
        </div>
        <div class="w-full border-b border-dashed py-5">
            <div class="text-sm text-secondary">
                <?php _e('Expired', 'salesloo'); ?>
            </div>
            <div class="text-base font-bold">
                <?php echo ___salesloo('order')->expired_at; ?>
            </div>
        </div>
    </div>
    <div class="bg-secondary rounded-lg text-primary">
        <div class="p-5">
            <?php foreach ((array)$logs as $key => $log) : ?>
                <?php
                $class_posisiton = 'items-center';
                $class_width = 'h-full';
                if (0 == $key) {
                    $class_posisiton = 'items-end';
                    $class_width = 'h-1/2';
                }

                if (count($logs) == $key) {
                    $class_posisiton = 'items-start';
                    $class_width = 'h-1/2';
                }
                ?>
                <div class="flex">
                    <div class="mr-10 md:mx-auto relative">
                        <div class="h-full w-4 flex justify-center <?php echo $class_posisiton; ?>">
                            <div class="w-0.5 bg-blue-800 pointer-events-none <?php echo $class_width; ?>"></div>
                        </div>
                        <div class="w-4 h-4 absolute top-1/2 -mt-3 rounded-full bg-blue-500 shadow"></div>
                    </div>
                    <div class="p-5 flex-grow">
                        <h3 class="font-semibold text-sm mb-1"><?php echo $log['date']; ?></h3>
                        <p class="leading-tight text-justify">
                            <?php echo $log['note']; ?>
                        </p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>