<?php
namespace SlimSEOPro;

use SlimSEO\Updater\Tab;
use eLightUp\PluginUpdater\Manager;
use SlimSEO\Updater\Settings as UpdaterSettings;

class Loader {
	public function __construct() {
		$features = [
			'link-manager',
			'schema',
		];

		foreach ( $features as $feature ) {
			if ( Settings::is_feature_active( $feature ) ) {
				require SLIM_SEO_PRO_DIR . "/modules/slim-seo-{$feature}/slim-seo-{$feature}.php";
			}
		}

		if ( is_admin() ) {
			$manager = $this->updater();
		}

		new Activator();
		new Settings();

		$this->hooks();
	}

	private function hooks() {
		add_filter( 'slim_seo_link_manager_plugin_warning_messages', [ $this, 'plugin_warning_messages' ] );
		add_filter( 'slim_seo_schema_plugin_warning_messages', [ $this, 'plugin_warning_messages' ] );
		add_filter( 'slim_seo_link_manager_manager_args', [ $this, 'manager_args' ] );
		add_filter( 'slim_seo_schema_manager_args', [ $this, 'manager_args' ] );
		add_filter( 'elightup_plugin_updater_disallow_setup', [ $this, 'disallow_setup' ], 10, 2 );
	}

	private function updater() {
		Tab::setup();

		$manager           = new Manager( [
			'api_url'            => 'https://wpslimseo.com/index.php',
			'my_account_url'     => 'https://wpslimseo.com/my-account/',
			'buy_url'            => 'https://wpslimseo.com/products/slim-seo-pro/',
			'slug'               => 'slim-seo-pro',
			'settings_page'      => admin_url( 'options-general.php?page=slim-seo#license' ),
			'settings_page_slug' => 'slim-seo',
		] );
		$settings          = new UpdaterSettings( $manager, $manager->checker, $manager->option );
		$manager->settings = $settings;
		$manager->setup();

		return $manager;
	}

	public function plugin_warning_messages( $messages ) {
		return Common::plugin_warning_messages();
	}

	public function manager_args( $args ) {
		$args['plugin_id'] = $args['slug'];
		$args['buy_url']   = 'https://wpslimseo.com/products/slim-seo-pro/';
		$args['slug']      = 'slim-seo-pro';

		return $args;
	}

	public function disallow_setup( $disallow, $plugin_id ) {
		if ( in_array( $plugin_id, [ 'slim-seo-link-manager', 'slim-seo-schema' ], true ) ) {
			$disallow = true;
		}

		return $disallow;
	}
}
