<?php
namespace SlimSEOPro\ContentAnalysis\Integrations;

class Bricks extends Base {
	public function is_active(): bool {
		return defined( 'BRICKS_VERSION' );
	}

	protected function get_content( int $post_id ): string {
		\Bricks\Database::$page_data['preview_or_post_id'] = $post_id;

		if ( ! \Bricks\Helpers::render_with_bricks( $post_id ) ) {
			return '';
		}

		$bricks_data = get_post_meta( $post_id, BRICKS_DB_PAGE_CONTENT, true );

		return $bricks_data ? (string) \Bricks\Frontend::render_data( $bricks_data ) : '';
	}
}
