<?php
/**
 * Main class file to initialize all the classes of business package.
 *
 * @since 1.0.2
 * @package sureforms-pro
 */

namespace SRFM_Pro\Inc\Business;

use SRFM\Inc\Helper;
use SRFM_Pro\Inc\Business\Custom_App\Load;
use SRFM_Pro\Inc\Business\Custom_Post_Type\Init as Custom_Post_Type;
use SRFM_Pro\Inc\Business\Pdf\Pdf;
use SRFM_Pro\Inc\Business\Repeater\Init as Repeater;
use SRFM_Pro\Inc\Business\User_Registration\Init as User_Registration_Init;
use SRFM_Pro\Inc\Traits\Get_Instance;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Initialize business package.
 *
 * @since 1.0.2
 */
class Init {
	use Get_Instance;

	/**
	 * Initialize business package.
	 *
	 * @since 1.0.2
	 * @return void
	 */
	public function __construct() {
		$this->load_classes();
	}

	/**
	 * Load the necessary classes of the business package.
	 *
	 * @since 1.0.2
	 * @return void
	 */
	public function load_classes() {
		if ( method_exists( Helper::class, 'is_suretriggers_ready' ) && Helper::is_suretriggers_ready() ) {
			// Only load custom app if SureTriggers plugin is ready.
			Load::get_instance();
		}

		// Load Calculation feature.
		Calculation::get_instance();
		Custom_Post_Type::get_instance();

		// Load Repeater feature.
		Repeater::get_instance();
		// Load PDF feature.
		Pdf::get_instance();
		// Load User Registration feature.
		User_Registration_Init::get_instance();
	}
}
