<?php
/**
 * Sureforms Login Markup Class file.
 *
 * @package sureforms-pro.
 * @since 1.8.0
 */

namespace SRFM_Pro\Inc\Business\User_Registration\Login;

use SRFM\Inc\Helper;
use SRFM_Pro\Inc\Fields\Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Sureforms Login Markup Class.
 *
 * @since 1.8.0
 */
class Login_Markup extends Base {
	/**
	 * Flag to hide form for logged in users.
	 *
	 * @var bool
	 * @since 1.8.0
	 */
	protected $hide_form = false;

	/**
	 * Message to display if the user is already logged in.
	 *
	 * @var string
	 * @since 1.8.0
	 */
	protected $logged_in_message = '';

	/**
	 * Initialize the properties based on block attributes.
	 *
	 * @param array<mixed> $attributes Block attributes.
	 * @since 1.8.0
	 */
	public function __construct( $attributes ) {
		$this->set_properties( $attributes );
		$this->set_input_label( __( 'Login', 'sureforms-pro' ) );
		$this->slug = 'login';
		$this->set_markup_properties();
		$this->hide_form         = $attributes['hideForm'] ?? false;
		$this->logged_in_message = $attributes['loggedinMessage'] ?? '';
	}

	/**
	 * Render the sureforms Login classic styling
	 *
	 * @param string $content inner block content.
	 * @since 1.8.0
	 * @return string|bool
	 */
	public function markup( $content = '' ) {
		$classes = $this->get_field_classes();
		ob_start();
		?>
			<div data-block-id="<?php echo esc_attr( $this->block_id ); ?>" class="<?php echo esc_attr( $classes ); ?>" data-slug="<?php echo esc_attr( $this->block_slug ); ?>">
				<div class="srfm-block-wrap srfm-login">
				<?php
				if ( is_user_logged_in() && $this->hide_form ) {
					?>
						<p class="srfm-logged-in-message">
							<?php echo wp_kses_post( Helper::get_string_value( $this->logged_in_message ) ); ?>
						</p>
					<?php
				} else {
					echo $content; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- The content is already sanitized, escaping it again would break the markup.
				}
				?>
				</div>
			</div>
		<?php
		return ob_get_clean();
	}
}
