<?php
/**
 * PHP render form Register Block.
 *
 * @package sureforms-pro.
 */

namespace SRFM_Pro\Inc\Blocks\Register;

use SRFM_Pro\Inc\Blocks\Base;
use SRFM_Pro\Inc\Business\User_Registration\Register\Register_Markup;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Register Block.
 */
class Block extends Base {
	/**
	 * Render the block
	 *
	 * @param array<mixed> $attributes Block attributes.
	 * @param string       $content Post content.
	 *
	 * @since 1.8.0
	 * @return string|bool
	 */
	public function render( $attributes, $content = '' ) {
		if ( ! empty( $attributes ) ) {
			$markup_class = new Register_Markup( $attributes );
			ob_start();
			echo $markup_class->markup( $content ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Markup is already sanitized and escaping it would break the HTML structure.
		}
		return ob_get_clean();
	}
}
