<?php
/**
 * Main class file to initialize all the classes of pro package.
 *
 * @since 1.2.0
 * @package sureforms-pro
 */

namespace SRFM_Pro\Inc\Pro;

use SRFM_Pro\Inc\Pro\Signature\Init as Signature;
use SRFM_Pro\Inc\Traits\Get_Instance;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Initialize pro package.
 *
 * @since 1.2.0
 */
class Init {
	use Get_Instance;

	/**
	 * Initialize pro package.
	 *
	 * @since 1.2.0
	 * @return void
	 */
	public function __construct() {
		$this->load_classes();
	}

	/**
	 * Load the necessary classes of the Pro package.
	 *
	 * @since 1.4.0
	 * @return void
	 */
	public function load_classes() {
		Signature::get_instance();
		Zapier::get_instance();
		Conversational_Form::get_instance();
	}
}
