<?php

/**
 * Views class for Shortcode generator options.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Admin/Views/ChatWhatsappProOptions
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Admin\Views;

use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProPopup;
use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProButton;
use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProShortcode;
use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProCustomCode;
use ThemeAtelier\ChatWhatsappPro\Admin\Views\ChatWhatsappProBackup;
use ThemeAtelier\ChatWhatsappPro\Admin\Framework\Classes\CHAT_WHATSAPP_PRO;

class ChatWhatsappProOptions
{

    /**
     * Create Option fields for the setting options.
     *
     * @param string $prefix Option setting key prefix.
     * @return void
     */
    public static function options($prefix)
    {
        $timezones = array(
            'Africa/Abidjan' => esc_html__('Africa/Abidjan', 'chat-whatsapp-pro'),
            'Africa/Accra' => esc_html__('Africa/Accra', 'chat-whatsapp-pro'),
            'Africa/Addis_Ababa' => esc_html__('Africa/Addis_Ababa', 'chat-whatsapp-pro'),
            'Africa/Algiers' => esc_html__('Africa/Algiers', 'chat-whatsapp-pro'),
            'Africa/Asmara' => esc_html__('Africa/Asmara', 'chat-whatsapp-pro'),
            'Africa/Asmera' => esc_html__('Africa/Asmera', 'chat-whatsapp-pro'),
            'Africa/Bamako' => esc_html__('Africa/Bamako', 'chat-whatsapp-pro'),
            'Africa/Bangui' => esc_html__('Africa/Bangui', 'chat-whatsapp-pro'),
            'Africa/Banjul' => esc_html__('Africa/Banjul', 'chat-whatsapp-pro'),
            'Africa/Bissau' => esc_html__('Africa/Bissau', 'chat-whatsapp-pro'),
            'Africa/Blantyre' => esc_html__('Africa/Blantyre', 'chat-whatsapp-pro'),
            'Africa/Brazzaville' => esc_html__('Africa/Brazzaville', 'chat-whatsapp-pro'),
            'Africa/Bujumbura' => esc_html__('Africa/Bujumbura', 'chat-whatsapp-pro'),
            'Africa/Cairo' => esc_html__('Africa/Cairo', 'chat-whatsapp-pro'),
            'Africa/Casablanca' => esc_html__('Africa/Casablanca', 'chat-whatsapp-pro'),
            'Africa/Ceuta' => esc_html__('Africa/Ceuta', 'chat-whatsapp-pro'),
            'Africa/Conakry' => esc_html__('Africa/Conakry', 'chat-whatsapp-pro'),
            'Africa/Dakar' => esc_html__('Africa/Dakar', 'chat-whatsapp-pro'),
            'Africa/Dar_es_Salaam' => esc_html__('Africa/Dar_es_Salaam', 'chat-whatsapp-pro'),
            'Africa/Djibouti' => esc_html__('Africa/Djibouti', 'chat-whatsapp-pro'),
            'Africa/Douala' => esc_html__('Africa/Douala', 'chat-whatsapp-pro'),
            'Africa/El_Aaiun' => esc_html__('Africa/El_Aaiun', 'chat-whatsapp-pro'),
            'Africa/Freetown' => esc_html__('Africa/Freetown', 'chat-whatsapp-pro'),
            'Africa/Gaborone' => esc_html__('Africa/Gaborone', 'chat-whatsapp-pro'),
            'Africa/Harare' => esc_html__('Africa/Harare', 'chat-whatsapp-pro'),
            'Africa/Johannesburg' => esc_html__('Africa/Johannesburg', 'chat-whatsapp-pro'),
            'Africa/Juba' => esc_html__('Africa/Juba', 'chat-whatsapp-pro'),
            'Africa/Kampala' => esc_html__('Africa/Kampala', 'chat-whatsapp-pro'),
            'Africa/Khartoum' => esc_html__('Africa/Khartoum', 'chat-whatsapp-pro'),
            'Africa/Kigali' => esc_html__('Africa/Kigali', 'chat-whatsapp-pro'),
            'Africa/Kinshasa' => esc_html__('Africa/Kinshasa', 'chat-whatsapp-pro'),
            'Africa/Lagos' => esc_html__('Africa/Lagos', 'chat-whatsapp-pro'),
            'Africa/Libreville' => esc_html__('Africa/Libreville', 'chat-whatsapp-pro'),
            'Africa/Lome' => esc_html__('Africa/Lome', 'chat-whatsapp-pro'),
            'Africa/Luanda' => esc_html__('Africa/Luanda', 'chat-whatsapp-pro'),
            'Africa/Lubumbashi' => esc_html__('Africa/Lubumbashi', 'chat-whatsapp-pro'),
            'Africa/Lusaka' => esc_html__('Africa/Lusaka', 'chat-whatsapp-pro'),
            'Africa/Malabo' => esc_html__('Africa/Malabo', 'chat-whatsapp-pro'),
            'Africa/Maputo' => esc_html__('Africa/Maputo', 'chat-whatsapp-pro'),
            'Africa/Maseru' => esc_html__('Africa/Maseru', 'chat-whatsapp-pro'),
            'Africa/Mbabane' => esc_html__('Africa/Mbabane', 'chat-whatsapp-pro'),
            'Africa/Mogadishu' => esc_html__('Africa/Mogadishu', 'chat-whatsapp-pro'),
            'Africa/Monrovia' => esc_html__('Africa/Monrovia', 'chat-whatsapp-pro'),
            'Africa/Nairobi' => esc_html__('Africa/Nairobi', 'chat-whatsapp-pro'),
            'Africa/Ndjamena' => esc_html__('Africa/Ndjamena', 'chat-whatsapp-pro'),
            'Africa/Niamey' => esc_html__('Africa/Niamey', 'chat-whatsapp-pro'),
            'Africa/Nouakchott' => esc_html__('Africa/Nouakchott', 'chat-whatsapp-pro'),
            'Africa/Ouagadougou' => esc_html__('Africa/Ouagadougou', 'chat-whatsapp-pro'),
            'Africa/Porto-Novo' => esc_html__('Africa/Porto-Novo', 'chat-whatsapp-pro'),
            'Africa/Sao_Tome' => esc_html__('Africa/Sao_Tome', 'chat-whatsapp-pro'),
            'Africa/Timbuktu' => esc_html__('Africa/Timbuktu', 'chat-whatsapp-pro'),
            'Africa/Tripoli' => esc_html__('Africa/Tripoli', 'chat-whatsapp-pro'),
            'Africa/Tunis' => esc_html__('Africa/Tunis', 'chat-whatsapp-pro'),
            'Africa/Windhoek' => esc_html__('Africa/Windhoek', 'chat-whatsapp-pro'),
            'America/Adak' => esc_html__('America/Adak', 'chat-whatsapp-pro'),
            'America/Anchorage' => esc_html__('America/Anchorage', 'chat-whatsapp-pro'),
            'America/Anguilla' => esc_html__('America/Anguilla', 'chat-whatsapp-pro'),
            'America/Antigua' => esc_html__('America/Antigua', 'chat-whatsapp-pro'),
            'America/Araguaina' => esc_html__('America/Araguaina', 'chat-whatsapp-pro'),
            'America/Argentina/Buenos_Aires' => esc_html__('America/Argentina/Buenos_Aires', 'chat-whatsapp-pro'),
            'America/Argentina/Catamarca' => esc_html__('America/Argentina/Catamarca', 'chat-whatsapp-pro'),
            'America/Argentina/ComodRivadavia' => esc_html__('America/Argentina/ComodRivadavia', 'chat-whatsapp-pro'),
            'America/Argentina/Cordoba' => esc_html__('America/Argentina/Cordoba', 'chat-whatsapp-pro'),
            'America/Argentina/Jujuy' => esc_html__('America/Argentina/Jujuy', 'chat-whatsapp-pro'),
            'America/Argentina/La_Rioja' => esc_html__('America/Argentina/La_Rioja', 'chat-whatsapp-pro'),
            'America/Argentina/Mendoza' => esc_html__('America/Argentina/Mendoza', 'chat-whatsapp-pro'),
            'America/Argentina/Rio_Gallegos' => esc_html__('America/Argentina/Rio_Gallegos', 'chat-whatsapp-pro'),
            'America/Argentina/Salta' => esc_html__('America/Argentina/Salta', 'chat-whatsapp-pro'),
            'America/Argentina/San_Juan' => esc_html__('America/Argentina/San_Juan', 'chat-whatsapp-pro'),
            'America/Argentina/San_Luis' => esc_html__('America/Argentina/San_Luis', 'chat-whatsapp-pro'),
            'America/Argentina/Tucuman' => esc_html__('America/Argentina/Tucuman', 'chat-whatsapp-pro'),
            'America/Argentina/Ushuaia' => esc_html__('America/Argentina/Ushuaia', 'chat-whatsapp-pro'),
            'America/Aruba' => esc_html__('America/Aruba', 'chat-whatsapp-pro'),
            'America/Asuncion' => esc_html__('America/Asuncion', 'chat-whatsapp-pro'),
            'America/Atikokan' => esc_html__('America/Atikokan', 'chat-whatsapp-pro'),
            'America/Atka' => esc_html__('America/Atka', 'chat-whatsapp-pro'),
            'America/Bahia' => esc_html__('America/Bahia', 'chat-whatsapp-pro'),
            'America/Bahia_Banderas' => esc_html__('America/Bahia_Banderas', 'chat-whatsapp-pro'),
            'America/Barbados' => esc_html__('America/Barbados', 'chat-whatsapp-pro'),
            'America/Belem' => esc_html__('America/Belem', 'chat-whatsapp-pro'),
            'America/Belize' => esc_html__('America/Belize', 'chat-whatsapp-pro'),
            'America/Blanc-Sablon' => esc_html__('America/Blanc-Sablon', 'chat-whatsapp-pro'),
            'America/Boa_Vista' => esc_html__('America/Boa_Vista', 'chat-whatsapp-pro'),
            'America/Bogota' => esc_html__('America/Bogota', 'chat-whatsapp-pro'),
            'America/Boise' => esc_html__('America/Boise', 'chat-whatsapp-pro'),
            'America/Buenos_Aires' => esc_html__('America/Buenos_Aires', 'chat-whatsapp-pro'),
            'America/Cambridge_Bay' => esc_html__('America/Cambridge_Bay', 'chat-whatsapp-pro'),
            'America/Campo_Grande' => esc_html__('America/Campo_Grande', 'chat-whatsapp-pro'),
            'America/Cancun' => esc_html__('America/Cancun', 'chat-whatsapp-pro'),
            'America/Caracas' => esc_html__('America/Caracas', 'chat-whatsapp-pro'),
            'America/Catamarca' => esc_html__('America/Catamarca', 'chat-whatsapp-pro'),
            'America/Cayenne' => esc_html__('America/Cayenne', 'chat-whatsapp-pro'),
            'America/Cayman' => esc_html__('America/Cayman', 'chat-whatsapp-pro'),
            'America/Chicago' => esc_html__('America/Chicago', 'chat-whatsapp-pro'),
            'America/Chihuahua' => esc_html__('America/Chihuahua', 'chat-whatsapp-pro'),
            'America/Coral_Harbour' => esc_html__('America/Coral_Harbour', 'chat-whatsapp-pro'),
            'America/Cordoba' => esc_html__('America/Cordoba', 'chat-whatsapp-pro'),
            'America/Costa_Rica' => esc_html__('America/Costa_Rica', 'chat-whatsapp-pro'),
            'America/Creston' => esc_html__('America/Creston', 'chat-whatsapp-pro'),
            'America/Cuiaba' => esc_html__('America/Cuiaba', 'chat-whatsapp-pro'),
            'America/Curacao' => esc_html__('America/Curacao', 'chat-whatsapp-pro'),
            'America/Danmarkshavn' => esc_html__('America/Danmarkshavn', 'chat-whatsapp-pro'),
            'America/Dawson' => esc_html__('America/Dawson', 'chat-whatsapp-pro'),
            'America/Araguaina' => esc_html__('America/Araguaina', 'chat-whatsapp-pro'),
            'America/Denver' => esc_html__('America/Denver', 'chat-whatsapp-pro'),
            'America/Araguaina' => esc_html__('America/Araguaina', 'chat-whatsapp-pro'),
            'America/Dominica' => esc_html__('America/Dominica', 'chat-whatsapp-pro'),
            'America/Edmonton' => esc_html__('America/Edmonton', 'chat-whatsapp-pro'),
            'America/Eirunepe' => esc_html__('America/Eirunepe', 'chat-whatsapp-pro'),
            'America/El_Salvador' => esc_html__('America/El_Salvador', 'chat-whatsapp-pro'),
            'America/Ensenada' => esc_html__('America/Ensenada', 'chat-whatsapp-pro'),
            'America/Fort_Nelson' => esc_html__('America/Fort_Nelson', 'chat-whatsapp-pro'),
            'America/Fort_Wayne' => esc_html__('America/Fort_Wayne', 'chat-whatsapp-pro'),
            'America/Fortaleza' => esc_html__('America/Fortaleza', 'chat-whatsapp-pro'),
            'America/Glace_Bay' => esc_html__('America/Glace_Bay', 'chat-whatsapp-pro'),
            'America/Godthab' => esc_html__('America/Godthab', 'chat-whatsapp-pro'),
            'America/Goose_Bay' => esc_html__('America/Goose_Bay', 'chat-whatsapp-pro'),
            'America/Grand_Turk' => esc_html__('America/Grand_Turk', 'chat-whatsapp-pro'),
            'America/Grenada' => esc_html__('America/Grenada', 'chat-whatsapp-pro'),
            'America/Guadeloupe' => esc_html__('America/Guadeloupe', 'chat-whatsapp-pro'),
            'America/Guatemala' => esc_html__('America/Guatemala', 'chat-whatsapp-pro'),
            'America/Guayaquil' => esc_html__('America/Guayaquil', 'chat-whatsapp-pro'),
            'America/Guyana' => esc_html__('America/Guyana', 'chat-whatsapp-pro'),
            'America/Halifax' => esc_html__('America/Halifax', 'chat-whatsapp-pro'),
            'America/Havana' => esc_html__('America/Havana', 'chat-whatsapp-pro'),
            'America/Hermosillo' => esc_html__('America/Hermosillo', 'chat-whatsapp-pro'),
            'America/Indiana/Indianapolis' => esc_html__('Indiana/Indianapolis', 'chat-whatsapp-pro'),
            'America/Indiana/Knox' => esc_html__('America/Indiana/Knox', 'chat-whatsapp-pro'),
            'America/Indiana/Marengo' => esc_html__('America/Indiana/Marengo', 'chat-whatsapp-pro'),
            'America/Indiana/Petersburg' => esc_html__('America/Indiana/Petersburg', 'chat-whatsapp-pro'),
            'America/Indiana/Tell_City' => esc_html__('America/Indiana/Tell_City', 'chat-whatsapp-pro'),
            'America/Indiana/Vevay' => esc_html__('America/Indiana/Vevay', 'chat-whatsapp-pro'),
            'America/Indiana/Vincennes' => esc_html__('America/Indiana/Vincennes', 'chat-whatsapp-pro'),
            'America/Indiana/Winamac' => esc_html__('America/Indiana/Winamac', 'chat-whatsapp-pro'),
            'America/Indianapolis' => esc_html__('America/Indianapolis', 'chat-whatsapp-pro'),
            'America/Inuvik' => esc_html__('America/Inuvik', 'chat-whatsapp-pro'),
            'America/Iqaluit' => esc_html__('America/Iqaluit', 'chat-whatsapp-pro'),
            'America/Jamaica' => esc_html__('America/Jamaica', 'chat-whatsapp-pro'),
            'America/Jujuy' => esc_html__('America/Jujuy', 'chat-whatsapp-pro'),
            'America/Juneau' => esc_html__('America/Juneau', 'chat-whatsapp-pro'),
            'America/Kentucky/Louisville' => esc_html__('America/Kentucky/Louisville', 'chat-whatsapp-pro'),
            'America/Kentucky/Monticello' => esc_html__('America/Kentucky/Monticello', 'chat-whatsapp-pro'),
            'America/Knox_IN' => esc_html__('America/Knox_IN', 'chat-whatsapp-pro'),
            'America/Kralendijk' => esc_html__('America/Kralendijk', 'chat-whatsapp-pro'),
            'America/La_Paz' => esc_html__('America/La_Paz', 'chat-whatsapp-pro'),
            'America/Lima' => esc_html__('America/Lima', 'chat-whatsapp-pro'),
            'America/Los_Angeles' => esc_html__('America/Los_Angeles', 'chat-whatsapp-pro'),
            'America/Louisville' => esc_html__('America/Louisville', 'chat-whatsapp-pro'),
            'America/Lower_Princes' => esc_html__('America/Lower_Princes', 'chat-whatsapp-pro'),
            'America/Maceio' => esc_html__('America/Maceio', 'chat-whatsapp-pro'),
            'America/Managua' => esc_html__('America/Managua', 'chat-whatsapp-pro'),
            'America/Manaus' => esc_html__('America/Manaus', 'chat-whatsapp-pro'),
            'America/Marigot' => esc_html__('America/Marigot', 'chat-whatsapp-pro'),
            'America/Martinique' => esc_html__('America/Martinique', 'chat-whatsapp-pro'),
            'America/Matamoros' => esc_html__('America/Matamoros', 'chat-whatsapp-pro'),
            'America/Mazatlan' => esc_html__('America/Mazatlan', 'chat-whatsapp-pro'),
            'America/Mendoza' => esc_html__('America/Mendoza', 'chat-whatsapp-pro'),
            'America/Menominee' => esc_html__('America/Menominee', 'chat-whatsapp-pro'),
            'America/Merida' => esc_html__('America/Merida', 'chat-whatsapp-pro'),
            'America/Metlakatla' => esc_html__('America/Metlakatla', 'chat-whatsapp-pro'),
            'America/Mexico_City' => esc_html__('America/Mexico_City', 'chat-whatsapp-pro'),
            'America/Miquelon' => esc_html__('America/Miquelon', 'chat-whatsapp-pro'),
            'America/Moncton' => esc_html__('America/Moncton', 'chat-whatsapp-pro'),
            'America/Monterrey' => esc_html__('America/Monterrey', 'chat-whatsapp-pro'),
            'America/Montevideo' => esc_html__('America/Montevideo', 'chat-whatsapp-pro'),
            'America/Montreal' => esc_html__('America/Montreal', 'chat-whatsapp-pro'),
            'America/Montserrat' => esc_html__('America/Montserrat', 'chat-whatsapp-pro'),
            'America/Nassau' => esc_html__('America/Nassau', 'chat-whatsapp-pro'),
            'America/New_York' => esc_html__('America/New_York', 'chat-whatsapp-pro'),
            'America/Nipigon' => esc_html__('America/Nipigon', 'chat-whatsapp-pro'),
            'America/Nome' => esc_html__('America/Nome', 'chat-whatsapp-pro'),
            'America/Noronha' => esc_html__('America/Noronha', 'chat-whatsapp-pro'),
            'America/North_Dakota/Beulah' => esc_html__('America/North_Dakota/Beulah', 'chat-whatsapp-pro'),
            'America/North_Dakota/Center' => esc_html__('America/North_Dakota/Center', 'chat-whatsapp-pro'),
            'America/North_Dakota/New_Salem' => esc_html__('America/North_Dakota/New_Salem', 'chat-whatsapp-pro'),
            'America/Ojinaga' => esc_html__('America/Ojinaga', 'chat-whatsapp-pro'),
            'America/Panama' => esc_html__('America/Panama', 'chat-whatsapp-pro'),
            'America/Pangnirtung' => esc_html__('America/Pangnirtung', 'chat-whatsapp-pro'),
            'America/Paramaribo' => esc_html__('America/Paramaribo', 'chat-whatsapp-pro'),
            'America/Phoenix' => esc_html__('America/Phoenix', 'chat-whatsapp-pro'),
            'America/Port-au-Prince' => esc_html__('America/Port-au-Prince', 'chat-whatsapp-pro'),
            'America/Port_of_Spain' => esc_html__('America/Port_of_Spain', 'chat-whatsapp-pro'),
            'America/Porto_Acre' => esc_html__('America/Porto_Acre', 'chat-whatsapp-pro'),
            'America/Porto_Velho' => esc_html__('America/Porto_Velho', 'chat-whatsapp-pro'),
            'America/Puerto_Rico' => esc_html__('America/Puerto_Rico', 'chat-whatsapp-pro'),
            'America/Punta_Arenas' => esc_html__('America/Punta_Arenas', 'chat-whatsapp-pro'),
            'America/Rainy_River' => esc_html__('America/Rainy_River', 'chat-whatsapp-pro'),
            'America/Rankin_Inlet' => esc_html__('America/Rankin_Inlet', 'chat-whatsapp-pro'),
            'America/Recife' => esc_html__('America/Recife', 'chat-whatsapp-pro'),
            'America/Regina' => esc_html__('America/Regina', 'chat-whatsapp-pro'),
            'America/Resolute' => esc_html__('America/Resolute', 'chat-whatsapp-pro'),
            'America/Rio_Branco' => esc_html__('America/Rio_Branco', 'chat-whatsapp-pro'),
            'America/Rosario' => esc_html__('America/Rosario', 'chat-whatsapp-pro'),
            'America/Santa_Isabel' => esc_html__('America/Santa_Isabel', 'chat-whatsapp-pro'),
            'America/Santarem' => esc_html__('America/Santarem', 'chat-whatsapp-pro'),
            'America/Santiago' => esc_html__('America/Santiago', 'chat-whatsapp-pro'),
            'America/Santo_Domingo' => esc_html__('America/Santo_Domingo', 'chat-whatsapp-pro'),
            'America/Sao_Paulo' => esc_html__('America/Sao_Paulo', 'chat-whatsapp-pro'),
            'America/Scoresbysund' => esc_html__('America/Scoresbysund', 'chat-whatsapp-pro'),
            'America/Shiprock' => esc_html__('America/Shiprock', 'chat-whatsapp-pro'),
            'America/Sitka' => esc_html__('America/Sitka', 'chat-whatsapp-pro'),
            'America/St_Barthelemy' => esc_html__('America/St_Barthelemy', 'chat-whatsapp-pro'),
            'America/St_Johns' => esc_html__('America/St_Johns', 'chat-whatsapp-pro'),
            'America/St_Kitts' => esc_html__('America/St_Kitts', 'chat-whatsapp-pro'),
            'America/St_Lucia' => esc_html__('America/St_Lucia', 'chat-whatsapp-pro'),
            'America/St_Thomas' => esc_html__('America/St_Thomas', 'chat-whatsapp-pro'),
            'America/St_Vincent' => esc_html__('America/St_Vincent', 'chat-whatsapp-pro'),
            'America/Swift_Current' => esc_html__('America/Swift_Current', 'chat-whatsapp-pro'),
            'America/Tegucigalpa' => esc_html__('America/Tegucigalpa', 'chat-whatsapp-pro'),
            'America/Thule' => esc_html__('America/Thule', 'chat-whatsapp-pro'),
            'America/Thunder_Bay' => esc_html__('America/Thunder_Bay', 'chat-whatsapp-pro'),
            'America/Tijuana' => esc_html__('America/Tijuana', 'chat-whatsapp-pro'),
            'America/Toronto' => esc_html__('America/Toronto', 'chat-whatsapp-pro'),
            'America/Tortola' => esc_html__('America/Tortola', 'chat-whatsapp-pro'),
            'America/Vancouver' => esc_html__('America/Vancouver', 'chat-whatsapp-pro'),
            'America/Virgin' => esc_html__('America/Virgin', 'chat-whatsapp-pro'),
            'America/Whitehorse' => esc_html__('America/Whitehorse', 'chat-whatsapp-pro'),
            'America/Winnipeg' => esc_html__('America/Winnipeg', 'chat-whatsapp-pro'),
            'America/Yakutat' => esc_html__('America/Yakutat', 'chat-whatsapp-pro'),
            'America/Yellowknife' => esc_html__('America/Yellowknife', 'chat-whatsapp-pro'),
            'Antarctica/Casey' => esc_html__('Antarctica/Casey', 'chat-whatsapp-pro'),
            'Antarctica/Davis' => esc_html__('Antarctica/Davis', 'chat-whatsapp-pro'),
            'Antarctica/DumontDUrville' => esc_html__('Antarctica/DumontDUrville', 'chat-whatsapp-pro'),
            'Antarctica/Macquarie' => esc_html__('Antarctica/Macquarie', 'chat-whatsapp-pro'),
            'Antarctica/Mawson' => esc_html__('Antarctica/Mawson', 'chat-whatsapp-pro'),
            'Antarctica/McMurdo' => esc_html__('Antarctica/McMurdo', 'chat-whatsapp-pro'),
            'Antarctica/Palmer' => esc_html__('Antarctica/Palmer', 'chat-whatsapp-pro'),
            'Antarctica/Rothera' => esc_html__('Antarctica/Rothera', 'chat-whatsapp-pro'),
            'Antarctica/South_Pole' => esc_html__('Antarctica/South_Pole', 'chat-whatsapp-pro'),
            'Antarctica/Syowa' => esc_html__('Antarctica/Syowa', 'chat-whatsapp-pro'),
            'Antarctica/Troll' => esc_html__('Antarctica/Troll', 'chat-whatsapp-pro'),
            'Antarctica/Vostok' => esc_html__('Antarctica/Vostok', 'chat-whatsapp-pro'),
            'Arctic/Longyearbyen' => esc_html__('Arctic/Longyearbyen', 'chat-whatsapp-pro'),
            'Asia/Aden' => esc_html__('Asia/Aden', 'chat-whatsapp-pro'),
            'Asia/Almaty' => esc_html__('Asia/Almaty', 'chat-whatsapp-pro'),
            'Asia/Amman' => esc_html__('Asia/Amman', 'chat-whatsapp-pro'),
            'Asia/Anadyr' => esc_html__('Asia/Anadyr', 'chat-whatsapp-pro'),
            'Asia/Aqtau' => esc_html__('Asia/Aqtau', 'chat-whatsapp-pro'),
            'Asia/Aqtobe' => esc_html__('Asia/Aqtobe', 'chat-whatsapp-pro'),
            'Asia/Ashgabat' => esc_html__('Asia/Ashgabat', 'chat-whatsapp-pro'),
            'Asia/Ashkhabad' => esc_html__('Asia/Ashkhabad', 'chat-whatsapp-pro'),
            'Asia/Atyrau' => esc_html__('Asia/Atyrau', 'chat-whatsapp-pro'),
            'Asia/Baghdad' => esc_html__('Asia/Baghdad', 'chat-whatsapp-pro'),
            'Asia/Bahrain' => esc_html__('Asia/Bahrain', 'chat-whatsapp-pro'),
            'Asia/Baku' => esc_html__('Asia/Baku', 'chat-whatsapp-pro'),
            'Asia/Bangkok' => esc_html__('Asia/Bangkok', 'chat-whatsapp-pro'),
            'Asia/Barnaul' => esc_html__('Asia/Barnaul', 'chat-whatsapp-pro'),
            'Asia/Beirut' => esc_html__('Asia/Beirut', 'chat-whatsapp-pro'),
            'Asia/Bishkek' => esc_html__('Asia/Bishkek', 'chat-whatsapp-pro'),
            'Asia/Brunei' => esc_html__('Asia/Brunei', 'chat-whatsapp-pro'),
            'Asia/Calcutta' => esc_html__('Asia/Calcutta', 'chat-whatsapp-pro'),
            'Asia/Chita' => esc_html__('Asia/Chita', 'chat-whatsapp-pro'),
            'Asia/Choibalsan' => esc_html__('Asia/Choibalsan', 'chat-whatsapp-pro'),
            'Asia/Chongqing' => esc_html__('Asia/Chongqing', 'chat-whatsapp-pro'),
            'Asia/Chungking' => esc_html__('Asia/Chungking', 'chat-whatsapp-pro'),
            'Asia/Colombo' => esc_html__('Asia/Colombo', 'chat-whatsapp-pro'),
            'Asia/Dacca' => esc_html__('Asia/Dacca', 'chat-whatsapp-pro'),
            'Asia/Damascus' => esc_html__('Asia/Damascus', 'chat-whatsapp-pro'),
            'Asia/Dhaka' => esc_html__('Asia/Dhaka', 'chat-whatsapp-pro'),
            'Asia/Dili' => esc_html__('Asia/Dili', 'chat-whatsapp-pro'),
            'Asia/Dubai' => esc_html__('Asia/Dubai', 'chat-whatsapp-pro'),
            'Asia/Dushanbe' => esc_html__('Asia/Dushanbe', 'chat-whatsapp-pro'),
            'Asia/Famagusta' => esc_html__('Asia/Famagusta', 'chat-whatsapp-pro'),
            'Asia/Gaza' => esc_html__('Asia/Gaza', 'chat-whatsapp-pro'),
            'Asia/Harbin' => esc_html__('Asia/Harbin', 'chat-whatsapp-pro'),
            'Asia/Hebron' => esc_html__('Asia/Hebron', 'chat-whatsapp-pro'),
            'Asia/Ho_Chi_Minh' => esc_html__('Asia/Ho_Chi_Minh', 'chat-whatsapp-pro'),
            'Asia/Hong_Kong' => esc_html__('Asia/Hong_Kong', 'chat-whatsapp-pro'),
            'Asia/Hovd' => esc_html__('Asia/Hovd', 'chat-whatsapp-pro'),
            'Asia/Irkutsk' => esc_html__('Asia/Irkutsk', 'chat-whatsapp-pro'),
            'Asia/Istanbul' => esc_html__('Asia/Istanbul', 'chat-whatsapp-pro'),
            'Asia/Jakarta' => esc_html__('Asia/Jakarta', 'chat-whatsapp-pro'),
            'Asia/Jayapura' => esc_html__('Asia/Jayapura', 'chat-whatsapp-pro'),
            'Asia/Jerusalem' => esc_html__('Asia/Jerusalem', 'chat-whatsapp-pro'),
            'Asia/Kabul' => esc_html__('Asia/Kabul', 'chat-whatsapp-pro'),
            'Asia/Kamchatka' => esc_html__('Asia/Kamchatka', 'chat-whatsapp-pro'),
            'Asia/Karachi' => esc_html__('Asia/Karachi', 'chat-whatsapp-pro'),
            'Asia/Kashgar' => esc_html__('Asia/Kashgar', 'chat-whatsapp-pro'),
            'Asia/Kathmandu' => esc_html__('Asia/Kathmandu', 'chat-whatsapp-pro'),
            'Asia/Katmandu' => esc_html__('Asia/Katmandu', 'chat-whatsapp-pro'),
            'Asia/Khandyga' => esc_html__('Asia/Khandyga', 'chat-whatsapp-pro'),
            'Asia/Kolkata' => esc_html__('Asia/Kolkata', 'chat-whatsapp-pro'),
            'Asia/Krasnoyarsk' => esc_html__('Asia/Krasnoyarsk', 'chat-whatsapp-pro'),
            'Asia/Kuala_Lumpur' => esc_html__('Asia/Kuala_Lumpur', 'chat-whatsapp-pro'),
            'Asia/Kuching' => esc_html__('Asia/Kuching', 'chat-whatsapp-pro'),
            'Asia/Kuwait' => esc_html__('Asia/Kuwait', 'chat-whatsapp-pro'),
            'Asia/Macao' => esc_html__('Asia/Macao', 'chat-whatsapp-pro'),
            'Asia/Macau' => esc_html__('Asia/Macau', 'chat-whatsapp-pro'),
            'Asia/Magadan' => esc_html__('Asia/Magadan', 'chat-whatsapp-pro'),
            'Asia/Makassar' => esc_html__('Asia/Makassar', 'chat-whatsapp-pro'),
            'Asia/Manila' => esc_html__('Asia/Manila', 'chat-whatsapp-pro'),
            'Asia/Muscat' => esc_html__('Asia/Muscat', 'chat-whatsapp-pro'),
            'Asia/Nicosia' => esc_html__('Asia/Nicosia', 'chat-whatsapp-pro'),
            'Asia/Novokuznetsk' => esc_html__('Asia/Novokuznetsk', 'chat-whatsapp-pro'),
            'Asia/Novosibirsk' => esc_html__('Asia/Novosibirsk', 'chat-whatsapp-pro'),
            'Asia/Omsk' => esc_html__('Asia/Omsk', 'chat-whatsapp-pro'),
            'Asia/Oral' => esc_html__('Asia/Oral', 'chat-whatsapp-pro'),
            'Asia/Phnom_Penh' => esc_html__('Asia/Phnom_Penh', 'chat-whatsapp-pro'),
            'Asia/Pontianak' => esc_html__('Asia/Pontianak', 'chat-whatsapp-pro'),
            'Asia/Pyongyang' => esc_html__('Asia/Pyongyang', 'chat-whatsapp-pro'),
            'Asia/Qatar' => esc_html__('Asia/Qatar', 'chat-whatsapp-pro'),
            'Asia/Qyzylorda' => esc_html__('Asia/Qyzylorda', 'chat-whatsapp-pro'),
            'Asia/Rangoon' => esc_html__('Asia/Rangoon', 'chat-whatsapp-pro'),
            'Asia/Riyadh' => esc_html__('Asia/Riyadh', 'chat-whatsapp-pro'),
            'Asia/Saigon' => esc_html__('Asia/Saigon', 'chat-whatsapp-pro'),
            'Asia/Sakhalin' => esc_html__('Asia/Sakhalin', 'chat-whatsapp-pro'),
            'Asia/Samarkand' => esc_html__('Asia/Samarkand', 'chat-whatsapp-pro'),
            'Asia/Seoul' => esc_html__('Asia/Seoul', 'chat-whatsapp-pro'),
            'Asia/Shanghai' => esc_html__('Asia/Shanghai', 'chat-whatsapp-pro'),
            'Asia/Singapore' => esc_html__('Asia/Singapore', 'chat-whatsapp-pro'),
            'Asia/Srednekolymsk' => esc_html__('Asia/Srednekolymsk', 'chat-whatsapp-pro'),
            'Asia/Taipei' => esc_html__('Asia/Taipei', 'chat-whatsapp-pro'),
            'Asia/Tashkent' => esc_html__('Asia/Tashkent', 'chat-whatsapp-pro'),
            'Asia/Tbilisi' => esc_html__('Asia/Tbilisi', 'chat-whatsapp-pro'),
            'Asia/Tehran' => esc_html__('Asia/Tehran', 'chat-whatsapp-pro'),
            'Asia/Tel_Aviv' => esc_html__('Asia/Tel_Aviv', 'chat-whatsapp-pro'),
            'Asia/Thimbu' => esc_html__('Asia/Thimbu', 'chat-whatsapp-pro'),
            'Asia/Thimphu' => esc_html__('Asia/Thimphu', 'chat-whatsapp-pro'),
            'Asia/Tokyo' => esc_html__('Asia/Tokyo', 'chat-whatsapp-pro'),
            'Asia/Tomsk' => esc_html__('Asia/Tomsk', 'chat-whatsapp-pro'),
            'Asia/Ujung_Pandang' => esc_html__('Asia/Ujung_Pandang', 'chat-whatsapp-pro'),
            'Asia/Ulaanbaatar' => esc_html__('Asia/Ulaanbaatar', 'chat-whatsapp-pro'),
            'Asia/Ulan_Bator' => esc_html__('Asia/Ulan_Bator', 'chat-whatsapp-pro'),
            'Asia/Urumqi' => esc_html__('Asia/Urumqi', 'chat-whatsapp-pro'),
            'Asia/Ust-Nera' => esc_html__('Asia/Ust-Nera', 'chat-whatsapp-pro'),
            'Asia/Vientiane' => esc_html__('Asia/Vientiane', 'chat-whatsapp-pro'),
            'Asia/Vladivostok' => esc_html__('Asia/Vladivostok', 'chat-whatsapp-pro'),
            'Asia/Yakutsk' => esc_html__('Asia/Yakutsk', 'chat-whatsapp-pro'),
            'Asia/Yangon' => esc_html__('Asia/Yangon', 'chat-whatsapp-pro'),
            'Asia/Yekaterinburg' => esc_html__('Asia/Yekaterinburg', 'chat-whatsapp-pro'),
            'Asia/Yerevan' => esc_html__('Asia/Yerevan', 'chat-whatsapp-pro'),
            'Atlantic/Azores' => esc_html__('Atlantic/Azores', 'chat-whatsapp-pro'),
            'Atlantic/Bermuda' => esc_html__('Atlantic/Bermuda', 'chat-whatsapp-pro'),
            'Atlantic/Canary' => esc_html__('Atlantic/Canary', 'chat-whatsapp-pro'),
            'Atlantic/Cape_Verde' => esc_html__('Atlantic/Cape_Verde', 'chat-whatsapp-pro'),
            'Atlantic/Faeroe' => esc_html__('Atlantic/Faeroe', 'chat-whatsapp-pro'),
            'Atlantic/Faroe' => esc_html__('Atlantic/Faroe', 'chat-whatsapp-pro'),
            'Atlantic/Jan_Mayen' => esc_html__('Atlantic/Jan_Mayen', 'chat-whatsapp-pro'),
            'Atlantic/Madeira' => esc_html__('Atlantic/Madeira', 'chat-whatsapp-pro'),
            'Atlantic/Reykjavik' => esc_html__('Atlantic/Reykjavik', 'chat-whatsapp-pro'),
            'Atlantic/South_Georgia' => esc_html__('Atlantic/South_Georgia', 'chat-whatsapp-pro'),
            'Atlantic/St_Helena' => esc_html__('Atlantic/St_Helena', 'chat-whatsapp-pro'),
            'Atlantic/Stanley' => esc_html__('Atlantic/Stanley', 'chat-whatsapp-pro'),
            'Australia/ACT' => esc_html__('Australia/ACT', 'chat-whatsapp-pro'),
            'Australia/Adelaide' => esc_html__('Australia/Adelaide', 'chat-whatsapp-pro'),
            'Australia/Brisbane' => esc_html__('Australia/Brisbane', 'chat-whatsapp-pro'),
            'Australia/Broken_Hill' => esc_html__('Asia/Broken_Hill', 'chat-whatsapp-pro'),
            'Australia/Canberra' => esc_html__('Australia/Canberra', 'chat-whatsapp-pro'),
            'Australia/Currie' => esc_html__('Australia/Currie', 'chat-whatsapp-pro'),
            'Australia/Darwin' => esc_html__('Australia/Darwin', 'chat-whatsapp-pro'),
            'Australia/Eucla' => esc_html__('Australia/Eucla', 'chat-whatsapp-pro'),
            'Australia/Hobart' => esc_html__('Australia/Hobart', 'chat-whatsapp-pro'),
            'Australia/LHI' => esc_html__('Australia/LHI', 'chat-whatsapp-pro'),
            'Australia/Lindeman' => esc_html__('Australia/Lindeman', 'chat-whatsapp-pro'),
            'Australia/Lord_Howe' => esc_html__('Australia/Lord_Howe', 'chat-whatsapp-pro'),
            'Australia/Melbourne' => esc_html__('Australia/Melbourne', 'chat-whatsapp-pro'),
            'Australia/NSW' => esc_html__('Australia/NSW', 'chat-whatsapp-pro'),
            'Australia/North' => esc_html__('Australia/North', 'chat-whatsapp-pro'),
            'Australia/Perth' => esc_html__('Australia/Perth', 'chat-whatsapp-pro'),
            'Australia/Queensland' => esc_html__('Australia/Queensland', 'chat-whatsapp-pro'),
            'Australia/South' => esc_html__('Australia/South', 'chat-whatsapp-pro'),
            'Australia/Sydney' => esc_html__('Australia/Sydney', 'chat-whatsapp-pro'),
            'Australia/Tasmania' => esc_html__('Australia/Tasmania', 'chat-whatsapp-pro'),
            'Australia/Victoria' => esc_html__('Australia/Victoria', 'chat-whatsapp-pro'),
            'Australia/West' => esc_html__('Australia/West', 'chat-whatsapp-pro'),
            'Australia/Yancowinna' => esc_html__('Australia/Yancowinna', 'chat-whatsapp-pro'),
            'Brazil/Acre' => esc_html__('Brazil/Acre', 'chat-whatsapp-pro'),
            'Brazil/DeNoronha' => esc_html__('Brazil/DeNoronha', 'chat-whatsapp-pro'),
            'Brazil/East' => esc_html__('Brazil/East', 'chat-whatsapp-pro'),
            'Brazil/West' => esc_html__('Brazil/West', 'chat-whatsapp-pro'),
            'CET' => esc_html__('CET', 'chat-whatsapp-pro'),
            'CST6CDT' => esc_html__('CST6CDT', 'chat-whatsapp-pro'),
            'Canada/Atlantic' => esc_html__('Canada/Atlantic', 'chat-whatsapp-pro'),
            'Canada/Central' => esc_html__('Canada/Central', 'chat-whatsapp-pro'),
            'Canada/Eastern' => esc_html__('Canada/Eastern', 'chat-whatsapp-pro'),
            'Canada/Mountain' => esc_html__('Canada/Mountain', 'chat-whatsapp-pro'),
            'Canada/Newfoundland' => esc_html__('Canada/Newfoundland', 'chat-whatsapp-pro'),
            'Canada/Pacific' => esc_html__('Canada/Pacific', 'chat-whatsapp-pro'),
            'Canada/Saskatchewan' => esc_html__('Canada/Saskatchewan', 'chat-whatsapp-pro'),
            'Canada/Yukon' => esc_html__('Canada/Yukon', 'chat-whatsapp-pro'),
            'Chile/Continental' => esc_html__('Chile/Continental', 'chat-whatsapp-pro'),
            'Chile/EasterIsland' => esc_html__('Chile/EasterIsland', 'chat-whatsapp-pro'),
            'Cuba' => esc_html__('Cuba', 'chat-whatsapp-pro'),
            'EET' => esc_html__('EET', 'chat-whatsapp-pro'),
            'EST' => esc_html__('EST', 'chat-whatsapp-pro'),
            'EST5EDT' => esc_html__('EST5EDT', 'chat-whatsapp-pro'),
            'Egypt' => esc_html__('Egypt', 'chat-whatsapp-pro'),
            'Eire' => esc_html__('Eire', 'chat-whatsapp-pro'),
            'Etc/GMT' => esc_html__('Etc/GMT', 'chat-whatsapp-pro'),
            'Etc/GMT+0' => esc_html__('Etc/GMT+0', 'chat-whatsapp-pro'),
            'Etc/GMT+1' => esc_html__('Etc/GMT+1', 'chat-whatsapp-pro'),
            'Etc/GMT+10' => esc_html__('Etc/GMT+10', 'chat-whatsapp-pro'),
            'Etc/GMT+11' => esc_html__('Etc/GMT+11', 'chat-whatsapp-pro'),
            'Etc/GMT+12' => esc_html__('Etc/GMT+12', 'chat-whatsapp-pro'),
            'Etc/GMT+2' => esc_html__('Etc/GMT+2', 'chat-whatsapp-pro'),
            'Etc/GMT+3' => esc_html__('Etc/GMT+3', 'chat-whatsapp-pro'),
            'Etc/GMT+4' => esc_html__('Etc/GMT+4', 'chat-whatsapp-pro'),
            'Etc/GMT+5' => esc_html__('Etc/GMT+5', 'chat-whatsapp-pro'),
            'Etc/GMT+6' => esc_html__('Etc/GMT+6', 'chat-whatsapp-pro'),
            'Etc/GMT+7' => esc_html__('Etc/GMT+7', 'chat-whatsapp-pro'),
            'Etc/GMT+8' => esc_html__('Etc/GMT+8', 'chat-whatsapp-pro'),
            'Etc/GMT+9' => esc_html__('Etc/GMT+9', 'chat-whatsapp-pro'),
            'Etc/GMT-0' => esc_html__('Etc/GMT-0', 'chat-whatsapp-pro'),
            'Etc/GMT-1' => esc_html__('Etc/GMT-1', 'chat-whatsapp-pro'),
            'Etc/GMT-10' => esc_html__('Etc/GMT-10', 'chat-whatsapp-pro'),
            'Etc/GMT-11' => esc_html__('Etc/GMT-11', 'chat-whatsapp-pro'),
            'Etc/GMT-12' => esc_html__('Etc/GMT-12', 'chat-whatsapp-pro'),
            'Etc/GMT-13' => esc_html__('Etc/GMT-13', 'chat-whatsapp-pro'),
            'Etc/GMT-14' => esc_html__('Etc/GMT-14', 'chat-whatsapp-pro'),
            'Etc/GMT-2' => esc_html__('Etc/GMT-2', 'chat-whatsapp-pro'),
            'Etc/GMT-3' => esc_html__('Etc/GMT-3', 'chat-whatsapp-pro'),
            'Etc/GMT-4' => esc_html__('Etc/GMT-4', 'chat-whatsapp-pro'),
            'Etc/GMT-5' => esc_html__('Etc/GMT-5', 'chat-whatsapp-pro'),
            'Etc/GMT-6' => esc_html__('Etc/GMT-6', 'chat-whatsapp-pro'),
            'Etc/GMT-7' => esc_html__('Etc/GMT-7', 'chat-whatsapp-pro'),
            'Etc/GMT-8' => esc_html__('Etc/GMT-8', 'chat-whatsapp-pro'),
            'Etc/GMT-9' => esc_html__('Etc/GMT-9', 'chat-whatsapp-pro'),
            'Etc/GMT0' => esc_html__('Etc/GMT0', 'chat-whatsapp-pro'),
            'Etc/Greenwich' => esc_html__('Etc/Greenwich', 'chat-whatsapp-pro'),
            'Etc/UCT' => esc_html__('Etc/UCT', 'chat-whatsapp-pro'),
            'Etc/UTC' => esc_html__('Etc/UTC', 'chat-whatsapp-pro'),
            'Etc/Universal' => esc_html__('Etc/Universal', 'chat-whatsapp-pro'),
            'Etc/Zulu' => esc_html__('Etc/Zulu', 'chat-whatsapp-pro'),
            'Europe/Amsterdam' => esc_html__('Europe/Amsterdam', 'chat-whatsapp-pro'),
            'Europe/Andorra' => esc_html__('Europe/Andorra', 'chat-whatsapp-pro'),
            'Europe/Astrakhan' => esc_html__('Europe/Astrakhan', 'chat-whatsapp-pro'),
            'Europe/Athens' => esc_html__('Europe/Athens', 'chat-whatsapp-pro'),
            'Europe/Belfast' => esc_html__('Europe/Belfast', 'chat-whatsapp-pro'),
            'Europe/Belgrade' => esc_html__('Europe/Belgrade', 'chat-whatsapp-pro'),
            'Europe/Berlin' => esc_html__('Europe/Berlin', 'chat-whatsapp-pro'),
            'Europe/Bratislava' => esc_html__('Europe/Bratislava', 'chat-whatsapp-pro'),
            'Europe/Brussels' => esc_html__('Europe/Brussels', 'chat-whatsapp-pro'),
            'Europe/Bucharest' => esc_html__('Europe/Bucharest', 'chat-whatsapp-pro'),
            'Europe/Budapest' => esc_html__('Europe/Budapest', 'chat-whatsapp-pro'),
            'Europe/Busingen' => esc_html__('Europe/Busingen', 'chat-whatsapp-pro'),
            'Europe/Chisinau' => esc_html__('Europe/Chisinau', 'chat-whatsapp-pro'),
            'Europe/Copenhagen' => esc_html__('Europe/Copenhagen', 'chat-whatsapp-pro'),
            'Europe/Dublin' => esc_html__('Europe/Dublin', 'chat-whatsapp-pro'),
            'Europe/Gibraltar' => esc_html__('Europe/Gibraltar', 'chat-whatsapp-pro'),
            'Europe/Guernsey' => esc_html__('Europe/Guernsey', 'chat-whatsapp-pro'),
            'Europe/Helsinki' => esc_html__('Europe/Helsinki', 'chat-whatsapp-pro'),
            'Europe/Isle_of_Man' => esc_html__('Europe/Isle_of_Man', 'chat-whatsapp-pro'),
            'Europe/Istanbul' => esc_html__('Europe/Istanbul', 'chat-whatsapp-pro'),
            'Europe/Jersey' => esc_html__('Europe/Jersey', 'chat-whatsapp-pro'),
            'Europe/Kaliningrad' => esc_html__('Europe/Kaliningrad', 'chat-whatsapp-pro'),
            'Europe/Kiev' => esc_html__('Europe/Kiev', 'chat-whatsapp-pro'),
            'Europe/Kirov' => esc_html__('Europe/Kirov', 'chat-whatsapp-pro'),
            'Europe/Lisbon' => esc_html__('Europe/Lisbon', 'chat-whatsapp-pro'),
            'Europe/Ljubljana' => esc_html__('Europe/Ljubljana', 'chat-whatsapp-pro'),
            'Europe/London' => esc_html__('Europe/London', 'chat-whatsapp-pro'),
            'Europe/Luxembourg' => esc_html__('Europe/Luxembourg', 'chat-whatsapp-pro'),
            'Europe/Madrid' => esc_html__('Europe/Madrid', 'chat-whatsapp-pro'),
            'Europe/Malta' => esc_html__('Europe/Malta', 'chat-whatsapp-pro'),
            'Europe/Mariehamn' => esc_html__('Europe/Mariehamn', 'chat-whatsapp-pro'),
            'Europe/Minsk' => esc_html__('Europe/Minsk', 'chat-whatsapp-pro'),
            'Europe/Monaco' => esc_html__('Europe/Monaco', 'chat-whatsapp-pro'),
            'Europe/Moscow' => esc_html__('Europe/Moscow', 'chat-whatsapp-pro'),
            'Europe/Nicosia' => esc_html__('Europe/Nicosia', 'chat-whatsapp-pro'),
            'Europe/Oslo' => esc_html__('Europe/Oslo', 'chat-whatsapp-pro'),
            'Europe/Paris' => esc_html__('Europe/Paris', 'chat-whatsapp-pro'),
            'Europe/Podgorica' => esc_html__('Europe/Podgorica', 'chat-whatsapp-pro'),
            'Europe/Prague' => esc_html__('Europe/Prague', 'chat-whatsapp-pro'),
            'Europe/Riga' => esc_html__('Europe/Riga', 'chat-whatsapp-pro'),
            'Europe/Rome' => esc_html__('Europe/Rome', 'chat-whatsapp-pro'),
            'Europe/Samara' => esc_html__('Europe/Samara', 'chat-whatsapp-pro'),
            'Europe/San_Marino' => esc_html__('Europe/San_Marino', 'chat-whatsapp-pro'),
            'Europe/Sarajevo' => esc_html__('Europe/Sarajevo', 'chat-whatsapp-pro'),
            'Europe/Saratov' => esc_html__('Europe/Saratov', 'chat-whatsapp-pro'),
            'Europe/Simferopol' => esc_html__('Europe/Simferopol', 'chat-whatsapp-pro'),
            'Europe/Skopje' => esc_html__('Europe/Skopje', 'chat-whatsapp-pro'),
            'Europe/Sofia' => esc_html__('Europe/Sofia', 'chat-whatsapp-pro'),
            'Europe/Stockholm' => esc_html__('Europe/Stockholm', 'chat-whatsapp-pro'),
            'Europe/Tallinn' => esc_html__('Europe/Tallinn', 'chat-whatsapp-pro'),
            'Europe/Tirane' => esc_html__('Europe/Tirane', 'chat-whatsapp-pro'),
            'Europe/Tiraspol' => esc_html__('Europe/Tiraspol', 'chat-whatsapp-pro'),
            'Europe/Ulyanovsk' => esc_html__('Europe/Ulyanovsk', 'chat-whatsapp-pro'),
            'Europe/Uzhgorod' => esc_html__('Europe/Uzhgorod', 'chat-whatsapp-pro'),
            'Europe/Vaduz' => esc_html__('Europe/Vaduz', 'chat-whatsapp-pro'),
            'Europe/Vatican' => esc_html__('Europe/Vatican', 'chat-whatsapp-pro'),
            'Europe/Vienna' => esc_html__('Europe/Vienna', 'chat-whatsapp-pro'),
            'Europe/Vilnius' => esc_html__('Europe/Vilnius', 'chat-whatsapp-pro'),
            'Europe/Volgograd' => esc_html__('Europe/Volgograd', 'chat-whatsapp-pro'),
            'Europe/Warsaw' => esc_html__('Europe/Warsaw', 'chat-whatsapp-pro'),
            'Europe/Zagreb' => esc_html__('Europe/Zagreb', 'chat-whatsapp-pro'),
            'Europe/Zaporozhye' => esc_html__('Europe/Zaporozhye', 'chat-whatsapp-pro'),
            'Europe/Zurich' => esc_html__('Europe/Zurich', 'chat-whatsapp-pro'),
            'GB' => esc_html__('GB', 'chat-whatsapp-pro'),
            'GB-Eire' => esc_html__('GB-Eire', 'chat-whatsapp-pro'),
            'GMT' => esc_html__('GMT', 'chat-whatsapp-pro'),
            'GMT+0' => esc_html__('GMT+0', 'chat-whatsapp-pro'),
            'GMT-0' => esc_html__('GMT-0', 'chat-whatsapp-pro'),
            'GMT0' => esc_html__('GMT0', 'chat-whatsapp-pro'),
            'Greenwich' => esc_html__('Greenwich', 'chat-whatsapp-pro'),
            'HST' => esc_html__('HST', 'chat-whatsapp-pro'),
            'Hongkong' => esc_html__('Hongkong', 'chat-whatsapp-pro'),
            'Iceland' => esc_html__('Iceland', 'chat-whatsapp-pro'),
            'Indian/Antananarivo' => esc_html__('Indian/Antananarivo', 'chat-whatsapp-pro'),
            'Indian/Chagos' => esc_html__('Indian/Chagos', 'chat-whatsapp-pro'),
            'Indian/Christmas' => esc_html__('Indian/Christmas', 'chat-whatsapp-pro'),
            'Indian/Cocos' => esc_html__('Indian/Cocos', 'chat-whatsapp-pro'),
            'Indian/Comoro' => esc_html__('Indian/Comoro', 'chat-whatsapp-pro'),
            'Indian/Kerguelen' => esc_html__('Indian/Kerguelen', 'chat-whatsapp-pro'),
            'Indian/Mahe' => esc_html__('Indian/Mahe', 'chat-whatsapp-pro'),
            'Indian/Maldives' => esc_html__('Indian/Maldives', 'chat-whatsapp-pro'),
            'Indian/Mauritius' => esc_html__('Indian/Mauritius', 'chat-whatsapp-pro'),
            'Indian/Mayotte' => esc_html__('Indian/Mayotte', 'chat-whatsapp-pro'),
            'Indian/Reunion' => esc_html__('Indian/Reunion', 'chat-whatsapp-pro'),
            'Iran' => esc_html__('Iran', 'chat-whatsapp-pro'),
            'Israel' => esc_html__('Israel', 'chat-whatsapp-pro'),
            'Jamaica' => esc_html__('Jamaica', 'chat-whatsapp-pro'),
            'Japan' => esc_html__('Japan', 'chat-whatsapp-pro'),
            'Kwajalein' => esc_html__('Kwajalein', 'chat-whatsapp-pro'),
            'Libya' => esc_html__('Libya', 'chat-whatsapp-pro'),
            'MET' => esc_html__('MET', 'chat-whatsapp-pro'),
            'MST' => esc_html__('MST', 'chat-whatsapp-pro'),
            'MST7MDT' => esc_html__('MST7MDT', 'chat-whatsapp-pro'),
            'Mexico/BajaNorte' => esc_html__('Mexico/BajaNorte', 'chat-whatsapp-pro'),
            'Mexico/BajaSur' => esc_html__('Mexico/BajaSur', 'chat-whatsapp-pro'),
            'Mexico/General' => esc_html__('Mexico/General', 'chat-whatsapp-pro'),
            'NZ' => esc_html__('NZ', 'chat-whatsapp-pro'),
            'NZ-CHAT' => esc_html__('NZ-CHAT', 'chat-whatsapp-pro'),
            'Navajo' => esc_html__('Navajo', 'chat-whatsapp-pro'),
            'PRC' => esc_html__('PRC', 'chat-whatsapp-pro'),
            'PST8PDT' => esc_html__('PST8PDT', 'chat-whatsapp-pro'),
            'Pacific/Apia' => esc_html__('Pacific/Apia', 'chat-whatsapp-pro'),
            'Pacific/Auckland' => esc_html__('Pacific/Auckland', 'chat-whatsapp-pro'),
            'Pacific/Bougainville' => esc_html__('Pacific/Bougainville', 'chat-whatsapp-pro'),
            'Pacific/Chatham' => esc_html__('Pacific/Chatham', 'chat-whatsapp-pro'),
            'Pacific/Chuuk' => esc_html__('Pacific/Chuuk', 'chat-whatsapp-pro'),
            'Pacific/Easter' => esc_html__('Pacific/Easter', 'chat-whatsapp-pro'),
            'Pacific/Efate' => esc_html__('Pacific/Efate', 'chat-whatsapp-pro'),
            'Pacific/Enderbury' => esc_html__('Pacific/Enderbury', 'chat-whatsapp-pro'),
            'Pacific/Fakaofo' => esc_html__('Pacific/Fakaofo', 'chat-whatsapp-pro'),
            'Pacific/Fiji' => esc_html__('Pacific/Fiji', 'chat-whatsapp-pro'),
            'Pacific/Funafuti' => esc_html__('Pacific/Funafuti', 'chat-whatsapp-pro'),
            'Pacific/Galapagos' => esc_html__('Pacific/Galapagos', 'chat-whatsapp-pro'),
            'Pacific/Gambier' => esc_html__('Pacific/Gambier', 'chat-whatsapp-pro'),
            'Pacific/Guadalcanal' => esc_html__('Pacific/Guadalcanal', 'chat-whatsapp-pro'),
            'Pacific/Guam' => esc_html__('Pacific/Guam', 'chat-whatsapp-pro'),
            'Pacific/Honolulu' => esc_html__('Pacific/Honolulu', 'chat-whatsapp-pro'),
            'Pacific/Johnston' => esc_html__('Pacific/Johnston', 'chat-whatsapp-pro'),
            'Pacific/Kiritimati' => esc_html__('Pacific/Kiritimati', 'chat-whatsapp-pro'),
            'Pacific/Kosrae' => esc_html__('Pacific/Kosrae', 'chat-whatsapp-pro'),
            'Pacific/Kwajalein' => esc_html__('Pacific/Kwajalein', 'chat-whatsapp-pro'),
            'Pacific/Majuro' => esc_html__('Pacific/Majuro', 'chat-whatsapp-pro'),
            'Pacific/Marquesas' => esc_html__('Pacific/Marquesas', 'chat-whatsapp-pro'),
            'Pacific/Midway' => esc_html__('Pacific/Midway', 'chat-whatsapp-pro'),
            'Pacific/Nauru' => esc_html__('Pacific/Nauru', 'chat-whatsapp-pro'),
            'Pacific/Niue' => esc_html__('Pacific/Niue', 'chat-whatsapp-pro'),
            'Pacific/Norfolk' => esc_html__('Pacific/Norfolk', 'chat-whatsapp-pro'),
            'Pacific/Noumea' => esc_html__('Pacific/Noumea', 'chat-whatsapp-pro'),
            'Pacific/Pago_Pago' => esc_html__('Pacific/Pago_Pago', 'chat-whatsapp-pro'),
            'Pacific/Palau' => esc_html__('Pacific/Palau', 'chat-whatsapp-pro'),
            'Pacific/Pitcairn' => esc_html__('Pacific/Pitcairn', 'chat-whatsapp-pro'),
            'Pacific/Pohnpei' => esc_html__('Pacific/Pohnpei', 'chat-whatsapp-pro'),
            'Pacific/Ponape' => esc_html__('Pacific/Ponape', 'chat-whatsapp-pro'),
            'Pacific/Port_Moresby' => esc_html__('Pacific/Port_Moresby', 'chat-whatsapp-pro'),
            'Pacific/Rarotonga' => esc_html__('Pacific/Rarotonga', 'chat-whatsapp-pro'),
            'Pacific/Saipan' => esc_html__('Pacific/Saipan', 'chat-whatsapp-pro'),
            'Pacific/Samoa' => esc_html__('Pacific/Samoa', 'chat-whatsapp-pro'),
            'Pacific/Tahiti' => esc_html__('Pacific/Tahiti', 'chat-whatsapp-pro'),
            'Pacific/Tarawa' => esc_html__('Pacific/Tarawa', 'chat-whatsapp-pro'),
            'Pacific/Tongatapu' => esc_html__('Pacific/Tongatapu', 'chat-whatsapp-pro'),
            'Pacific/Truk' => esc_html__('Pacific/Truk', 'chat-whatsapp-pro'),
            'Pacific/Wake' => esc_html__('Pacific/Wake', 'chat-whatsapp-pro'),
            'Pacific/Wallis' => esc_html__('Pacific/Wallis', 'chat-whatsapp-pro'),
            'Pacific/Yap' => esc_html__('Pacific/Yap', 'chat-whatsapp-pro'),
            'Poland' => esc_html__('Poland', 'chat-whatsapp-pro'),
            'Portugal' => esc_html__('Portugal', 'chat-whatsapp-pro'),
            'ROC' => esc_html__('ROC', 'chat-whatsapp-pro'),
            'ROK' => esc_html__('ROK', 'chat-whatsapp-pro'),
            'Singapore' => esc_html__('Singapore', 'chat-whatsapp-pro'),
            'Turkey' => esc_html__('Turkey', 'chat-whatsapp-pro'),
            'UCT' => esc_html__('UCT', 'chat-whatsapp-pro'),
            'US/Alaska' => esc_html__('US/Alaska', 'chat-whatsapp-pro'),
            'US/Aleutian' => esc_html__('US/Aleutian', 'chat-whatsapp-pro'),
            'US/Arizona' => esc_html__('US/Arizona', 'chat-whatsapp-pro'),
            'US/Central' => esc_html__('US/Central', 'chat-whatsapp-pro'),
            'US/East-Indiana' => esc_html__('US/East-Indiana', 'chat-whatsapp-pro'),
            'US/Eastern' => esc_html__('US/Eastern', 'chat-whatsapp-pro'),
            'US/Hawaii' => esc_html__('US/Hawaii', 'chat-whatsapp-pro'),
            'US/Indiana-Starke' => esc_html__('US/Indiana-Starke', 'chat-whatsapp-pro'),
            'US/Michigan' => esc_html__('US/Michigan', 'chat-whatsapp-pro'),
            'US/Mountain' => esc_html__('US/Mountain', 'chat-whatsapp-pro'),
            'US/Pacific' => esc_html__('US/Pacific', 'chat-whatsapp-pro'),
            'US/Pacific-New' => esc_html__('US/Pacific-New', 'chat-whatsapp-pro'),
            'US/Samoa' => esc_html__('US/Samoa', 'chat-whatsapp-pro'),
            'UTC' => esc_html__('UTC', 'chat-whatsapp-pro'),
            'Universal' => esc_html__('Universal', 'chat-whatsapp-pro'),
            'W-SU' => esc_html__('W-SU', 'chat-whatsapp-pro'),
            'WET' => esc_html__('WET', 'chat-whatsapp-pro'),
        );
        //
        // Create options
        //
        CHAT_WHATSAPP_PRO::createOptions($prefix, array(
            'menu_title'        => esc_html__('Whatsapp Chat', 'chat-whatsapp-pro'),
            'menu_slug'         => 'chat-whatsapp-pro',
            'menu_type'               => 'submenu',
            'show_bar_menu'     => false,
            'show_sub_menu'     => false,
            'framework_title'   => esc_html__('Whatsapp Chat', 'chat-whatsapp-pro'),
            'admin_bar_menu_priority' => 5,
            'footer_text'       => esc_html__('Thank you for using our product', 'chat-whatsapp-pro'),
            'theme'             => 'light',
            'nav'               => 'inline',
            'framework_class'         => 'chat-whatsapp-pro-admin',
        ));


        ChatWhatsappProPopup::options($prefix, $timezones);
        ChatWhatsappProButton::options($prefix);
        ChatWhatsappProShortcode::options($prefix);
        ChatWhatsappProCustomCode::options($prefix);
        ChatWhatsappProBackup::options($prefix);
    }
}
