<?php

/**
 * Multi Template Class
 *
 * This class handles the multi template functionality for Chat WhatsApp Pro.
 *
 * @link       https://themeatelier.net
 * @since      1.0.0
 *
 * @package    chat-whatsapp-pro
 * @subpackage chat-whatsapp-pro/src/Frontend
 * @author     ThemeAtelier<themeatelierbd@gmail.com>
 */

namespace ThemeAtelier\ChatWhatsappPro\Frontend\Templates;

/**
 * Class MultiTemplate
 *
 * Handles the rendering of multiple templates in the plugin.
 *
 * @since 1.0.0
 */
class MultiTemplate
{

    /**
     * Handles multi template logic.
     *
     * This method contains the logic to display or render multi templates.
     *
     * @since 1.0.0
     */
    public static function multiTemplate($options, $bubble_type, $random)
    {
        $bubble_style       = isset($options['bubble-style']) ? $options['bubble-style'] : '';
        $bubble_position    = isset($options['bubble-position']) ? $options['bubble-position'] : '';
        $agent_list_grid    = isset($options['agent-listGrid']) ? $options['agent-listGrid'] : '';
        $bubble_title       = isset($options['bubble-title']) ? $options['bubble-title'] : '';
        $bubble_subtitle       = isset($options['bubble-subtitle']) ? $options['bubble-subtitle'] : '';
        $gdpr_compliance_content       = isset($options['gdpr-compliance-content']) ? $options['gdpr-compliance-content'] : '';
        $opt_chat_agents       = isset($options['opt-chat-agents']) ? $options['opt-chat-agents'] : [];
        $bubble_visibility = isset($options['bubble-visibility']) ? $options['bubble-visibility'] : 'everywhere';

        echo '<div class="wHelp-multi ' . esc_attr($bubble_position) . ' wHelp-' . esc_attr($bubble_visibility) . '-only ';

        // Add bubble style classes based on the 'bubble-style' option.
        if ($bubble_style === 'dark') {
            echo 'dark-mode ';
        } elseif ($bubble_style === 'night') {
            echo 'night-mode ';
        }

        // Add position-specific class if position is 'left'.
        if ('left' === $bubble_position) {
            echo 'wHelp-left';
        }
        if ('grid' === $agent_list_grid) {
            echo 'wHelp-grid';
        }

        echo '">';
        echo wp_kses_post($bubble_type);

        if ('random' === $options['select-animation']) :
            $animation = $random;
        else :
            $animation = $options['select-animation'];
        endif; ?>
        <div class="wHelp-multi__popup animation<?php echo esc_attr($animation) ?>">
            <?php if ($bubble_title || $bubble_subtitle) : ?>
                <div class="wHelp-multi__popup--header">
                    <?php if ($bubble_title) : ?>
                        <h3 class="title"><?php echo esc_html($bubble_title); ?></h3>
                    <?php endif; ?>
                    <?php if ($bubble_subtitle) : ?>
                        <p class="subtitle"><?php echo esc_html($bubble_subtitle); ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="wHelp-multi__popup--content"
                <?php
                if ($options['bubble-search']) {
                ?>
                data-search="true" <?php } ?> id="multi-user">
                <?php if ($options['gdpr-enable']) : ?>
                    <div class="wHelp--checkbox">
                        <input id="gdpr-check" name="gdpr-check" type="checkbox" class="wHelp__checkbox" />
                        <label for="gdpr-check"><?php echo wp_kses_post($gdpr_compliance_content); ?></label>
                    </div>
                <?php endif; ?>
                <div class="search">
                    <input id="search-input" onkeyup="searchUser()" type="text" placeholder="<?php echo esc_html__('Search', 'chat-whatsapp-pro'); ?>" />
                </div>
                <div class="users">

                    <?php foreach ($opt_chat_agents as $agent) {
                        $optAvailablity = isset($agent['opt-availablity']) ? $agent['opt-availablity'] : '';
                        $sunday_from    = $optAvailablity ? $optAvailablity['availablity-sunday']['from'] : '00:00';
                        $sunday_to      = $optAvailablity ? $optAvailablity['availablity-sunday']['to'] : '23:59';
                        $monday_from    = $optAvailablity ? $optAvailablity['availablity-monday']['from'] : '00:00';
                        $monday_to      = $optAvailablity ? $optAvailablity['availablity-monday']['to'] : '23:59';

                        $tuesday_from   = $optAvailablity ? $optAvailablity['availablity-tuesday']['from'] : '00:00';
                        $tuesday_to     = $optAvailablity ? $optAvailablity['availablity-tuesday']['to'] : '23:59';

                        $wednesday_from = $optAvailablity ? $optAvailablity['availablity-wednesday']['from'] : '00:00';
                        $wednesday_to   = $optAvailablity ? $optAvailablity['availablity-wednesday']['to'] : '23:59';

                        $thursday_from  = $optAvailablity ? $optAvailablity['availablity-thursday']['from'] : '00:00';
                        $thursday_to    = $optAvailablity ? $optAvailablity['availablity-thursday']['to'] : '23:59';


                        $friday_from    = $optAvailablity ? $optAvailablity['availablity-friday']['from'] : '00:00';
                        $friday_to      = $optAvailablity ? $optAvailablity['availablity-friday']['to'] : '23:59';

                        $saturday_from  = $optAvailablity ? $optAvailablity['availablity-saturday']['from'] : '00:00';
                        $saturday_to    = $optAvailablity ? $optAvailablity['availablity-saturday']['to'] : '23:59';

                        $sunday         = ($sunday_from ? $sunday_from : "0:00") . "-" . ($sunday_to ? $sunday_to : "23:59");
                        $monday         = ($monday_from ? $monday_from : "0:00") . "-" . ($monday_to ? $monday_to : "23:59");
                        $tuesday        = ($tuesday_from ? $tuesday_from : "0:00") . "-" . ($tuesday_to ? $tuesday_to : "23:59");
                        $wednesday      = ($wednesday_from ? $wednesday_from : "0:00") . "-" . ($wednesday_to ? $wednesday_to : "23:59");
                        $thursday       = ($thursday_from ? $thursday_from : "0:00") . "-" . ($thursday_to ? $thursday_to : "23:59");
                        $friday         = ($friday_from ? $friday_from : "0:00") . "-" . ($friday_to ? $friday_to : "23:59");
                        $saturday       = ($saturday_from ? $saturday_from : "0:00") . "-" . ($saturday_to ? $saturday_to : "23:59");

                        $agent_name = isset($agent['agent-name']) ? $agent['agent-name'] : '';
                        $agent_photo = isset($agent['agent-photo']) ? $agent['agent-photo'] : '';
                        if ($agent_photo) {
                            $agent_photo = (isset($agent_photo['url']) && !empty($agent_photo['url'])) ? $agent_photo['url'] : CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent.png';
                        } else {
                            $agent_photo = CHAT_WHATSAPP_PRO_DIR_URL . 'src/assets/image/agent.png';
                        }
                    ?>
                        <div data-timezone="<?php echo esc_html($agent['agent-timezone']); ?>" class="user wHelpUserAvailability 
															<?php
                                                            if ($options['gdpr-enable']) :
                                                            ?>
								condition__checked<?php endif; ?>" data-useravailability='{"sunday":"<?php echo esc_attr($sunday); ?>", "monday":"<?php echo esc_attr($monday); ?>", "tuesday":"<?php echo esc_attr($tuesday); ?>", "wednesday":"<?php echo esc_attr($wednesday); ?>", "thursday":"<?php echo esc_attr($thursday); ?>", "friday":"<?php echo esc_attr($friday); ?>", "saturday":"<?php echo esc_attr($saturday); ?>"}'>
                            <?php if ($agent_photo) : ?>
                                <div class="user__image">
                                    <img src="<?php echo esc_url($agent_photo); ?>" alt="<?php echo esc_html($agent_name); ?>" />
                                </div>
                            <?php endif; ?>
                            <div class="user__info">
                                <?php if ($agent_name) : ?>
                                    <h5 class="user__info--name"><?php echo esc_html($agent_name); ?></h5>
                                <?php endif; ?>
                                <p class="user__info--title"><?php echo esc_html($agent['agent-designation']); ?></p>
                                <p class="user__info--online"><?php echo esc_html($agent['agent-online-text']); ?></p>
                                <p class="user__info--offline"><?php echo esc_html($agent['agent-offline-text']); ?></p>
                            </div>
                            <a href="https://wa.me/<?php echo esc_html($agent['agent-number']); ?>" target="_blank"></a>
                        </div>
                    <?php } ?>
                </div>
                <div class="no-results" style="display: none;"><?php echo esc_html__('Agent not found', 'chat-whatsapp-pro') ?></div>
            </div>
        </div>
        </div>
<?php
    }
}
