<?php

/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
/**
 * Class WpmfGlrAddonHelper
 * This class that holds some helper functions of Media Folder Gallery Addon.
 */
class WpmfGlrAddonHelper
{
    /**
     * Get `term_id` and `meta_value` of term meta by meta_key `gallery_type`
     *
     * @param integer|array $term_ids Term ID
     *
     * @return string|array
     */
    public function getGalleriesType($term_ids)
    {
        global $wpdb;

        if (is_array($term_ids)) {
            $results = array();
            $term_ids_str = implode(',', $term_ids);
        }
        $rows = $wpdb->get_results($wpdb->prepare(
            'SELECT DISTINCT tm.term_id,  tm.meta_value 
            FROM '. $wpdb->prefix . 'termmeta AS tm WHERE tm.meta_key = %s AND  tm.term_id IN ('.$term_ids_str.')', // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
            array('gallery_type')
        ));
        if ($rows) {
            foreach ($rows as $row) {
                $results[$row->term_id] = $row->meta_value;
            }
        }

        return $results;
    }
}
