var wpmfGallery;
(function ($) {
    wpmfGallery = {
        wpmf_img_tags: '*',
        ajax_loading: false,
        gallery_items: [],
        wishlists: [],
        /**
         * Get all items in gallery
         * @param gallery
         * @returns {Array}
         */
        wpmfGalleryGetItems: function (gallery) {
            var lightbox_items = gallery.data('lightbox-items');
            var items = [];
            if (typeof lightbox_items === "undefined") {
                var $item_elements;
                if (gallery.hasClass('wpmf-flipster')) {
                    $item_elements = gallery.find('.wpmf-gallery-item .flipster__item__content > a[data-fancybox="gallery"]');
                } else {
                    $item_elements = gallery.find('.wpmf-gallery-icon > a[data-fancybox="gallery"]');
                }

                $item_elements.each(function () {
                    var src = $(this).attr('href');
                    var type = 'image';
                    if ($(this).hasClass('isvideo')) {
                        type = 'iframe';
                    }

                    var pos = items.map(function (e) {
                        return e.src;
                    }).indexOf(src);
                    if (pos === -1) {
                        items.push({src: src, type: type, caption: $(this).data('title')});
                    }
                });
            } else {
                items = lightbox_items;
            }

            return items;
        },

        callPopup: function($container = null) {
            var slideshow_speed = 5000;
            if ($container !== null) {
                var gallery_id = $container.data('id');
                var gallery_settings = $container.closest('.wpmf_gallery_wrap').data('top-gallery-settings');
                $.ajax({
                    type: "POST",
                    url: wpmfgallery.ajaxurl,
                    data: {
                        action: "wpmfgallery",
                        task: "get_lightbox_items",
                        wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce,
                        gallery_id: gallery_id,
                        gallery_settings: gallery_settings
                    },
                    success: function (res) {
                       if (res.status) {
                            if (res.slideshow_speed) {
                                slideshow_speed = res.slideshow_speed
                            }
                            // $container.find('.wpmf-gallery-addon-wrap').attr('data-lightbox-items', JSON.stringify(res.lightbox_items));
                       }
                    }
                });
            }
            $(document).off('click', '.wpmf-gallery-item');
            $(document).on('click', '.wpmf-gallery-item', function () {
                if ($(this).hasClass('noLightbox')) {
                    return;
                }
                let fancbox_data = JSON.parse($(this).closest('.wpmf-gallery-addon-wrap').attr('data-lightbox-items'));
                let index_item = $(this).attr('data-index');
                let $fancbox;
                if ($.fancyboxMB) {
                    $fancbox = $.fancyboxMB;
                } else {
                    $fancbox = $.fancybox;
                }
                if ($fancbox) {
                    $fancbox.open(fancbox_data, {
                        // Options will go here
                        wheel : false,
                        transitionEffect: "slide",
                        // thumbs          : false,
                        // hash            : false,
                        // keyboard        : true,
                        // animationEffect : false,
                        arrows          : true,
                        clickContent    : false,
                        loop : true,
                        toolbar: true,
                        gallery: true,
                        buttons: [
                            "zoom",
                            //"share",
                            "slideShow",
                            "fullScreen",
                            //"download",
                            //"thumbs",
                            "close"
                        ],
                        slideShow: {
                            speed: slideshow_speed
                        }
                    }, index_item);
                }
            });
        },

        doGallery: function ($container, theme, lazyload = true) {
            switch (theme) {
                case 'masonry':
               // case 'portfolio':
                    var id = $container.data('id');
                    if ($container.find('.wpmf-gallery-addon-wrap').is(':hidden')) {
                        return;
                    }

                    if ($container.find('.wpmf-gallery-addon-wrap').hasClass('masonry')) {
                        return;
                    }
                    imagesLoaded($container.find('.wpmf-gallery-addon-wrap'), function () {
                        $container.closest('.wpmf_gallery_wrap').find('.loading_gallery').hide();
                        wpmfGallery.galleryRunMasonry(400, $container, id, lazyload);
                      //  $container.find('.wpmf-gallery-item').addClass('wpmf-gallery-item-show');
                        wpmfGallery.callPopup($container);
                    });
                    break;
                case 'default':
                case 'material':
                case 'square_grid':
                case 'portfolio':
                    var id = $container.data('id');
                    var columns = $container.find('.glrdefault').data('wpmfcolumns');
                    imagesLoaded($container.find('.glrdefault'), function () {
                        $container.closest('.wpmf_gallery_wrap').find('.loading_gallery').hide();
                        $container.find('figure').each(function (j, v) {
                            if ((j + 1) % columns === 0) {
                                $container.find('figure:nth(' + (j) + ')').after('<hr class="wpmfglr-line-break" />');
                            }
                        });
                        wpmfGallery.wpmfAutobrowse(id, $container.find('.glrdefault'), 'default');
                        wpmfGallery.callPopup($container);
                    });

                    const isMobile = window.matchMedia("only screen and (max-width: 767px)").matches;
                    if (isMobile) {
                        const style = document.createElement('style');
                        style.innerHTML = `
                            .wpmf-gallerys .wpmf_gallery_default.gallery-portfolio .wpmf-gallery-item {
                            width: 100% !important;
                            }
                        `;
                        document.head.appendChild(style);
                    }
                    break;
                case 'flowslide':
                    imagesLoaded($container, function () {
                        $container.closest('.wpmf_gallery_wrap').find('.loading_gallery').hide();
                        var enableNavButtons = $container.data('button');
                        if (typeof enableNavButtons !== "undefined" && parseInt(enableNavButtons) === 1) {
                            $container.flipster({
                                style: 'coverflow',
                                buttons: 'custom',
                                spacing: 0,
                                loop: true,
                                autoplay: 5000,
                                buttonNext: '<i class="flipto-next material-icons"> keyboard_arrow_right </i>',
                                buttonPrev: '<i class="flipto-prev material-icons"> keyboard_arrow_left </i>',
                                onItemSwitch: function (currentItem, previousItem) {
                                    $container.find('.flipster__container').height($(currentItem).height());
                                },
                                onItemStart: function (currentItem) {
                                    $container.find('.flipster__container').height($(currentItem).height());
                                }
                            });
                        } else {
                            $container.flipster({
                                style: 'coverflow',
                                spacing: 0,
                                loop: true,
                                autoplay: 5000,
                                onItemSwitch: function (currentItem, previousItem) {
                                    $container.find('.flipster__container').height($(currentItem).height());
                                },
                                onItemStart: function (currentItem) {
                                    $container.find('.flipster__container').height($(currentItem).height());
                                }
                            });
                        }
                        wpmfGallery.callPopup($container);
                    });
                    break;

                case 'slider':
                        if ($container.is(':hidden')) {
                            return;
                        }

                        if ($container.hasClass('slick-initialized') || $container.hasClass('wpmfslick_life')) {
                            return;
                        }

                        var animation = $container.data('animation');
                        var duration = parseInt($container.data('duration'));
                        var columns = parseInt($container.data('wpmfcolumns'));
                        var number_lines = parseInt($container.data('number_lines'));
                        var containerWidth = $container.width();
                        if (parseInt(columns) >= 4 && containerWidth <= 450) {
                            columns = 2;
                        }
                        var auto_animation = parseInt($container.data('auto_animation'));
                        imagesLoaded($container, function () {
                            $container.closest('.wpmf_gallery_wrap').find('.loading_gallery').hide();
                            var slick_args = {
                                infinite: true,
                                slidesToShow: parseInt(columns),
                                slidesToScroll: parseInt(columns),
                                pauseOnHover: true,
                                autoplay: (auto_animation === 1),
                                adaptiveHeight: (parseInt(columns) === 1),
                                autoplaySpeed: duration,
                                rows: number_lines,
                                fade: (animation === 'fade' && parseInt(columns) === 1),
                                responsive: [
                                    {
                                        breakpoint: 600,
                                        settings: {
                                            slidesToShow: 1,
                                            slidesToScroll: 1
                                        }
                                    }
                                ]
                            };

                            if (columns > 3) {
                                slick_args.responsive = [
                                    {
                                        breakpoint: 1024,
                                        settings: {
                                            slidesToShow: 3,
                                            slidesToScroll: 3,
                                            infinite: true,
                                            dots: true
                                        }
                                    },
                                    {
                                        breakpoint: 600,
                                        settings: {
                                            slidesToShow: 1,
                                            slidesToScroll: 1
                                        }
                                    }
                                ]
                            }

                            if (!$container.hasClass('slick-initialized')) {
                                $container.slick(slick_args);
                            }
                            $container.css('opacity', 1);
                            wpmfGallery.callPopup($container);
                        });
                    break;
                case 'custom_grid':
                    var gutter = $container.data('gutter');
                    imagesLoaded($container, function () {
                        $container.closest('.wpmf_gallery_wrap').find('.loading_gallery').hide();
                        var wrap_width = $container.width();
                        var one_col_width;
                        if ($container.closest('.elementor-element-edit-mode').length) {
                            one_col_width = (wrap_width - gutter*12)/12;
                        } else {
                            one_col_width = (wrap_width - gutter*11)/12;
                        }

                        $container.find('.grid-item').each(function() {
                            var dimensions = $(this).data('styles');
                            var w = (typeof dimensions.width !== "undefined") ? parseInt(dimensions.width) : 2;
                            var h = (typeof dimensions.height !== "undefined") ? parseInt(dimensions.height) : 2;
                            var g = (parseInt(w) - 1)*gutter;
                            var display_width = one_col_width;
                            var display_height = one_col_width;

                            if (w > 1) {
                                display_width = one_col_width*w + g;
                            }

                            if (w == h) {
                                display_height = display_width;
                            } else {
                                if (h > 1) {
                                    display_height = (one_col_width*h) + (h - 1)*gutter;
                                }
                            }

                            $(this).width(display_width);
                            $(this).height(display_height);
                        });

                        $container.isotope({
                            itemSelector: '.grid-item',
                            layoutMode: 'packery',
                            resizable: true,
                            initLayout: true,
                            packery: {
                                gutter: gutter
                            }
                        });
                        $container.addClass('wpmfInitPackery');
                        wpmfGallery.callPopup($container);
                    });
                    break;
            }
        },

        /* Init gallery */
        initGallery: function (lazyload = true) {
            wpmfGallery.callPopup();
            /* re-call event with tags */
            wpmfGallery.wpmfEventGalleryTags();
            $('.wpmf_gallery_wrap .flipster').each(function () {
                var $flip = $(this);
                wpmfGallery.doGallery($flip, 'flowslide');
            });

            $('.wpmf-gallerys-addon').each(function () {
                var theme = $(this).data('theme');
                if (theme !== 'slider' && theme !== 'custom_grid') {
                    wpmfGallery.doGallery($(this), theme, lazyload);
                }
            });

            $('.wpmf_gallery_box').each(function () {
                var width = $(this).width();
                if (width >= 600 && width < 800) {
                    $(this).addClass('wpmf_gallery_navigation_3_columns');
                } else if (width >= 800 && width < 1000) {
                    $(this).addClass('wpmf_gallery_navigation_4_columns');
                } else if (width > 1000) {
                    $(this).addClass('wpmf_gallery_navigation_5_columns');
                }
                $(this).find('.wpmf_gallery_lists').addClass('wpmf_navigation_loaded');
            });

            /* init slider theme */
            $('.wpmfslick').each(function () {
                wpmfGallery.doGallery($(this), 'slider');
            });

            $('.wpmf-custom-grid').each(function () {
                wpmfGallery.doGallery($(this), 'custom_grid');
            });

            $('.wpmf_gallery_list_item').on('click', function (e) {
                if (!wpmfGallery.ajax_loading) {
                    // single click
                    let id = $(this).data('id');
                    let $cur = $(this).closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree');
                    let top_gallery_id = $cur.data('id');
                    $cur.find('ul li').removeClass('open selected');
                    $cur.find('li[data-id="'+ id +'"]').addClass('open selected');
                    wpmfGalleryTree.changeFolder($cur, id, $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]'));
                    wpmfGalleryTree.loadGallery($cur, id, top_gallery_id);
                }
            });

            wpmfGallery.photograperHandle();
        },
        photograperHandle: function() {
            wpmfGallery.showToolTip();
            $('.wpmf_submit_gallery_btn').unbind('click').bind('click', function (e) {
                var $this = $(this);
                var gallery_id = $(this).closest('.gallery_comments_box').data('gallery_id');
                var comments = {};
                var author_name = $('.wpmf_gallery_author_name_input').val();
                $('.wpmf_gallery_comment_input').each(function (i, v) {
                    var comment = $(v).val();
                    var attachment_id = $(v).data('attachment');
                    if (comment != '') {
                        var parent = 0;
                        if ($(v).closest('.gallery_image_info').find('.wpmf_gallery_reply.selected').length) {
                            parent = $(this).closest('.gallery_image_info').find('.wpmf_gallery_reply.selected').data('comment');
                        }
                        comments[i] = {'comment': comment, 'parent': parent, 'attachment_id': attachment_id};
                    }
                });

                if (comments.length) {
                    if (author_name === '') {
                        $('.wpmf_gallery_author_name_input').addClass('wpmf_input_error');
                        return false;
                    } else {
                        $('.wpmf_gallery_author_name_input').removeClass('wpmf_input_error');
                    }
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_submit_comments',
                        gallery_id: gallery_id,
                        author_name: author_name,
                        comments: JSON.stringify(comments)
                    },
                    beforeSend: function () {
                        $this.closest('.gallery_comments_box').addClass('loading');
                    },
                    success: function (res) {
                        $this.closest('.gallery_comments_box').removeClass('loading');
                        if (res.status) {
                            $.magnificPopup.close();
                        }
                    }
                });
            });
            $('.wpmf_cancel_gallery_btn').unbind('click').bind('click', function (e) {
                $.magnificPopup.close();
            });
            $('.wpmf_gallery_remove_item').unbind('click').bind('click', function (e) {
                var attachment_id = $(this).closest('.gallery_comments_item').data('attachment');
                var gallery_id = $(this).closest('.gallery_comments_box').data('gallery_id');
                $(this).closest('.gallery_comments_item').remove();
                $('.wpmf_gallery_add_to_list[data-gallery_id="'+ gallery_id +'"][data-attachment="'+ attachment_id +'"]').removeClass('selected');
                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_add_to_wishlist',
                        gallery_id: gallery_id,
                        attachment_id: attachment_id,
                        is_add: 0
                    },
                    success: function (res) {
                        if (res.status) {
                            $('.wpmf_gallery_show_request_list_row[data-gallery_id="'+ gallery_id +'"]').data('wishlist_count', res.wishlist_count);
                        }
                    }
                });
            });

            $('.wpmf_gallery_add_to_list').unbind('click').bind('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                var $this = $(this);
                var gallery_id = $this.data('gallery_id');
                var attachment_id = $this.data('attachment');
                $(this).toggleClass('selected');
                var is_add = 0;
                if ($(this).hasClass('selected')) {
                    is_add = 1;
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_add_to_wishlist',
                        gallery_id: gallery_id,
                        attachment_id: attachment_id,
                        is_add: is_add
                    },
                    success: function (res) {
                        if (res.status) {
                            $('.wpmf_gallery_show_request_list_row[data-gallery_id="'+ gallery_id +'"]').data('wishlist_count', res.wishlist_count);
                        }
                    }
                });
            });

            $('.wpmf_gallery_download_list').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var $this = $(this);
                var gallery_id;
                if ($this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree').length) {
                    gallery_id = $this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree  li.selected').data('id');
                } else {
                    gallery_id = $this.data('gallery_id');
                }

                var wishlist_count = $('.wpmf_gallery_show_request_list_row[data-gallery_id="'+ gallery_id +'"]').data('wishlist_count');
                if (parseInt(wishlist_count) === 0) {
                    if (!$this.closest('div').find('.wpmf_wishlist_msg_error').length) {
                        $this.closest('div').find('.wpmf_gallery_show_request_list_row').after('<p class="wpmf_wishlist_msg_error">'+ wpmfgallery.wishlist_msg_error +'</p>');
                        setTimeout(function () {
                            $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                        },2000);
                    } else {
                        $this.closest('div').find('.wpmf_wishlist_msg_error').show();
                        setTimeout(function () {
                            $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                        },2000);
                    }
                } else {
                    $.magnificPopup.open({
                        items: {
                            src: $('#wpmf_photograper_download_wishlist_lists_' + gallery_id)
                        },
                        mainClass: 'wpmfPopup',
                        type:'inline',
                        showCloseBtn: false,
                        midClick: true
                    });
                }
            });

            $('.wpmf_download_wishlist_image_btn').unbind('click').bind('click', function () {
                var gallery_id = $(this).data('gallery_id');
                var size = $('.gallery_download_wishlist_wrap .wpmf_size_input:checked').data('size');
                if ($('.gallery_download_wishlist_box.loading').length) {
                    return;
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_download_wishlist',
                        gallery_id: gallery_id,
                        size: size
                    },
                    beforeSend: function () {
                        $('.gallery_download_wishlist_box').addClass('loading');
                    },
                    success: function (res) {
                        $('.gallery_download_wishlist_box').removeClass('loading');
                        if (res.status) {
                            var link = document.createElement("a");
                            link.download = res.name;
                            link.href = res.download_url;
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            delete link;
                        }
                    }
                });
            });
            if ($('.wpmf_photograper_open_download_lists').length) {
                $('.wpmf_photograper_open_download_lists').unbind('click').bind('click', function (e) {
                    e.preventDefault();
                    var gallery_id = $(this).data('gallery_id');
                    var attachment_id = $(this).data('attachment');
                    $.ajax({
                        url: wpmfgallery.ajaxurl,
                        method: "POST",
                        dataType: 'json',
                        data: {
                            action: 'wpmf_gallery_load_download_sizes',
                            attachment_id: attachment_id
                        },
                        beforeSend: function () {

                        },
                        success: function (res) {
                            if (res.status) {
                                $('#wpmf_photograper_download_lists_' + gallery_id).find('.gallery_download_wrap').html(res.html);
                                $.magnificPopup.open({
                                    items: {
                                        src: $('#wpmf_photograper_download_lists_' + gallery_id)
                                    },
                                    mainClass: 'wpmfPopup',
                                    type:'inline',
                                    showCloseBtn: false,
                                    midClick: true,
                                    callbacks: {
                                        close: function() {

                                        }
                                    }
                                });

                                $('.wpmf_download_image_btn').unbind('click').bind('click', function (e) {
                                    if ($('.gallery_download_wrap .wpmf_size_input:checked').length) {
                                        var attachment_id = $('.gallery_download_wrap .wpmf_size_input:checked').data('attachment');
                                        var size = $('.gallery_download_wrap .wpmf_size_input:checked').data('size');

                                        if ($('.gallery_download_single_box.loading').length) {
                                            return;
                                        }

                                        $.ajax({
                                            url: wpmfgallery.ajaxurl,
                                            method: "POST",
                                            dataType: 'json',
                                            data: {
                                                action: 'wpmf_gallery_download_image',
                                                attachment_id: attachment_id,
                                                size: size
                                            },
                                            beforeSend: function () {
                                                $('.gallery_download_single_box').addClass('loading');
                                            },
                                            success: function (response) {
                                                $('.gallery_download_single_box').removeClass('loading');
                                                if (response.status) {
                                                    var link = document.createElement("a");
                                                    link.download = response.name;
                                                    link.href = response.download_url;
                                                    document.body.appendChild(link);
                                                    link.click();
                                                    document.body.removeChild(link);
                                                    delete link;
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                    });
                });
            }

            if ($('.wpmf_gallery_show_request_list').length) {
                $('.wpmf_gallery_show_request_list').unbind('click').bind('click', function (e) {
                    e.preventDefault();
                    var $this = $(this);
                    if ($this.find('.wpmf_loader_fe').length) {
                        return;
                    }
                    var gallery_id;
                    if ($this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree').length) {
                        gallery_id = $this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree  li.selected').data('id');
                    } else {
                        gallery_id = $this.data('gallery_id');
                    }

                    var wishlist_count = $('.wpmf_gallery_show_request_list_row[data-gallery_id="'+ gallery_id +'"]').data('wishlist_count');
                    if (parseInt(wishlist_count) === 0) {
                        if (!$this.closest('div').find('.wpmf_wishlist_msg_error').length) {
                            $this.closest('div').find('.wpmf_gallery_show_request_list_row').after('<p class="wpmf_wishlist_msg_error">'+ wpmfgallery.wishlist_msg_error +'</p>');
                            setTimeout(function () {
                                $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                            },2000);
                        } else {
                            $this.closest('div').find('.wpmf_wishlist_msg_error').show();
                            setTimeout(function () {
                                $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                            },2000);
                        }
                        return false;
                    }

                    $.ajax({
                        url: wpmfgallery.ajaxurl,
                        method: "POST",
                        dataType: 'json',
                        data: {
                            action: 'wpmf_gallery_photograper_load_requests',
                            gallery_id: gallery_id
                        },
                        beforeSend: function () {
                            $this.append('<img class="wpmf_loader_fe" src="'+ wpmfgallery.plugin_url_image +'spinner.gif">')
                        },
                        success: function (res) {
                            $this.find('.wpmf_loader_fe').remove();
                            if (res.status) {
                                $this.closest('div').find('.wpmf_wishlist_msg_error').hide();
                                $('#open_gallery_comments_' + gallery_id).find('.gallery_comments_wrap').html(res.html);
                                wpmfGallery.photograperHandle();
                                $.magnificPopup.open({
                                    items: {
                                        src: $('#open_gallery_comments_' + gallery_id)
                                    },
                                    mainClass: 'wpmfPopup',
                                    type:'inline',
                                    midClick: true,
                                    callbacks: {
                                        close: function() {

                                        }
                                    }
                                });
                            }
                        }
                    });
                });
            }

            $('.wpmf_gallery_filter_wishlist').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var $this = $(this);
                var wishlist;
                if ($this.hasClass('selected')) {
                    wishlist = 0;
                } else {
                    wishlist = 1;
                }
                var gallery_id;
                if ($this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree').length) {
                    gallery_id = $this.closest('.wpmf_gallery_wrap').find('.wpmf_gallery_tree  li.selected').data('id');
                } else {
                    gallery_id = $this.data('gallery_id');
                }

                var wishlist_count = $('.wpmf_gallery_show_request_list_row[data-gallery_id="'+ gallery_id +'"]').data('wishlist_count');
                if (parseInt(wishlist_count) === 0) {
                    if (!$this.closest('div').find('.wpmf_wishlist_msg_error').length) {
                        $this.closest('div').find('.wpmf_gallery_show_request_list_row').after('<p class="wpmf_wishlist_msg_error">'+ wpmfgallery.wishlist_msg_error +'</p>');
                        setTimeout(function () {
                            $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                        },2000);
                    } else {
                        $this.closest('div').find('.wpmf_wishlist_msg_error').show();
                        setTimeout(function () {
                            $this.closest('div').find('.wpmf_wishlist_msg_error').fadeOut();
                        },2000);
                    }
                    return false;
                }

                var $container = $this.closest('.wpmf_gallery_wrap');
                var settings = $container.data('top-gallery-settings');
                var selector = $container.data('selector');
                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_load_gallery',
                        gallery_id: gallery_id,
                        settings: settings,
                        wishlist: wishlist,
                        selector: selector
                    },
                    beforeSend: function () {
                        $this.closest('.wpmf-gallery-addon-wrap').addClass('loading');
                    },
                    success: function (res) {
                        $this.closest('.wpmf-gallery-addon-wrap').removeClass('loading');
                        if (res.status) {
                            if ($this.hasClass('selected')) {
                                $this.removeClass('selected');
                            } else {
                                $this.addClass('selected');
                            }
                            $container.find('.wpmf_gallery_box').html('').append(res.html);
                            wpmfGallery.initGallery(false);
                            wpmfGallery.photograperHandle();
                        }
                    }
                });
            });

            $('.wpmf_gallery_reply_btn').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var attachment_id = $(this).data('attachment');
                var gallery_id = $(this).closest('.gallery_comments_box').data('gallery_id');
                var comment = $('.wpmf_gallery_comment_input[data-attachment="'+ attachment_id +'"]').val();
                var author_name = $('.wpmf_gallery_author_name_input').val();
                var parent = 0;
                if ($(this).closest('.gallery_image_info').find('.wpmf_gallery_reply.selected').length) {
                    parent = $(this).closest('.gallery_image_info').find('.wpmf_gallery_reply.selected').data('comment');
                }
                if (author_name === '') {
                    $('.wpmf_gallery_author_name_input').addClass('wpmf_input_error');
                    return false;
                } else {
                    $('.wpmf_gallery_author_name_input').removeClass('wpmf_input_error');
                }

                if (comment === '') {
                    $('.wpmf_gallery_comment_input[data-attachment="'+ attachment_id +'"]').addClass('wpmf_input_error');
                    return false;
                } else {
                    $('.wpmf_gallery_comment_input[data-attachment="'+ attachment_id +'"]').removeClass('wpmf_input_error');
                }

                if (parseInt(attachment_id) === 0) {
                    return false;
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_insert_comment',
                        gallery_id: gallery_id,
                        attachment_id: attachment_id,
                        author_name: author_name,
                        comment: comment,
                        parent: parent
                    },
                    beforeSend: function () {
                        $('.gallery_image_info[data-attachment="'+ attachment_id +'"]').addClass('loading');
                    },
                    success: function (res) {
                        $('.gallery_image_info[data-attachment="'+ attachment_id +'"]').removeClass('loading');
                        if (res.status) {
                            $('.wpmf_gallery_comment_input[data-attachment="'+ attachment_id +'"]').val('').attr('placeholder', '');
                            $('.gallery_image_info[data-attachment="'+ attachment_id +'"]').find('.wpmf_comment_lists').html(res.comments);
                            $('.wpmf_gallery_reply').removeClass('selected');
                            wpmfGallery.photograperHandle();
                        }
                    }
                });
            });

            $('.wpmf_gallery_reply').unbind('click').bind('click', function (e) {
                e.preventDefault();
                var attachment_id = $(this).data('attachment');
                var author_name = $(this).closest('.div_p').find('.wpmf_gallery_author > span').html();
                $('.wpmf_gallery_reply').removeClass('selected');
                $(this).addClass('selected');
                $('.wpmf_gallery_comment_input[data-attachment="'+ attachment_id +'"]').focus().attr('placeholder', '@' + author_name);
            });
        },

        /**
         * set a cookie
         * @param cname cookie name
         * @param cvalue cookie value
         * @param exdays
         */
        setCookie: function (cname, cvalue, exdays) {
            let d = new Date();
            d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
            let expires = "expires=" + d.toUTCString();
            document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
        },

        /**
         * get a cookie
         * @param cname cookie name
         * @returns {*}
         */
        getCookie: function (cname) {
            let name = cname + "=";
            let ca = document.cookie.split(';');
            for (let i = 0; i < ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) === ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) === 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        },

        /**
         * get column width, gutter width, count columns
         * @param $container
         * @returns {{columnWidth: number, gutterWidth, columns: Number}}
         */
        calculateGrid: function ($container) {
            var columns = parseInt($container.data('wpmfcolumns'));
            var gutterWidth = $container.data('gutter-width');
            var containerWidth = $container.width();

            if (isNaN(gutterWidth)) {
                gutterWidth = 5;
            } else if (gutterWidth > 500 || gutterWidth < 0) {
                gutterWidth = 5;
            }

            // if (parseInt(columns) < 2 || containerWidth <= 450) {
            //     columns = 2;
            // }

            gutterWidth = parseInt(gutterWidth);

            var allGutters = gutterWidth * (columns - 1);
            var contentWidth = containerWidth - allGutters;

            var columnWidth = Math.floor(contentWidth / columns);
            return {columnWidth: columnWidth, gutterWidth: gutterWidth, columns: columns};
        },

        /**
         * Run masonry gallery
         */
        galleryRunMasonry: function (duration, $container, id, lazyload = true) {
            const isMobile = window.matchMedia("only screen and (max-width: 767px)").matches;
            var layout = $container.data('layout');
            if ($container.is(':hidden')) {
                return;
            }

            var container = $container.find('.gallery-masonry');
            var $postBox = container.children('.wpmf-gallery-item');
            var o = wpmfGallery.calculateGrid($(container));
            var padding = o.gutterWidth;
            if (layout === 'horizontal') {
                if (container.hasClass('justified-gallery')) {
                    return;
                }

                var row_height = $container.data('row_height');
                if (typeof row_height === "undefined" || row_height === '') {
                    row_height = 200;
                }

                setTimeout(function () {
                    container.justifiedGallery({
                        rowHeight: row_height,
                        maxRowHeight: row_height,
                        imgSelector: '> div > img',
                        margins: padding
                    });
                },200);
            }

            if ($container.find('.wpmf-gallery-addon-wrap').hasClass('masonry')) {
                return;
            }

            if (!container.hasClass('gallery-masonry-horizontal')) {
                if (isMobile) {
                    $postBox.css({'width': 100 + '%', 'margin-bottom': padding + 'px'});
                } else {
                    $postBox.css({'width': o.columnWidth + 'px', 'margin-bottom': padding + 'px'});
                }
                $(container).masonry({
                    itemSelector: '.wpmf-gallery-item',
                    columnWidth: o.columnWidth,
                    gutter: padding,
                    isAnimated: true,
                    animationOptions: {
                        duration: duration,
                        easing: 'linear',
                        queue: false
                    },
                    isFitWidth: true
                });
            }


            if (lazyload) {
                if (isMobile) {
                    wpmfGallery.wpmfAutobrowse(id, container, 'masonry', '100%', padding);
                } else {
                    wpmfGallery.wpmfAutobrowse(id, container, 'masonry', o.columnWidth, padding);
                }
            }
            if (!container.hasClass('gallery-masonry-horizontal')) {
                $container.find('.wpmf-gallery-item').addClass('wpmf-gallery-item-show');
            }
        },

        /**
         * lazy load images in gallery
         * @param id theme id
         * @param container container parent of items
         * @param theme_type theme type
         * @param column_width item width
         * @param padding item padding
         */
        wpmfAutobrowse: function (id, container, theme_type, column_width, padding) {
            if (parseInt(wpmfgallery.progressive_loading) === 0) {
                return;
            }

            var count = $(container).data('count');
            var number = 8;
            var offset = 8;
            var current = 0;
            var theme = $(container).closest('.wpmf_gallery_box').data('theme');
            var settings = $(container).closest('.wpmf_gallery_wrap').data('top-gallery-settings');
            if (typeof settings.is_lazy_load === "undefined" || parseInt(settings.is_lazy_load) === 0) {
                return;
            }
            var tags = $(container).closest('.wpmf_gallery_wrap').find('.tab.filter-all-control.selected a').data('filter');
            var justifiedGalleryTimer;
            container.autobrowse(
                {
                    url: function (offset) {
                        var ids = [];
                        $(container).find('.wpmf-gallery-item').each(function () {
                            ids.push($(this).data('id'));
                        });
                        let gallery_ids = [];
                        let fancybox_data = JSON.parse($(container).attr('data-lightbox-items')) ?? [];
                        fancybox_data.forEach(function (el) {
                            let id = el.id;
                            if(!ids.includes(id)){
                                gallery_ids.push(el.id);
                            }
                        });
                        wpmfGallery.ajax_loading = true;
                        var url = wpmfgallery.ajaxurl + '?action=wpmf_get_gallery_item&gallery_id=' + id + '&theme=' + theme + '&offset=' + offset;
                        if (typeof tags !== 'undefined' && tags !== '*') {
                            url += '&tags=' + tags;
                        }
                        return url;
                    },
                    postData:  function () {
                        var ids = [];
                        $(container).find('.wpmf-gallery-item').each(function () {
                            ids.push($(this).data('id'));
                        });
                        let gallery_ids = [];
                        let fancybox_data = JSON.parse($(container).attr('data-lightbox-items')) ?? [];
                        fancybox_data.forEach(function (el) {
                            let id = el.id;
                            if(!ids.includes(id)){
                                gallery_ids.push(el.id);
                            }
                        });
                        return  {settings: JSON.stringify(settings), loaded_ids:  ids.join(), gallery_ids:  gallery_ids.join()}
                    },
                    timeout: 100,
                    template: function (response) {
                        var elems = [];
                        if (response.status) {
                            for (var i = 0; i < 8; i++) {
                                if (typeof response.items[i] !== "undefined") {
                                    var el = $(response.items[i]);
                                    elems[i] = $(el).get(0);
                                    if (theme_type === 'masonry') {
                                        if (!container.hasClass('gallery-masonry-horizontal')) {
                                            $($(el).get(0)).hide().appendTo(container);
                                        } else {
                                            $($(el).get(0)).appendTo(container);
                                        }
                                    } else {
                                        $($(el).get(0)).hide().appendTo(container).fadeIn(800);
                                    }
                                }
                            }

                            current += response.items.length;
                            if (theme_type === 'masonry') {
                                if (container.hasClass('gallery-masonry-horizontal')) {
                                    justifiedGalleryTimer = setTimeout(function () {
                                        clearTimeout(justifiedGalleryTimer);
                                        container.justifiedGallery();
                                    }, 2000);
                                } else {
                                    $(container).imagesLoaded(function () {
                                        if (!container.hasClass('gallery-masonry-horizontal')) {
                                            $(elems).css({
                                                'width': column_width + 'px',
                                                'margin-bottom': padding + 'px',
                                                'opacity': 0
                                            }).show();

                                            if ($(container).masonry()){
                                                $(container).masonry('appended', $(elems));
                                            }
                                            $(elems).animate({
                                                opacity: 1,
                                            }, 100, function () {
                                                // Animation complete.
                                            });
                                            $(container).find('.wpmf-gallery-item').addClass('wpmf-gallery-item-show');
                                        }
                                    });
                                }

                            }

                            wpmfGallery.callPopup();
                            wpmfGallery.photograperHandle();
                        } else {
                            current += 8;
                        }
                    },
                    itemsReturned: function (response) {
                        if (current >= count) {
                            return 0;
                        }
                        return number;
                    },
                    complete: function (response) {
                        wpmfGallery.ajax_loading = false;
                    },
                    finished: function (response) {
                        if (container.hasClass('gallery-masonry-horizontal')) {
                            container.justifiedGallery();
                        }
                        wpmfGallery.ajax_loading = false;
                    },
                    offset: offset
                }
            );
        },

        showToolTip: function () {
            /* Show tooltip for some icon */
            if ($('.wpmftippy').length) {
                tippy('.wpmftippy', {
                    theme: 'wpmf',
                    animation: 'scale',
                    animateFill: false,
                    maxWidth: 300,
                    duration: 0,
                    arrow: true,
                    onShow(instance) {
                        instance.popper.hidden = false;
                        instance.setContent($(instance.reference).data('wpmftippy'));
                    }
                });
            }
        },

        /* init tags event */
        wpmfEventGalleryTags: function () {
            $('.filter-all-control a').unbind('click').bind('click', function () {
                var $this = $(this);
                var galleryId = $this.closest('.wpmf_gallery_box').data('id');
                var $tree = $('.wpmf_gallery_tree[data-id="' + galleryId + '"]');
                var $container = $this.closest('.wpmf_gallery_wrap');
                var img_tags = $(this).data('filter');
                var settings = $container.data('top-gallery-settings');
                if (typeof img_tags !== "undefined") {
                    wpmfGallery.wpmf_img_tags = img_tags;
                }

                /* Load gallery */
                var data = {
                    action: "wpmf_load_gallery",
                    gallery_id: galleryId,
                    tags: wpmfGallery.wpmf_img_tags,
                    settings: settings,
                    wpmf_gallery_nonce: wpmfgallery.wpmf_gallery_nonce
                };

                data.selector = $this.closest('.wpmf_gallery_wrap').data('selector');
                if ($tree.length) {
                    var current = $tree.find('li.selected').data('id');
                    if (current === galleryId) {
                        data.settings = $this.closest('.wpmf_gallery_wrap').data('top-gallery-settings');
                    }
                    data.gallery_id = current;
                } else {
                    data.settings = $this.closest('.wpmf_gallery_wrap').data('top-gallery-settings');
                }

                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: data,
                    beforeSend: function () {
                        $container.find('.wpmf_gallery_box *').hide();
                        $container.find('.wpmf_gallery_box .loading_gallery').show();
                    },
                    success: function (res) {
                        if (res.status) {
                            $this.closest('.wpmf_gallery_box').find('.loading_gallery').hide();
                            $container.find('.wpmf_gallery_box').html('').append(res.html);
                            wpmfGallery.initGallery();
                            wpmfGallery.photograperHandle();
                        }
                    }
                });
            });
        }
    };

    $(document).ready(function () {
        if (wpmfgallery.wpmf_current_theme === 'Gleam') {
            setTimeout(function () {
                wpmfGallery.initGallery();
            }, 1000);
        } else {
            wpmfGallery.initGallery();
        }

        jQuery('.vc_tta-tab').on('click', function () {
            var id = jQuery(this).data('vc-target-model-id');
            if (typeof id === "undefined") {
                id = jQuery(this).find('a').attr('href');
                if (typeof id !== "undefined") {
                    setTimeout(function () {
                        var bodyContainers = jQuery('.vc_tta-panel' + id);
                        if (bodyContainers.find('.wpmf-gallerys').length) {
                            wpmfGallery.initGallery();
                        }
                    }, 200);
                }
            } else {
                setTimeout(function () {
                    var bodyContainers = jQuery('.vc_tta-panel[data-model-id="'+ id +'"]');
                    if (bodyContainers.find('.wpmf-gallerys').length) {
                        wpmfGallery.initGallery();
                    }
                }, 200);
            }
        });

        setTimeout(function () {
            $('.responsive-tabs__list__item').on('click', function () {
                var target = $(this).attr('aria-controls');
                var container = $('#' + target).find('.wpmf-gallerys-addon');
                if (container.length) {
                    var id = container.data('id');
                    wpmfGallery.galleryRunMasonry(400, container, id);
                }
            });

            $('.tabtitle.responsive-tabs__heading').on('click', function () {
                var container = $(this).next('.tabcontent.responsive-tabs__panel').find('.wpmf-gallerys-addon');
                if (container.length) {
                    var id = container.data('id');
                    wpmfGallery.galleryRunMasonry(400, container, id);
                }
            });
        }, 1000);

        // click to tab of advanced tab Blocks
        $('.advgb-tab').on('click', function (event) {
            event.preventDefault();
            var bodyContainers = $(this).closest('.advgb-tabs-wrapper').find('.advgb-tab-body-container');
            setTimeout(function () {
                var currentTabActive = $(event.target).closest('.advgb-tab');
                var href = currentTabActive.find('a').attr('href');
                if (bodyContainers.find('.advgb-tab-body[aria-labelledby="' + href.replace(/^#/, "") + '"] .wpmf-gallerys').length) {
                    wpmfGallery.initGallery();
                }
            }, 200);
        });

        // click to tab of Kadence Blocks
        $('.kt-tabs-title-list .kt-title-item').on('click', function (event) {
            event.preventDefault();
            var href = $(this).attr('id');
            var bodyContainers = $(this).closest('.kt-tabs-wrap').find('.kt-tabs-content-wrap');
            setTimeout(function () {
                if (bodyContainers.find('.kt-tab-inner-content[aria-labelledby="' + href + '"] .wpmf-gallerys').length) {
                    wpmfGallery.initGallery();
                }
            }, 200);
        });

        $('.accordion-header').on('click', function (event) {
            var bodyContainers = $(this).closest('.single-accordion').find('.accordion-inner');
            setTimeout(function () {
                if (bodyContainers.find('.wpmf-gallerys').length) {
                    wpmfGallery.initGallery();
                }
            }, 200);
        });

        // click to tab of Ultimate Blocks
        $('.wp-block-ub-tabbed-content-tab-title-wrap').on('click', function () {
            setTimeout(function () {
                var bodyContainers = $('.wp-block-ub-tabbed-content-tab-content-wrap.active');
                if (bodyContainers.find('.wpmf-gallerys').length) {
                    wpmfGallery.initGallery();
                }
            }, 200);
        });

        $('a[href^="#elementor-action"]').each(function () {
            var $this = $(this);
            var href = $this.attr('href');
            if (href.indexOf('action=popup') !== -1 || href.indexOf('action%3Dpopup') !== -1) {
                $this.on('click', function () {
                    setTimeout(function () {
                        var bodyContainers = $('.elementor-widget-container');
                        if (bodyContainers.find('.wpmf-gallerys').length) {
                            wpmfGallery.initGallery();
                        }
                    }, 500);
                });
            }
        });

        // click download all
        $('.wrap-download-all a').on('click', function(){
            var image_ids = $(this).attr('data-image-ids');
            var gallery_id = $(this).attr('data-gallery-id');
            if(image_ids && gallery_id){
                $.ajax({
                    url: wpmfgallery.ajaxurl,
                    method: "POST",
                    dataType: 'json',
                    data: {
                        action: 'wpmf_gallery_download_image_all',
                        image_ids: image_ids,
                        gallery_id: gallery_id
                    },
                    success: function (res) {
                        if (res.status) {
                            // window.location.href = res.download_url;
                            var link = document.createElement("a");
                            link.href = res.download_url;
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            delete link;
                        }
                    }
                });
            }
        });
    });

    $(document.body).on('post-load', function () {
        wpmfGallery.initGallery();
    });
})(jQuery);

function wpmfStartElemenGallery(){
    jQuery('#elementor-preview-iframe').contents().find('.flipster').imagesLoaded( function() {
        wpmfGallery.doGallery(jQuery('#elementor-preview-iframe').contents().find('.flipster'), 'flowslide');
    });

    jQuery('#elementor-preview-iframe').contents().find('.wpmfslick').imagesLoaded( function() {
        wpmfGallery.doGallery(jQuery('#elementor-preview-iframe').contents().find('.wpmfslick'), 'slider');
    });

    jQuery('#elementor-preview-iframe').contents().find('.wpmf-custom-grid').imagesLoaded( function() {
        wpmfGallery.doGallery(jQuery('#elementor-preview-iframe').contents().find('.wpmf-custom-grid'), 'custom_grid');
    });

    jQuery('#elementor-preview-iframe').contents().find('.gallery-masonry').imagesLoaded( function() {
        var galleries = jQuery('#elementor-preview-iframe').contents().find('.wpmf_gallery_box');
        galleries.each(function () {
            var $this = jQuery(this);
            jQuery(this).find('.loading_gallery').hide();
            var layout = jQuery(this).find('.wpmf-gallerys-addon').data('layout');
            if (layout === 'vertical') {
                jQuery(this).find('.gallery-masonry').isotope({
                    itemSelector: '.wpmf-gallery-item',
                    layoutMode: 'masonry',
                    percentPosition: true,
                    masonry: {
                        columnWidth: '.wpmf-gallery-item'
                    }
                });
            } else {
                var row_height = jQuery(this).find('.wpmf-gallerys-addon').data('row_height');
                if (typeof row_height === "undefined" || row_height === '') {
                    row_height = 200;
                }
                var padding = jQuery(this).find('.gallery-masonry').data('gutter-width');
                setTimeout(function () {
                    $this.find('.gallery-masonry').justifiedGallery({
                        rowHeight: row_height,
                        margins: padding
                    });
                },500);
            }

            jQuery(this).find('.gallery-masonry .wpmf-gallery-item').addClass('wpmf-gallery-item-show');
        });
    });
}

jQuery(window).on('load', function(){
    if (typeof elementorFrontend !== "undefined") {
        elementorFrontend.hooks.addAction('frontend/element_ready/widget', function($scope){
            wpmfStartElemenGallery();
        });
    }
});