<?php
$class[] = 'wpmf-gallerys wpmf-gallerys-addon wpmf-flipster';
$class[] = 'wpmf-has-border-radius-' . $img_border_radius;
if (count($attachments) === 1) {
    $class[] = 'wpmf-single-item';
}
$class = implode(' ', $class);
$style = '';
if ($img_shadow !== '') {
    $style .= '#' . $selector . ' .wpmf-gallery-item.flipster__item--current img:not(.glrsocial_image):hover, #' . $selector . ' .wpmf-gallery-item.flipster__item--current .wpmf_overlay {box-shadow: ' . $img_shadow . ' !important; transition: all 200ms ease;}';
}

if ($border_style !== 'none') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image) {border: ' . $border_color . ' ' . $border_width . 'px ' . $border_style . '}';
}

wp_add_inline_style('wpmf-gallery-style', $style);
if (isset($is_divi) && (int)$is_divi === 1) {
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- This variable is html
    echo '<style>' . $style . '</style>';
}
$gallery_configs = get_option('wpmf_gallery_settings');
$lightbox_items = $this->getLightboxItems($attachments, $targetsize);
echo '<div class="' . esc_attr($class) . '" data-theme="' . esc_attr($display) . '" data-id="' . esc_attr($id) . '" data-lightbox-items="' . esc_attr(json_encode($lightbox_items)) . '">';
echo '<div id="' . esc_attr($selector) . '" class="flipster" data-button="' . esc_attr($show_buttons) . '">';
echo '<ul>';
foreach ($attachments as $index => $attachment) {
    $hovers = $this->renderHoverStyle($attachment, $params);
    $hover_color_style = $hovers['hover_color_style'];
    $hover_box = $hovers['hover_box'];
    $post_title = (!empty($caption_lightbox) && $attachment->post_excerpt !== '') ? $attachment->post_excerpt : $attachment->post_title;
    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags = wp_get_post_terms($attachment->ID, 'wpmf_tag');
    if ($img_tags) {
        $img_tags = array_column($img_tags, 'name');
        $img_tags = implode(',', $img_tags);
    } else {
        $img_tags = '';
    }
    $custom_link = get_post_meta($attachment->ID, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);

    $remote_video = get_post_meta($attachment->ID, 'wpmf_remote_video_link', true);
    if (strpos($attachment->post_mime_type, 'video/') !== false) {
        $video = true;
    } else {
        $video = false;
    }

    if (!empty($attachment->type) && $attachment->type === 'google_photo') {
        if ($link === 'post') {
            // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited -- It is a variable in plugin
            $link = 'none';
        }
    }

    if (($custom_link) && $custom_link !== '') {
        $image_output = $this->galleryGetAttachmentLink($attachment->ID, $size, false);
        if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
            $icon = '<a ' . $hover_color_style . ' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"   title="' . esc_attr($post_title) . '" class="wpmf_overlay" target="' . $link_target . '">' . $hover_box . '</a>';
        } else {
            $icon = '<a ' . $hover_color_style . ' href="' . $custom_link . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay" target="' . $link_target . '">' . $hover_box . '</a>';
        }
        $icon .= $social;
    } else {
        switch ($link) {
            case 'none':
                $image_output = wp_get_attachment_image($attachment->ID, $size, false, array('data-type' => 'wpmfgalleryimg'));
                $icon = '<div ' . $hover_color_style . ' class="wpmf_overlay">' . $hover_box . '</div>';
                $icon .= $social;
                break;

            case 'post':
                $image_output = $this->galleryGetAttachmentLink($attachment->ID, $size, true);
                $url = get_attachment_link($attachment->ID);
                $icon = '<a ' . $hover_color_style . ' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay" target="' . $link_target . '">' . $hover_box . '</a>';
                $icon .= $social;
                break;

            default:
                $image_output = $this->galleryGetAttachmentLink($attachment->ID, $size, false);
                if (!empty($attachment->type) && $attachment->type === 'google_photo') {
                    $url = $attachment->url . '=w' . $attachment->width . '-h' . $attachment->height;
                } else {
                    $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                    $url = $lightboxUrls['url'];
                }
                $icon = '<a ' . $hover_color_style . ' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"
class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay ' . (!empty($remote_video) ? 'isvideo' : '') . '">' . $hover_box . '</a>';
                $icon .= $social;
        }
    }

    if (!empty($attachment->type) && $attachment->type === 'google_photo') {
        $image_output = '<img class="wpmf_slider_img" alt="'. esc_attr($attachment->post_title) .'" src="'. esc_url($attachment->url) .'">';
    }

    $downloads = wpmfGalleryGetDownloadLink($attachment);
    if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
        $icon .= '<a href="' . esc_url($downloads['download_link']) . '" ' . (($downloads['type'] === 'local') ? 'download' : '') . ' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
    }
    echo '<li class="wpmf-gallery-item wpmf-gallery-icon" data-index="' . esc_html($index) . '" data-tags="' . esc_html($img_tags) . '">';
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Content already escaped in the method
    echo wpmfRenderVideoIcon($attachment->ID);
    echo $icon . $image_output; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    echo '</li>';
}
echo "</ul></div></div>\n";
