<?php
global $current_user;
$gallery_configs = get_option('wpmf_gallery_settings');
$show_form = false;
if ((!empty($current_user->ID) && in_array('administrator', $current_user->roles)) || !empty($gallery_configs['photographer_photo_comments'])) {
    $show_form = true;
}
?>
<div id="open_gallery_comments_<?php echo (int)$id ?>" data-gallery_id="<?php echo (int)$id ?>"
     class="gallery_comments_box mfp-hide">
    <?php if ($show_form) : ?>
        <div class="gallery_name_inputs" style="display: <?php echo (!empty($current_user->ID)) ? 'none' : 'block' ?>">
            <div>
                <p>
                    <b><?php echo esc_html__('Your name', 'wp-media-folder-gallery-addon') ?></b><input type="text"
                                                                                                        value="<?php echo (!empty($current_user->ID)) ? esc_attr($current_user->data->display_name) : '' ?>"
                                                                                                        class="wpmf_gallery_author_name_input">
                </p>
            </div>
        </div>
    <?php endif; ?>
    <div class="gallery_comments_wrap">

    </div>
    <?php if ($show_form) : ?>
        <div class="wpmf_gallery_buttons">
            <button type="button"
                    class="wpmf_cancel_gallery_btn"><?php echo esc_html__('Cancel', 'wp-media-folder-gallery-addon') ?></button>
            <button type="button"
                    class="wpmf_submit_gallery_btn"><?php echo esc_html__('Submit', 'wp-media-folder-gallery-addon') ?></button>
        </div>
    <?php endif; ?>
</div>