(function ($) {
	const wpmfAIModule = {
        totalImages: 0,
        processedImages: 0,
        isProcessingBulkAI: false,
        page_type: null,

        /**
         * Initialize module
         */
        init: function ($frame) {
            if (!$frame.find('.wpmf-ai-img-optimize-button').length && parseInt(wpmf.vars.batch_ai_optimization) == 1) {
                const buttonHTML = `
                    <button class="button wpmf-ai-img-optimize-button wpmf-disabled-btn media-button button-large">
                        <span class="ju-icon-AI"></span><span>${wpmf.l18n.ai_image_optimization}</span>
                        <div class="wpmf-ai-tooltip-content">
                            <span class="wpmf-ai-tooltip-initial">${wpmf.l18n.tooltip_opt_single}</span>
                            <span class="wpmf-ai-tooltip-initial">${wpmf.l18n.tooltip_opt_bulk}</span>
                            <span class="wpmf-ai-tooltip-bulk">${wpmf.l18n.tooltip_select_images}</span>
                        </div>
                    </button>
                `;

                if (!$frame.parent().hasClass('media-modal-content')) {
                    $frame.find('.media-frame-content .media-toolbar-secondary .wpmf-dropdowns-wrap').after(buttonHTML);
                } else {
                    $frame.find('.media-frame-content .media-toolbar-secondary .wpmf-dropdowns-wrap').append(buttonHTML);
                    wpmfAIModule.initAttachmentLabelAI();
                }

                $frame.find('.wpmf-ai-img-optimize-button').on('click', function () {
                    if ($(this).hasClass('wpmf-disabled-btn')) {
                        return;
                    }

                    wpmfAIModule.processBulkAIOptimization($frame);
                });
            }

            if (!$frame.find('.wpmf-ai-progress-wrap').length && parseInt(wpmf.vars.batch_ai_optimization) == 1) {
                const progressHTML = `
                    <div class="wpmf-ai-progress-wrap">
                        <div class="wpmf-ai-progress-header">
                            <div class="wpmf-ai-progress-label">
                                <span class="dashicons dashicons-update spin"></span>
                                <span class="wpmf-ai-progress-text">${wpmf.l18n.analyzing_with_ai}</span>
                            </div>
                            <div class="wpmf-ai-progress-percent">0%</div>
                        </div>
                        <div class="wpmf-ai-progress-bar">
                            <div class="wpmf-ai-progress-fill"></div>
                        </div>
                    </div>
                `;
                $frame.find('.media-toolbar').after(progressHTML);
            }

            if (wpmf.vars.wpmf_pagenow === 'upload.php' && $('#posts-filter input[name="mode"][value="list"]').length && $('#posts-filter .media').length) {
                wpmfAIModule.page_type = 'upload-list';
            } else if (wpmf.vars.wpmf_pagenow === 'upload.php' && $('#wp-media-grid').length) {
                wpmfAIModule.page_type = 'upload-grid';
                wpmfAIModule.initAttachmentLabelAI();
            }
        },

        processBulkAIOptimization: function ($frame) {
            if (this.isProcessingBulkAI) {
                showWpmfToast(wpmf.l18n.bulk_ai_optimization_in_progress, 'warning');
                return;
            }

            const selection = $frame.find('.attachment.selected');

            if (!selection || selection.length === 0) {
                alert(wpmf.l18n.select_at_least_one_image);
                return;
            }

            $('.wpmf-ai-progress-wrap').fadeIn();
            this.isProcessingBulkAI = true;

            const attachmentIds = [];

            selection.sort(function (a, b) {
                const orderA = $(a).data('wpmf-selected-order') || 0;
                const orderB = $(b).data('wpmf-selected-order') || 0;
                return orderA - orderB;
            }).each(function () {
                const id = $(this).data('id');
                if (id) {
                    attachmentIds.push(id);
                }
            });

            this.totalImages = attachmentIds.length;
            this.processedImages = 0;

            if (wpmf.vars.ai_use_url) {
                selection.each(function () {
                    const $attachment = $(this);
                    $attachment.addClass('wpmf-ai-processing');

                    if (!$attachment.find('.wpmf-ai-status-icon').length) {
                        $attachment.find('.attachment-preview').append(`
                            <div class="wpmf-ai-status-icon wpmf-processing-icon"></div>
                        `);
                    }
                });
            }

            this.sendNextAIRequest(attachmentIds, 0, $frame);
        },

        processBulkAIOptimizationFromList: function (attachmentIds) {
            if (this.isProcessingBulkAI) {
                showWpmfToast(wpmf.l18n.bulk_ai_optimization_in_progress, 'warning');
                return;
            }

            if (!attachmentIds.length) {
                showWpmfToast(wpmf.l18n.select_at_least_one_image, 'warning');
                return;
            }

            this.isProcessingBulkAI = true;
            this.totalImages = attachmentIds.length;
            this.processedImages = 0;

            $('.wpmf-ai-progress-wrap').fadeIn();
            this.sendNextAIRequest(attachmentIds, 0, this.getFrame());
        },

        sendNextAIRequest: function(attachmentIds, index, $frame, retryCount = 0) {
            const self = this;

            if (wpmf.vars.ai_use_url && index === 0) {
                showWpmfToast(wpmf.l18n.ai_request_sent.replace('%d', attachmentIds.length));
            }

            if (index >= attachmentIds.length) {
                if (!wpmf.vars.ai_use_url) {
                    this.startProgressPolling(attachmentIds, $frame);
                    showWpmfToast(wpmf.l18n.ai_request_sent.replace('%d', attachmentIds.length));
                }

                $frame.find('.attachment.selected').removeClass('selected');
                if ($('.mode-select .select-mode-toggle-button').length) {
                    $('.mode-select .select-mode-toggle-button').click();
                }

                return;
            }

            const attachmentId = attachmentIds[index];

            const $attachment = $frame.find(`.attachment[data-id="${attachmentId}"]`);
            if (!$attachment.hasClass('wpmf-ai-done')) {
                $attachment.addClass('wpmf-ai-processing');
            }

            if (!$attachment.find('.wpmf-ai-status-icon').length) {
                $attachment.find('.attachment-preview').append(`
                    <div class="wpmf-ai-status-icon wpmf-processing-icon"></div>
                `);
            }

            $.ajax({
                url: wpmf.vars.ajaxurl,
                method: 'POST',
                data: {
                    action: 'wpmf_analyze_image_ai',
                    attachment_id: attachmentId
                },
                success: function (response) {
                    var status = false;
                    if (response.success) {
                        if (wpmf.vars.ai_use_url) {
                            status = true;
                        }
                    } else {
                        var filename = $attachment.find('.filename').text();
                        if (!filename) {
                            filename = `ID ${attachmentId}`;
                        }

                        var errorMsg = response.data?.message || 'Unknown error';
                        var errorText = `${wpmf.l18n.ai_image_process_error} "${filename}": ${errorMsg}`;
                        showWpmfToast(errorText, 'error');

                        $attachment.removeClass('wpmf-ai-processing').addClass('wpmf-ai-failed');
                        $attachment.find('.wpmf-ai-status-icon').remove();

                        if (!$attachment.find('.wpmf-ai-status-icon.wpmf-failed-icon').length) {
                            const failIcon = $('<div class="wpmf-ai-status-icon wpmf-failed-icon"></div>');
                            $attachment.find('.attachment-preview').append(failIcon);
                            failIcon.fadeOut(1000, function () {
                                $(this).remove();
                            });
                        }
                    }

                    self.updateImageUI(attachmentId, $frame, status);
                    self.sendNextAIRequest(attachmentIds, index + 1, $frame);
                },
                error: function () {
                    if (retryCount < 2) {
                        setTimeout(() => {
                            self.sendNextAIRequest(attachmentIds, index, $frame, retryCount + 1);
                        }, 1000);
                    } else {
                        self.sendNextAIRequest(attachmentIds, index + 1, $frame);
                    }
                }
            });
        },

        startProgressPolling: function (attachmentIds, $frame) {
            var self = this;
            var intervalId = setInterval(function () {
                $.ajax({
                    url: wpmf.vars.ajaxurl,
                    method: 'POST',
                    data: {
                        action: 'wpmf_get_ai_progress'
                    },
                    success: function (res) {
                        if (res.success && Array.isArray(res.data.ids)) {
                            var total = self.totalImages;
                            var remaining = attachmentIds.filter(id => res.data.ids.includes(id)).length;

                            var processed = total > 0 ? Math.max(total - remaining, 0) : 0;
                            var percent = Math.round((processed / total) * 100);

                            $('.wpmf-ai-progress-fill').css('width', percent + '%');
                            $('.wpmf-ai-progress-percent').text(percent + '%');

                            attachmentIds.forEach(function (attachmentId) {
                                if (!res.data.ids.includes(attachmentId)) {
                                    var attachment = $(`.attachment[data-id="${attachmentId}"]`);

                                    if (attachment.hasClass('wpmf-ai-done')) {
                                        return;
                                    }

                                    attachment.removeClass('wpmf-ai-processing').addClass('wpmf-ai-done');
                                    attachment.find('.wpmf-ai-status-icon').remove();

                                    var doneIcon = $('<div class="wpmf-ai-status-icon wpmf-done-icon"></div>');
                                    attachment.find('.attachment-preview').append(doneIcon);
                                    doneIcon.fadeOut(1000, function () {
                                        $(this).remove();
                                    });

                                    if(attachment.find('.attachment-preview .wpmf_ai_text.ju-icon-AI').length == 0) {
                                        attachment.find('.attachment-preview').append('<span class="wpmf_ai_text ju-icon-AI"></span>');
                                    }
                                }
                            })


                            if (remaining === 0 || percent >= 100) {
                                clearInterval(intervalId);
                                self.isProcessingBulkAI = false;

                                attachmentIds.forEach(function (attachmentId) {
                                    $(`.attachment[data-id="${attachmentId}"]`).removeClass('wpmf-ai-done');
                                });

                                setTimeout(() => {
                                    $('.wpmf-ai-progress-wrap').fadeOut(() => {
                                        $('.wpmf-ai-progress-fill').css('width', '0%');
                                        $('.wpmf-ai-progress-percent').text('0%');
                                    });

                                    var selectedCount = $('.attachments .attachment.selected').length;
                                    var btn = $('.media-toolbar .wpmf-ai-img-optimize-button');
                                    if (selectedCount === 0 && !btn.hasClass('wpmf-disabled-btn')) {
                                        btn.addClass('wpmf-disabled-btn');
                                    }
                                }, 1500);
                            }
                        }
                    }
                });
            }, 1000);
        },

        getFrame: function () {
            if (wpmfAIModule.page_type === 'upload-list') {
                return $('.upload-php #posts-filter');
            } else {
                if ($('.media-frame.mode-select[id^="__wp-uploader-id-"]:visible').length) {
                    return $('.media-frame.mode-select[id^="__wp-uploader-id-"]:visible');
                } else {
                    return $('[id^="__wp-uploader-id-"]:visible div.media-frame');
                }
            }
        },

        initAttachmentLabelAI: function () {
            var current_frame = wpmfAIModule.getFrame();
            var timeout = void 0;
            const targetNode =  current_frame.find('.attachments-browser ul.attachments')[0];
            const config = { attributes: true, childList: true, subtree: true };

            const callback = (mutationList, observer) => {
                for (const mutation of mutationList) {
                    if (mutation.type === "childList") {
                        window.clearTimeout(timeout);
                        timeout = window.setTimeout(function () {
                            current_frame.find('.attachments-browser ul.attachments .attachment .thumbnail').each(function (i, v) {
                                var $wrap = $(v).closest('.attachment');
                                var id = $wrap.data('id');
                                var src_img = wp.media.attachment(id).get('url');
                                var wpmf_ai_optimized = wp.media.attachment(id).get('wpmf_ai_optimized');
                                if (typeof src_img !== "undefined") {
                                    if (typeof wpmf_ai_optimized !== "undefined") {
                                        if (!$wrap.find('.wpmf_ai_text').length) {
                                            $wrap.find('.attachment-preview').append('<span class="wpmf_ai_text ju-icon-AI"></span>');
                                        }
                                    }
                                }
                            })
                        }, 300);
                    }
                }
            };

            if (targetNode){
                const observer = new MutationObserver(callback);  
                observer.observe(targetNode, config);
            }
        },

        updateImageUI: function(attachmentId, $frame, status = true) {
            if (status) {
                const attachment = $frame.find(`.attachment[data-id="${attachmentId}"]`);

                attachment.removeClass('wpmf-ai-processing').addClass('wpmf-ai-done');
                attachment.find('.wpmf-ai-status-icon').remove();

                const doneIcon = $('<div class="wpmf-ai-status-icon wpmf-done-icon"></div>');
                attachment.find('.attachment-preview').append(doneIcon);
                doneIcon.fadeOut(1000, function () {
                    $(this).remove();
                });

                attachment.find('.attachment-preview').append('<span class="wpmf_ai_text ju-icon-AI"></span>');
            }

            this.processedImages++;
            const percent = Math.round((this.processedImages / this.totalImages) * 100);
            $('.wpmf-ai-progress-fill').css('width', percent + '%');
            $('.wpmf-ai-progress-percent').text(percent + '%');

            if (percent >= 100) {
                this.isProcessingBulkAI = false;
                setTimeout(() => {
                    $('.wpmf-ai-progress-wrap').fadeOut(() => {
                        $('.wpmf-ai-progress-fill').css('width', '0%');
                        $('.wpmf-ai-progress-percent').text('0%');
                    });

                    var selectedCount = $('.attachments .attachment.selected').length;
                    var btn = $('.media-toolbar .wpmf-ai-img-optimize-button');
                    if (selectedCount === 0 && !btn.hasClass('wpmf-disabled-btn')) {
                        btn.addClass('wpmf-disabled-btn');
                    }
                }, 1500);
            }
        }
    };

    /**
     * Inject button before "Alternative Text" field in Media sidebar
     */
    function wpmfInjectSidebarButton(view) {
        if (view && view.$el && view.model) {
            const altField = view.$el.find('.attachment-info .setting[data-setting="alt"]');
            if (altField.length && view.$el.find('.my-custom-button').length === 0) {
                const attachmentId = view.model.id;
                const $btn = $(`
                    <button type="button" class="button wpmf-ai-img-optimize-button wpmf-attachemt-detail-btn" data-attachment-id="${attachmentId}">
                        <span class="ju-icon-AI"></span><span class="ju-button-text">${wpmf.l18n.generate_with_ai}</span>
                    </button>
                `);
                $btn.insertBefore(altField);

                const model = wp.media.attachment(attachmentId);
                model.fetch();
            }
        } else {
            const sidebar = $('.media-sidebar');
            if (sidebar.length && sidebar.find('.wpmf-ai-img-optimize-button').length === 0) {
                const altField = sidebar.find('.attachment-details .setting[data-setting="alt"]');
                if (altField.length) {
                    const idInput = sidebar.find('.wpmf_attachment_id').val();
                    const attachmentId = parseInt(idInput || 0, 10);
                    if (!attachmentId) return;

                    const $btn = $(`
                        <button type="button" class="button wpmf-ai-img-optimize-button wpmf-attachemt-detail-btn" data-attachment-id="${attachmentId}">
                            <span class="ju-icon-AI"></span><span class="ju-button-text">${wpmf.l18n.generate_with_ai}</span>
                        </button>
                    `);
                    $btn.insertBefore(altField);
                    const model = wp.media.attachment(attachmentId);
                    model.fetch();
                }
            }
        }
    };

    function startPollingAIResult(attachmentId, button) {
        const pollingInterval = 2000;
        let attempts = 0;
        const maxAttempts = 15;

        const intervalId = setInterval(function () {
            $.ajax({
                url: wpmf.vars.ajaxurl,
                method: 'POST',
                data: {
                    action: 'wpmf_check_ai_result',
                    attachment_id: attachmentId
                },
                success: function (res) {
                    if (res.success && res.data && res.data.status === 'done') {
                        clearInterval(intervalId);
                        updateAttachmentFieldsUI(attachmentId, res.data, button);
                        button.find('.ju-button-text').text(wpmf.l18n.generated).prop('disabled', false);

                        if (typeof wpmfAIModule.totalImages !== 'undefined') {
                            wpmfAIModule.processedImages++;
                            const percent = Math.round((wpmfAIModule.processedImages / wpmfAIModule.totalImages) * 100);
                            $('.wpmf-ai-progress-fill').css('width', percent + '%');
                            $('.wpmf-ai-progress-percent').text(percent + '%');
                        }
                    }
                }
            });

            attempts++;
            if (attempts >= maxAttempts) {
                clearInterval(intervalId);
                button.find('.ju-button-text').text(wpmf.l18n.try_again).prop('disabled', false);
                alert('Timeout: AI did not respond in time.');
            }
        }, pollingInterval);
    }

    function updateAttachmentFieldsUI(attachmentId, data, button) {
        if(isMediaLibrary() || button.closest('.media-modal-content').length > 0) {
            var settings;
            if (isMediaLibrary()) {
                settings = $(button).closest('.settings');
            } else {
                settings = $(button).closest('.attachment-details');
            }

            if (data.alt) settings.find('[data-setting="alt"] textarea').val(data.alt);
            if (data.description) settings.find('[data-setting="description"] textarea').val(data.description);
            if (data.title) settings.find('[data-setting="title"] input').val(data.title);
            if (data.caption) settings.find('[data-setting="caption"] textarea').val(data.caption);
        } else {
            if (data.title) $('#title').val(data.title);
            if (data.alt) $('#attachment_alt').val(data.alt);
            if (data.caption) $('#attachment_caption').val(data.caption);
            if (data.description) $('#attachment_content').val(data.description);
        }
    }

    function isMediaLibrary() {
        return window.location.href.includes('/upload.php');
    };

    function getAIQuota() {
        $.ajax({
            url: wpmf.vars.ajaxurl,
            method: 'POST',
            data: {
                action: 'wpmf_get_ai_quota'
            },
            success: function (response) {
                if (response.success && response.data && parseFloat(response.data.quota) > 0) {
                    const data = response.data;
                    const percent = data.percent_used + '%';

                    // === Group 1: Admin bar
                    if ($('.wpmf-ai-quota-container').length > 0) {
                        const $status = $('.wpmf-ai-quota-status');
                        $status.css('background-color', data.bar_color);
                        $status.contents().filter(function () {
                            return this.nodeType === 3;
                        }).remove();
                        $status.append(' ' + percent);

                        $('.wpmf-ai-quota-used').text(data.consummate_quota);

                        $('.wpmf-ai-quota-progress-bar')
                            .css('width', percent)
                            .css('background-color', data.bar_color);

                        $('.wpmf-ai-quota-remaining-count')
                            .text(data.remaining_quota)
                            .css('color', data.bar_color);
                    }

                    // === Group 2: Setting
                    if ($('.wpmf-ai-plan-content').length > 0) {
                        $('.wpmf-plan-used').text(data.consummate_quota);

                        $('.wpmf-ai-progress-bar')
                            .css({
                                'width': percent,
                                'background-color': data.bar_color
                            });

                        $('.wpmf-ai-plan-remaining-count')
                            .text(data.remaining_quota)
                            .css('color', data.bar_color);
                    }
                } else {
                    if (wpmf.vars.ai_plan_status === 'paid') {
                        showWpmfAiNotice((response.data?.message || 'Unknown error'), 'error', false);
                    }
                    $('#wp-admin-bar-wpmf_ai_quota_status').remove();
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });
    }

    function showWpmfToast(message, status = 'success') {
        var iconMap = {
            success: 'ju-icon-check',
            error: 'ju-icon-error',
            warning: 'ju-icon-warning'
        };

        var iconClass = iconMap[status] || iconMap.success;

        var container = $('#wpmf-toast-container');
        if (!container.length) {
            container = $('<div id="wpmf-toast-container"></div>');
            $('body').append(container);
        }

        var popup = $(`
            <div class="wpmf-toast wpmf-toast-${status}">
                <div class="wpmf-toast-status"><span class="${iconClass}"></span></div>
                <div class="wpmf-toast-message">${message}</div>
                <span class="wpmf-toast-close ju-icon-close"></span>
            </div>
        `);

        container.append(popup);

        setTimeout(() => {
            popup.fadeOut(400, function () {
                $(this).remove();
            });
        }, 4000);

        popup.find('.wpmf-toast-close').on('click', function () {
            popup.fadeOut(400, function () {
                $(this).remove();
            });
        });
    }

    function showWpmfAiNotice(message, status = 'success', autoClose = true) {
        var statusClasses = {
            success: 'wpmf-ai-notice-success',
            error: 'wpmf-ai-notice-error',
            warning: 'wpmf-ai-notice-warning',
        };

        var icons = {
            success: 'ju-icon-check',
            error: 'ju-icon-error',
            warning: 'ju-icon-warning'
        };

        var container = $('#wpmf-ai-notice-container');
        if (!container.length) {
            container = $('<div id="wpmf-ai-notice-container"></div>');
            $('body').append(container);
        }

        container.find('.wpmf-ai-notice').fadeOut(200, function () {
            $(this).remove();
        });

        var notice = $(
            '<div class="wpmf-ai-notice ' + (statusClasses[status] || statusClasses.success) + '">' +
            '<i class="wpmf-ai-notice-icon' + (icons[status] || icons.success) + '"></i>' +
            '<span class="wpmf-ai-notice-message">' + message + '</span>' +
            '<button type="button" class="wpmf-ai-notice-close ju-icon-close" aria-label="Close"></button>' +
            '</div>'
        );

        container.append(notice);

        notice.on('click', '.wpmf-ai-notice-close', function() {
            notice.fadeOut(200, function() {
                $(this).remove();
            });
        });

        if (autoClose) {
            setTimeout(function() {
                notice.fadeOut(200, function() {
                    $(this).remove();
                });
            }, 5000);
        }
    }


	$(document).ready(function () {
        if (window.location.pathname.includes('wp-admin/options-general.php') &&
            window.location.search.includes('page=option-folder')) {
            getAIQuota();
        }

        $(document).on('click', '.sidebar-sub-item a', function (e) {
            const hash = $(this).attr('href');

            if (hash === '#ai_settings') {
                getAIQuota();
            }
        });

        $('.wpmf-ai-subscribe-link').on('click', function (e) {
            var href = $(this).attr('href');
            var hash = this.hash;
            var targetPage = 'options-general.php?page=option-folder';
            var isSamePage = window.location.href.includes(targetPage);

            if (isSamePage && hash) {
                e.preventDefault();
                window.location.hash = hash;
                const tabTrigger = $('a[href="' + hash + '"]');
                if (tabTrigger.length) {
                    $('.sidebar-menu-item.has-submenu').removeClass('expanded');
                    tabTrigger.closest('li[data-parent-id="ai_tools"]').addClass('expanded')
                    tabTrigger.trigger('click');
                }
            }
        })

        // only run in list view and grid view in upload.php page
        if (typeof wp === "undefined") {
            return;
        }

        if ((wpmf.vars.wpmf_pagenow === 'upload.php' && !wpmfFoldersModule.page_type) || typeof wp.media === "undefined") {
            return;
        }

        if (wpmf.vars.ai_plan_status === 'not_paid') {
            return;
        }

        if (typeof wpmfFoldersModule !== 'undefined' && wpmfFoldersModule.page_type !== 'upload-list') {
            // Wait for the main wpmf module to be ready
            wpmfFoldersModule.on('ready', function ($current_frame) {
                wpmfAIModule.init($current_frame);
            });
        }

        const originalRender = wp.media && wp.media.view && wp.media.view.Attachment.Details.TwoColumn
            ? wp.media.view.Attachment.Details.TwoColumn.prototype.render
            : null;

        if (originalRender) {
            wp.media.view.Attachment.Details.TwoColumn.prototype.render = function () {
                const result = originalRender.apply(this, arguments);
                setTimeout(() => wpmfInjectSidebarButton(this), 200);
                return result;
            };
        }

        const sidebarObserver = new MutationObserver(() => {
            $('.media-sidebar .attachment-info').each(function () {
                setTimeout(() => wpmfInjectSidebarButton(), 200);
            });
        });

        const observeGutenbergSidebar = () => {
            const modal = document.querySelector('.media-modal');
            if (modal) {
                sidebarObserver.observe(modal, {
                    childList: true,
                    subtree: true
                });
            }
        };

        const modalObserver = new MutationObserver(() => {
            const modal = document.querySelector('.media-modal');
            if (modal && !modal.classList.contains('wpmf-sidebar-observed')) {
                modal.classList.add('wpmf-sidebar-observed');
                observeGutenbergSidebar();
            }
        });

        modalObserver.observe(document.body, {
            childList: true,
            subtree: true
        });

        if ($('.post-type-attachment .page-title-action').length && !isMediaLibrary()) {
            var attachmentId = $('#post_ID').val();
            var customBtn = $(`
                <button type="button" class="button wpmf-ai-img-optimize-button wpmf-attachemt-detail-btn wpmf-edit-media" data-attachment-id="${attachmentId}">
                    <span class="ju-icon-AI" style="vertical-align: middle;"></span><span class="ju-button-text">${wpmf.l18n.generate_with_ai}</span>
                </button>
            `);
            $('.wrap > .page-title-action').after(customBtn);
        }

        if ($('.wpmf-action-attachment').length && isMediaLibrary()) {
            // add AI button on list mode
            $('.wpmf-action-attachment').each(function(i, obj) {
                const attachmentId = $(this).attr('data-id');
                var customBtn = $(`
                    <div><button type="button" class="button wpmf-ai-img-optimize-button wpmf-attachemt-detail-btn wpmf-edit-media" data-attachment-id="${attachmentId}">
                        <span class="ju-icon-AI" style="vertical-align: middle;"></span><span class="ju-button-text">${wpmf.l18n.generate_with_ai}</span>
                    </button></div>
                `);
                $(obj).prepend(customBtn);
            });
        }


        var wpmfSelectOrder = 1;
        $(document).on('mousedown', '.attachments .attachment', function () {
            if (!$(this).hasClass('selected') || typeof $(this).data('wpmf-selected-order') === 'undefined') {
                $(this).data('wpmf-selected-order', wpmfSelectOrder++);
            }

            setTimeout(function () {
                var selectedCount = $('.attachments .attachment.selected').length;
                var btn = $('.media-toolbar .wpmf-ai-img-optimize-button');

                if (selectedCount > 0) {
                    btn.removeClass('wpmf-disabled-btn');
                } else {
                    btn.addClass('wpmf-disabled-btn');
                }
            }, 200);
        })

        $(document).on('click', '.media-toolbar-secondary .select-mode-toggle-button', function() {
            var btn = $('.media-toolbar .wpmf-ai-img-optimize-button');
            if (!btn.hasClass('wpmf-disabled-btn')) {
                btn.addClass('wpmf-disabled-btn');
            }
        })

        $(document).off('click', '.wpmf-ai-img-optimize-button.wpmf-attachemt-detail-btn').on('click', '.wpmf-ai-img-optimize-button.wpmf-attachemt-detail-btn', function (e) {
            e.preventDefault();

            const button = $(this);
            const attachmentId = button.data('attachment-id');

            button.find('.ju-button-text').text(wpmf.l18n.analyzing_text).prop('disabled', true);

            $.ajax({
                url: wpmf.vars.ajaxurl,
                method: 'POST',
                data: {
                    action: 'wpmf_analyze_image_ai',
                    attachment_id: attachmentId
                },
                success: function (response) {
                    if (response.success) {
                        const result = response.data;
                        if (result.skipped) {
                            button.find('.ju-button-text').text(wpmf.l18n.generate_with_ai).prop('disabled', false);
                            wpmfSnackbarModule.show({
                                id: 'wpmf_ai_skip_notice',
                                content: result.message
                            });
                        } else {
                            startPollingAIResult(attachmentId, button);
                        }
                    } else {
                        alert((response.data?.message || 'Unknown error'));
                        button.find('.ju-button-text').text(wpmf.l18n.generate_with_ai).prop('disabled', false);
                    }
                },
                error: function () {
                    alert('AJAX request failed.');
                    button.find('.ju-button-text').text(wpmf.l18n.generate_with_ai).prop('disabled', false);
                }
            });
        });

        $(document).off('click', '.ai_image_optimization_folder').on('click', '.ai_image_optimization_folder', function() {
            const folderId = wpmfFoldersModule.editFolderId;
            
            if (!folderId) return;

            $.ajax({
                url: wpmf.vars.ajaxurl,
                method: 'POST',
                data: {
                    action: 'wpmf_get_attachments_in_folder',
                    folder_id: folderId
                },
                success: function (response) {
                    if (response.success && Array.isArray(response.data)) {
                        wpmfAIModule.processBulkAIOptimizationFromList(response.data);
                    } else {
                        showWpmfToast(wpmf.l18n.no_attachments_found, 'warning');
                    }
                },
                error: function () {
                    showWpmfToast('Failed to fetch attachments from folder.', 'error');
                }
            });
        })

        $(document).off('click', '.ai_image_optimization_image').on('click', '.ai_image_optimization_image', function() {
            const attachmentId = wpmfFoldersModule.editFileId;

            if (!attachmentId) return;

            $.ajax({
                url: wpmf.vars.ajaxurl,
                method: 'POST',
                data: {
                    action: 'wpmf_analyze_image_ai',
                    attachment_id: attachmentId
                },
                success: function (response) {
                    if (response.success) {
                        const result = response.data;
                        if (result.skipped) {
                            wpmfSnackbarModule.show({
                                id: 'wpmf_ai_skip_notice',
                                content: result.message
                            });
                        } else {
                            var attachment = $(`.attachment[data-id="${attachmentId}"]`);

                            if (attachment.hasClass('wpmf-ai-done')) {
                                return;
                            }

                            attachment.addClass('wpmf-ai-processing');
                            if (!attachment.find('.wpmf-ai-status-icon').length) {
                                attachment.find('.attachment-preview').append(`
                                    <div class="wpmf-ai-status-icon wpmf-processing-icon"></div>
                                `);
                            }

                            const pollingInterval = setInterval(function () {
                                const mediaAttachment = wp.media.attachment(attachmentId);
                                mediaAttachment.fetch().then(function () {
                                    const wpmf_ai_optimized = mediaAttachment.get('wpmf_ai_optimized');
                                    const src_img = mediaAttachment.get('url');

                                    if (typeof src_img !== 'undefined' && typeof wpmf_ai_optimized !== 'undefined') {
                                        if (!attachment.find('.wpmf_ai_text').length) {
                                            attachment.find('.attachment-preview').append('<span class="wpmf_ai_text ju-icon-AI"></span>');
                                        }

                                        attachment.removeClass('wpmf-ai-processing').addClass('wpmf-ai-done');
                                        attachment.find('.wpmf-ai-status-icon').remove();

                                        const doneIcon = $('<div class="wpmf-ai-status-icon wpmf-done-icon"></div>');
                                        attachment.find('.attachment-preview').append(doneIcon);
                                        doneIcon.fadeOut(1000, function () {
                                            $(this).remove();
                                            attachment.removeClass('wpmf-ai-done');
                                        });

                                        clearInterval(pollingInterval);
                                    }
                                });
                            }, 1000);
                        }
                    } else {
                        showWpmfToast((response.data?.message || 'Unknown error'), 'error');
                    }
                },
                error: function () {
                    alert('AJAX request failed.');
                }
            });
        })
    });
}(jQuery));
