(function ( $ ) {
    const cloudTabs = ['#google_drive_box', '#google_photo', '#dropbox_box', '#one_drive_box', '#onedrive_business_box', '#nextcloud', '#owncloud'];

    $(document).ready(function ( $ ) {
        $('.sidebar-menu-item.has-submenu > a').on('click', function(e) {
            e.preventDefault();

            const item = $(this).closest('.sidebar-menu-item');

            if (item.hasClass('expanded')) {
                item.removeClass('expanded');
            } else {
                $('.sidebar-menu-item.has-submenu').removeClass('expanded');
                item.addClass('expanded');

                const firstSubLink = item.find('.sidebar-sub-item:first-child a');
                if (firstSubLink.length) {
                    const href = firstSubLink.attr('href');
                    if (href && href.startsWith('#')) {
                        firstSubLink.trigger('click');
                        location.hash = href;
                    }
                }
            }
        });

        // Click on main item WITHOUT submenu
        $('.sidebar-menu-item:not(.has-submenu) > a').on('click', function(e) {
            $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active');
            $(this).closest('.sidebar-menu-item').addClass('active');

            showContentByHash($(this).attr('href'));
        });

        // Click on sub item
        $('.sidebar-sub-item > a').on('click', function(e) {
            $('.sidebar-sub-item, .sidebar-menu-item').removeClass('active');
            const subItem = $(this).closest('.sidebar-sub-item');
            const parentItem = $(this).closest('.sidebar-menu-item');

            subItem.addClass('active');
            parentItem.addClass('active');

            showContentByHash($(this).attr('href'));
        });

        localStorage.removeItem('sidebar_manual_state');

        activateMenuByHash();
        initSidebarSearch();
        initSidebarToggle();
        initCollapsedSidebarHover();
        initCloudConnectorTabs();
        handleResponsiveSidebar();

        $(window).on('resize', function () {
            handleResponsiveSidebar();
        });
    })

    function showContentByHash(hash) {
        if (!hash) return;

        $('.wpmf-settings-content .ju-content-wrapper, .wpmf-settings-content .tab-content, .sub-tab-content').hide();

        const target = $('.wpmf-settings-content').find(hash);
        if (target.length) {
            const isCloudTab = cloudTabs.includes(hash);
            if (isCloudTab) {
                const tabId = hash.replace('#', '');

                $('#cloud, #cloud_connector, #cloud_connector .wpmf-divider').show();
                $('#cloud_connector').addClass('active');
                $('#cloud .sub-tab-content').hide();
                target.show();

                const providerCard = $(`.wpmf-cloud-providers .provider-card[data-tab="${tabId}"]`);
                if (providerCard.length) {
                    $('.wpmf-cloud-providers .provider-card').removeClass('active');
                    providerCard.addClass('active');
                }

                const cloudSidebarItem = $(`.sidebar-sub-item a[href="#cloud_connector"]`);
                if (cloudSidebarItem.length) {
                    $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');
                    const parentItem = cloudSidebarItem.closest('.sidebar-menu-item.has-submenu');
                    if (parentItem.length) {
                        parentItem.addClass('active expanded');
                    }
                    cloudSidebarItem.closest('.sidebar-sub-item').addClass('active');
                }
            } else {
                target.show();

                const parentTabWrapper = target.closest('.ju-content-wrapper, .tab-content');
                if (parentTabWrapper.length && parentTabWrapper.attr('id') !== target.attr('id')) {
                    parentTabWrapper.show();
                }

                const subLink = $(`.sidebar-sub-item a[href="${hash}"]`);
                if (subLink.length) {
                    const parentLi = subLink.closest('.sidebar-menu-item.has-submenu');
                    if (parentLi.length) {
                        const parentId = parentLi.data('parent-id');
                        if (parentId) {
                            const parentContent = $('.wpmf-settings-content').find('#' + parentId);
                            if (parentContent.length) {
                                parentContent.show();
                            }
                        }
                    }
                }
            }
        }
    }

    function activateMenuByHash() {
        var hash = window.location.hash || localStorage.getItem('sidebar_last_hash');
        
        if (hash) {
            var subLink = $(`.sidebar-sub-item a[href="${hash}"]`);
            if (subLink.length) {
                var subItem = subLink.closest('.sidebar-sub-item');
                var parentItem = subLink.closest('.sidebar-menu-item');

                $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');

                subItem.addClass('active');
                parentItem.addClass('active expanded');

                showContentByHash(hash);
                return;
            }

            var mainLink = $(`.sidebar-menu-item:not(.has-submenu) > a[href="${hash}"]`);
            if (mainLink.length) {
                $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');
                mainLink.closest('.sidebar-menu-item').addClass('active');

                showContentByHash(hash);
                return;
            }

            var targetContent = $(hash);
            if (targetContent.length) {
                showContentByHash(hash);
                return;
            }
        }

        var firstMenuItem = $('.sidebar-menu-item:visible').first();
        if (firstMenuItem.length) {
            $('.sidebar-menu-item, .sidebar-sub-item').removeClass('active expanded');

            var firstSubLink = firstMenuItem.find('.sidebar-sub-item:first-child a');
            if (firstSubLink.length) {
                firstMenuItem.addClass('expanded active');
                firstSubLink.closest('.sidebar-sub-item').addClass('active');

                var href = firstSubLink.attr('href');
                if (href) {
                    showContentByHash(href);
                    location.hash = href;
                }
            } else {
                var firstLink = firstMenuItem.find('> a');
                if (firstLink.length) {
                    firstMenuItem.addClass('active');

                    var href = firstLink.attr('href');
                    if (href) {
                        showContentByHash(href);
                        location.hash = href;
                    }
                }
            }
        }
    }

    function initSidebarSearch() {
        var wrapper = $('.wpmf-settings-wrapper');
        var sidebar = $('.wpmf-settings-sidebar');
        var searchContainer = $('.wpmf-settings-search');
        var searchIcon = searchContainer.find('.wpmf-search-icon');

        searchIcon.on('click', function (e) {
            e.stopPropagation();
            if (wrapper.hasClass('wpmf-sidebar-collapsed')) {
                searchContainer.toggleClass('search-active');
                if (searchContainer.hasClass('search-active')) {
                    var top = searchContainer.offset().top - 10;
                    var sidebarOffset = sidebar.offset();

                    $('.wpmf-search-input-wrapper').css({
                        // top: top + 'px',
                        left: sidebarOffset.left + searchContainer.outerWidth() + 5 + 'px'
                    })
                }
            }
        });

        $(document).on('click', function (e) {
            if (!searchContainer.is(e.target) && searchContainer.has(e.target).length === 0) {
                searchContainer.removeClass('search-active');
            }
        });

        $('.wpmf-settings-search input').on('input', function () {
            const keyword = $(this).val().toLowerCase().trim();
            $('.sidebar-menu-item').each(function () {
                const menuItem = $(this);
                const titleText = menuItem.find('> a > div > span:last-child').text().toLowerCase();

                if (menuItem.hasClass('has-submenu')) {
                    let hasVisibleSub = false;
                    menuItem.find('.sidebar-sub-item').each(function () {
                        const subItem = $(this);
                        const subText = subItem.text().toLowerCase();
                        if (subText.includes(keyword)) {
                            subItem.show();
                            hasVisibleSub = true;
                        } else {
                            subItem.hide();
                        }
                    });
                    if (titleText.includes(keyword) || hasVisibleSub) {
                        menuItem.show();
                    } else {
                        menuItem.hide();
                    }
                } else {
                    if (titleText.includes(keyword)) {
                        menuItem.show();
                    } else {
                        menuItem.hide();
                    }
                }
            });
        });
    }

    function initSidebarToggle() {
        const wrapper = $('.wpmf-settings-wrapper');
        const collapseBtn = $('.wpmf-sidebar-collapse-btn');
        const expandBtn = $('.wpmf-sidebar-expand-btn');

        collapseBtn.on('click', function () {
            wrapper.addClass('wpmf-sidebar-collapsed');
            localStorage.setItem('sidebar_manual_state', 'collapsed');
        });

        expandBtn.on('click', function () {
            wrapper.removeClass('wpmf-sidebar-collapsed');
            resetSidebarSubmenus();
            localStorage.setItem('sidebar_manual_state', 'expanded');
        });
    }

    function handleResponsiveSidebar() {
        const wrapper = $('.wpmf-settings-wrapper');
        const sidebarState = localStorage.getItem('sidebar_manual_state');

        if (!sidebarState) {
            if ($(window).width() <= 960) {
                wrapper.addClass('wpmf-sidebar-collapsed');
            } else {
                wrapper.removeClass('wpmf-sidebar-collapsed');
            }
        }
    }

    function initCollapsedSidebarHover() {
        $('.wpmf-settings-sidebar-menu-items .sidebar-menu-item.has-submenu').hover(function () {
            var wrapper = $('.wpmf-settings-wrapper');
            if (!wrapper.hasClass('wpmf-sidebar-collapsed')) return;

            var item = $(this);
            var itemWidth = item.outerWidth();
            var itemHeight = item.outerHeight();
            var itemOffset = item.offset();
            var itemRect = item[0].getBoundingClientRect();
            var submenu = item.find('.sidebar-sub-wrapper');
            var submenuContent = item.find('.sidebar-sub-menu');

            submenu.css({ display: 'block', visibility: 'hidden' });
            submenuContent.css({ display: 'flex', visibility: 'hidden' });

            var submenuHeight = submenu.outerHeight();
            var windowHeight = window.innerHeight;

            submenu.css({ display: 'none', visibility: '', top: '', bottom: '' });
            submenuContent.css({ display: 'none', visibility: '' });

            var cssProps = {
                display: 'block',
                left: itemOffset.left + itemWidth + 'px'
            };

            if (itemRect.bottom + submenuHeight > windowHeight) {
                var distanceFromBottom = windowHeight - itemRect.bottom;
                cssProps.bottom = distanceFromBottom + 'px';
            } else {
                cssProps.top = item.position().top + itemHeight - 12 + 'px';
            }

            submenu.css(cssProps);
            submenuContent.css('display', 'flex');
        }, function () {
            var wrapper = $('.wpmf-settings-wrapper');
            if (!wrapper.hasClass('wpmf-sidebar-collapsed')) return;

            var submenu = $(this).find('.sidebar-sub-wrapper');
            var submenuContent = $(this).find('.sidebar-sub-menu');

            submenu.hide().css({ top: '', bottom: '' });
            submenuContent.hide();
        });
    }

    function resetSidebarSubmenus() {
        $('.sidebar-sub-wrapper').hide().css({ top: '', bottom: '', left: '', display: ''});
        $('.sidebar-sub-menu').hide().css({ visibility: '', display: '' });
    }

    function initCloudConnectorTabs() {
        $('.wpmf-cloud-providers .provider-card').on('click', function () {
            var target = $(this).data('tab');
            var hashTarget = `#${target}`;

            if (location.hash !== hashTarget) {
                history.replaceState(null, '', window.location.pathname + window.location.search + hashTarget);
            }

            $('.wpmf-cloud-providers .provider-card').removeClass('active');
            $(this).addClass('active');

            $('#cloud .sub-tab-content').hide();
            $('#' + target).show();
            $('#cloud_connector .wpmf-divider').show();
        });
    }
})(jQuery);