<?php

namespace WPPayFormPro\Classes\Components;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Form;


if (!defined('ABSPATH')) {
    exit;
}

class DynamicPaymentItemComponent extends BaseComponent
{
    public function __construct()
    {
        parent::__construct('dynamic_payment_item', 6);
    }

    public function component()
    {
        return array(
            'type' => 'dynamic_payment_item',
            'editor_title' => 'Dynamic Payment Item',
            'group' => 'payment',
            'postion_group' => 'payment',
            'is_pro' => 'yes',
            'is_system_field' => true,
            'is_payment_field' => true,
            'isNumberic' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'placeholder' => array(
                    'label' => 'Placeholder',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'required' => array(
                    'label' => 'Required',
                    'type' => 'switch',
                    'group' => 'general'
                ),
                'numeric_calculation' => array(
                    'label' => 'Enable Calculation',
                    'type' => 'numeric_calculation',
                    'group' => 'general',
                ),
                'numeric_serverside_validation' => array(
                    'label' => 'Enable Additional Checks',
                    'type' => 'numeric_serverside_validation',
                    'group' => 'general',
                    'info' => 'Extra layer of input checks'
                ),
                'admin_label' => array(
                    'label' => 'Admin Label',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'wrapper_class' => array(
                    'label' => 'Field Wrapper CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'element_class' => array(
                    'label' => 'Input Element CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'conditional_render' => array(
                    'type' => 'conditional_render',
                    'group' => 'advanced',
                    'label' => 'Conditional render',
                    'selection_type' => 'Conditional logic',
                    'conditional_logic' => array(
                        'yes' => 'Yes',
                        'no' => 'No'
                    ),
                    'conditional_type' => array(
                        'any' => 'Any',
                        'all' => 'All'
                    ),
                ),
            ),
            'field_options' => array(
                'disable' => false,
                'label' => 'Dynamic Payment Item',
                'placeholder' => '',
                'required' => 'no',
                'numeric_calculation' => 'yes',
                'calculation_expression' => '',
                'numeric_serverside_validation' => 'yes',
                'conditional_logic_option' => array(
                    'conditional_logic' => 'no',
                    'conditional_type' => 'any',
                    'options' => array(
                        array(
                            'target_field' => '',
                            'condition' => '',
                            'value' => ''
                        )
                    ),
                ),
            )
        );
    }

    public function render($element, $form, $elements)
    {
        $inputType = Arr::get($element, 'type', false);
        $fieldOptions = Arr::get($element, 'field_options', false);
        $disable = Arr::get($fieldOptions, 'disable', false);
        if (!$fieldOptions || $disable) {
            return;
        }
        $isNumericCalculation = Arr::get($fieldOptions, 'numeric_calculation', 'no') === 'yes';
        $hasCalculationExpression = Arr::get($fieldOptions, 'calculation_expression', '');
        $controlClass = $this->elementControlClass($element);
        $inputId = 'wpf_payment_' . $form->ID . '_' . $element['id'];
        $title = Arr::get($fieldOptions, 'label', 'Dynamic Payment Item');
        $controlAttributes = array(
            'data-element_type' => $this->elementName,
            'required_id' => $element['id'],
            'class' => $controlClass
        );
        $labelAttributes = [
            'name' => $element['id'],
            'data-is_dynamic_payment_item' => 'yes',
            'id' => $inputId,
        ];
        
        if ($isNumericCalculation) {
            $labelAttributes['data-numeric_calculation'] = $hasCalculationExpression;
        }
        $attributes = [
            'name' => $element['id'],
            'id' => $inputId,
            'class' => 'wpf_input_dynamic_payment_item',
            'type' => 'hidden',
            'customname' => $title,
            'data-price' => 0,
            'value' => 0
        ];

        $title = Arr::get($element, 'field_options.label');
        $currenySettings = Form::getCurrencyAndLocale($form->ID);
        ?>
        <div <?php $this->printAttributes($controlAttributes); ?>>
            <div class="wpf_input_label wpf_dynamic_payment_item" <?php $this->printAttributes($labelAttributes); ?>>
                <?php echo esc_html($title); ?>: <span name=<?php echo esc_attr($element['id']); ?>
                    class="wpf_calc_dynamic_payment_item"><?php echo esc_html(wpPayFormFormattedMoney(wpPayFormConverToCents(0), $currenySettings)); ?></span>
                <input <?php $this->printAttributes($attributes) ?> />
            </div>
        </div>
        <?php
    }
}
?>