<?php

namespace WPPayFormPro\Classes\Components;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Form;

if (!defined('ABSPATH')) {
    exit;
}

class TabularProductsComponent extends BaseComponent
{
    public function __construct()
    {
        parent::__construct('tabular_products', 2);
        add_filter('wppayform/submitted_payment_items', array($this, 'pushTabularItems'), 10, 4);
        add_filter('wppayform/validate_component_on_save_tabular_products', array($this, 'validateOnSave'), 1, 3);
    }

    public function component()
    {
        return array(
            'type' => 'tabular_products',
            'editor_title' => 'Tabular Product Items',
            'group' => 'payment',
            'isNumberic' => 'yes',
            'postion_group' => 'payment',
            'is_pro' => 'yes',
            // 'conditional_hide' => true,
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'products' => array(
                    'label' => 'Setup Your Tabular products',
                    'group' => 'general',
                    'type' => 'tabular_products',
                ),
                'show_sub_total' => array(
                    'label' => 'Show Subtotal',
                    'type' => 'switch',
                    'group' => 'general',
                    'info' => 'If enabled then user can see subtotal after the table'
                ),
                'table_photo_label' => array(
                    'label' => 'Photo Column Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'table_item_label' => array(
                    'label' => 'Table Item Column Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'table_price_label' => array(
                    'label' => 'Table Price Column Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'table_quantity_label' => array(
                    'label' => 'Table Quantity Column Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'table_subtotal_label' => array(
                    'label' => __('Table Sub Total Label', 'wp-payment-form-pro'),
                    'type' => 'text',
                    'group' => 'general'
                ),
                'admin_label' => array(
                    'label' => 'Admin Label',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'wrapper_class' => array(
                    'label' => 'Field Wrapper CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'element_class' => array(
                    'label' => 'Input Element CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'conditional_render' => array(
                    'type' => 'conditional_render',
                    'group' => 'advanced',
                    'label' => 'Conditional render',
                    'selection_type' => 'Conditional logic',
                    'conditional_logic' => array(
                        'yes' => 'Yes',
                        'no' => 'No'
                    ),
                    'conditional_type' => array(
                        'any' => 'Any',
                        'all' => 'All'
                    ),
                ),
            ),
            'is_system_field' => true,
            'is_payment_field' => true,
            'field_options' => array(
                'label' => 'Add Quantity Of The Products',
                'show_sub_total' => 'yes',
                'table_item_label' => __('Product', 'wp-payment-form-pro'),
                'table_description_label' => __('Description', 'wp-payment-form-pro'),
                'table_price_label' => __('Item Price','wp-payment-form-pro'),
                'table_quantity_label' => __('Quantity', 'wp-payment-form-pro'),
                'table_subtotal_label' => __('Sub Total', 'wp-payment-form-pro'),
                'table_photo_label' => __('Photo', 'wp-payment-form-pro'),
                'layout' => 'table',
                'enable_quantity' => 'yes',
                'enable_product_size' => 'yes',
                'enable_search' => 'yes',
                'enable_feature' => 'yes',
                'categories' => [
                    array (
                        'label' => __('Product Category', 'wp-payment-form-pro'),
                        'value' => 'product_category'
                    ),
                ],
                'products' => array(
                    [
                        'product_name' => 'Product 1',
                        'default_quantity' => 1,
                        'min_quantity' => 0,
                        'max_quantity' => 100,
                        'product_price' => '10',
                        'product_description' => __('Product Description', 'wp-payment-form-pro'),
                        'category' => array(),
                        'enable_product' => 'no',
                        'photo' => [
                            array(
                                'alt_text' => 'default product image',
                                'image_full' => '/images/form/default_product.png',
                                'image_thumb' => '/images/form/default_product.png',
                            )
                        ],
                        'product_size' =>  array(
                            [
                               array(
                                    'label' => 'Size',
                                    'options' =>  [
                                        array (
                                            'label' => 'S',
                                            'value' => 's',
                                            'price' => ''
                                        ),
                                    ]
                               )
                            ]
                        ),
                    ],
                    [
                        'product_name' => 'Product 2',
                        'default_quantity' => 0,
                        'min_quantity' => 0,
                        'max_quantity' => 100,
                        'product_price' => '20',
                        'product_description' => __('Product Description', 'wp-payment-form-pro'),
                        'categories' => array('all'),
                        'enable_product' => 'no',
                        'photo' => [
                            array(
                                'alt_text' => 'default product image',
                                'image_full' => '/images/form/default_product.png',
                                'image_thumb' => '/images/form/default_product.png',
                            )
                        ],
                        'product_size' =>  [
                            [
                               array(
                                    'label' => 'Size',
                                    'options' =>  [
                                        array (
                                            'label' => 'S',
                                            'value' => 's',
                                            'price' => ''
                                        ),
                                    ]
                                ),
                            ],
                            [
                                array(
                                    'label' => 'Test',
                                    'options' =>  [
                                        array (
                                            'label' => 'test',
                                            'value' => 'test opt',
                                            'price' => ''
                                        ),
                                    ]
                               )
                            ]
                        ],
                    ]
                )
            )
        );
    }

    public function validateOnSave($error, $element, $formId)
    {
        return $error;
    }

    public function render($element, $form, $elements)
    {
        $currenySettings = Form::getCurrencyAndLocale($form->ID);
        $controlClass = $this->elementControlClass($element);
        $hidden_attr = Arr::get($element, 'field_options.conditional_logic_option.conditional_logic')  === 'yes' ? 'none' : 'block';

        $fieldOptions = Arr::get($element, 'field_options');
        $disable = Arr::get($fieldOptions, 'disable');

        $tableLabel = Arr::get($fieldOptions, 'label');
        $controlAttributes = array(
            'data-element_type' => $this->elementName,
            'class' => $controlClass
        );
        $products = Arr::get($fieldOptions, 'products');
        $itemId = Arr::get($element, 'id');
        $showSubtotalSelector = '';
        $showSubtotal = Arr::get($fieldOptions, 'show_sub_total') == 'yes';
        if ($disable) {
            return;
        }
        if ($showSubtotal) {
            $showSubtotalSelector = ' wpf_show_tabular_subtotal';
        }
        $tableAttributes = array(
            'class' => 'wpf_tabular_items wpf_tabular_' . $itemId . ' wpf_regular_table' . $showSubtotalSelector,
            'data-produt_id' => $itemId,
            'data-item_total' => 0,
            'data-qty_required' => Arr::get($fieldOptions, 'required'),
            'customname' => $element['field_options']['label'],
            'condition_id' => $itemId
        );

        $enabledImage = Arr::get($fieldOptions, 'enable_image') == 'yes';
        $lightbox = Arr::get($fieldOptions, 'enable_lightbox') == 'yes';

        if ($lightbox) {
            wp_enqueue_script('lity', WPPAYFORM_URL . 'assets/libs/lity/lity.min.js', array('jquery'), WPPAYFORM_VERSION, true);
            wp_enqueue_style('lity', WPPAYFORM_URL . 'assets/libs/lity/lity.min.css', array(), WPPAYFORM_VERSION);
        }
        $colspan = 2;
        if ($enabledImage) {
            $colspan = 3;
        }
?>
        <div id="wpf_tabular_items" tabular_item_id="<?php echo $itemId; ?>" style="display : <?php echo $hidden_attr; ?>" <?php echo $this->builtAttributes($controlAttributes); ?>>
            <?php if ($tableLabel) : ?>
                <h4 class="wpf_tabular_parent_label wpf_tabular_label_<?php echo $itemId; ?>"><?php echo $tableLabel; ?></h4>
            <?php endif; ?>
            <input name="<?php echo $itemId ?>" type="hidden" value="0" />
            <?php
                if (Arr::get($fieldOptions, 'layout', 'table') == 'table') {
                    ?>
                    <table <?php echo $this->builtAttributes($tableAttributes); ?>>
                        <thead>
                            <tr>
                                <?php if ($enabledImage) : ?>
                                    <th class="wpf_tabular_product_photo">
                                        <?php echo Arr::get($fieldOptions, 'table_photo_label'); ?>
                                    </th>
                                <?php endif; ?>
                                <th class="wpf_tabular_product_title"><?php echo Arr::get($fieldOptions, 'table_item_label'); ?></th>
                                <th class="wpf_tabular_price"><?php echo Arr::get($fieldOptions, 'table_price_label'); ?></th>
                                <th class="wpf_tabular_qty"><?php echo Arr::get($fieldOptions, 'table_quantity_label'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($products as $productIndex => $product) : ?>
                                <tr>
                                    <?php if ($enabledImage) : ?>
                                        <td class="wpf_tabular_product_photo">
                                            <?php echo $this->renderImage($product, $lightbox); ?>
                                        </td>
                                    <?php endif; ?>
                                    <td>
                                        <?php echo $product['product_name']; ?>
                                        <input type="hidden" name="<?php echo $itemId; ?>[<?php echo $productIndex; ?>]" value="<?php echo $product['product_name']; ?>" />
                                    </td>
                                    <td class="wpf_tabular_price">
                                        
                                        <?php $currentProductId = $itemId . '_price_' . $productIndex; ?>
                                        <?php echo wpPayFormFormattedMoney(wpPayFormConverToCents($product['product_price']), $currenySettings); ?>

                                        <?php
                                        $priceAttributes = array(
                                            'data-tabular_product' => $itemId,
                                            'class' => 'wpf_tabular_price',
                                            'name' => $currentProductId,
                                            'type' => 'hidden',
                                            'data-price' => wpPayFormConverToCents($product['product_price']),
                                            'value' => $product['product_price']
                                        );
                                        ?>
                                        <input <?php echo $this->builtAttributes($priceAttributes); ?> />
                                    </td>
                                    <td class="wpf_tabular_qty">
                                        <?php
                                        $qytAttributes = [
                                            'name' => $itemId . '_qty_' . $productIndex,
                                            'value' => $product['default_quantity'],
                                            'type' => 'number',
                                            'min' => $product['min_quantity'],
                                            'class' => 'wpf_form_control wpf_tabular_qty',
                                            'data-target_product' => $currentProductId,
                                            'id' => $itemId . '_qty_' . $productIndex
                                        ];

                                        if (isset($product['max_quantity'])) {
                                            $qytAttributes['max'] = $product['max_quantity'];
                                        }

                                        ?>
                                        <input <?php echo $this->builtAttributes($qytAttributes); ?> />
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <?php if ($showSubtotal) : ?>
                            <tfoot>
                                <tr class="tablular_table_subtotal">
                                    <td class="wpf_subtotal_th" colspan="<?php echo $colspan; ?>" style="font-weight: 600">
                                        <?php echo Arr::get($fieldOptions, 'table_subtotal_label'); ?>
                                    </td>
                                    <td>
                                        <span name="<?php echo $itemId; ?>" style="font-weight: 600" class="wpf_tabular_subtotal wpf_calc_tabular_<?php echo $itemId; ?>" data-target_item="<?php echo $itemId; ?>"></span>
                                    </td>
                                </tr>
                            </tfoot>
                        <?php endif; ?>
                    </table>
                    <?php
                } else if (Arr::get($fieldOptions, 'layout') == 'grid' || Arr::get($fieldOptions, 'layout') == 'row') {
                    wp_enqueue_script('wppayform_tabular_product_script', WPPAYFORM_URL . 'assets/js/tabular_template.js', array('jquery'), '2.3.1', true);
                    echo $this->renderGridAndRowProductCard($element, $itemId, $showSubtotal, $tableAttributes, $currenySettings);
                }
            ?>
        </div>
<?php

    }

    public function renderGridAndRowProductCard($element, $itemId, $showSubtotal, $tableAttributes, $currenySettings)
    {
        $fieldOptions = Arr::get($element, 'field_options');
        $isEnableCustomOption = Arr::get($fieldOptions, 'enable_product_size', 'no') == 'yes' ? true : false;
        $defaultImage =WPPAYFORMPRO_DIR_URL . 'assets/images/default_product.png';
        $notFoundImage =WPPAYFORMPRO_DIR_URL . 'assets/images/not_found.jpg';
        $products = Arr::get($fieldOptions, 'products', []);
        $categories = Arr::get($fieldOptions, 'categories', []);
        $isEnableFilter = Arr::get($fieldOptions, 'enable_search', 'no');
        $isEnableFilter = $isEnableFilter == 'yes' ? '' : 'none';
        $search_input_class = 'wpf_tab_search_input_' . $itemId;
        $category_class = 'wpf_filter_input_' . $itemId;
        $sort_class = 'wpf_sort_input_' . $itemId;
        $product_title = 'wpf_tab_product_title_' . $itemId;
        $className = Arr::get($fieldOptions, 'layout') == 'grid' ? 'wpf-product-cards-wrap wpf_container_'.$itemId.' d-grid grid-template-col-3'
            : 'wpf-product-cards-wrap wpf_container_' .$itemId. ' d-grid';
        $singleProductWrapperClass = Arr::get($fieldOptions, 'layout') == 'grid' ? 'wpf-product-card '.$product_title.' is-slider is-show-popup'
            : 'wpf-product-card '.$product_title.' is-slider is-show-popup wpf-tabular-product-is-flex';
        $productBodyClass = Arr::get($fieldOptions, 'layout') == 'grid' ? 'wpf-product-body'
            : 'wpf-product-body wpf-flex-body';
        $productImageClass = Arr::get($fieldOptions, 'layout') == 'grid' ? 'wpf-product-image ' : 'wpf-product-image wpf-image_row_wrapper';
        $enableFeature = Arr::get($fieldOptions, 'enable_feature', 'no') == 'yes' ? '' : 'none';
        $empty_message_wrapper = 'wpf_empty_message_wrapper_' . $itemId;
        ?>
            <div <?php echo $this->builtAttributes($tableAttributes); ?>>
                <div class="wpf_tabular_filter_container wpf_tabular_preview_container" style="display : <?php echo $isEnableFilter ?>" >
                    <div class="wpf_filter_input">
                        <div class="wpf-search-icon">
                            <!-- <svg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 20 20'><path fill='%23838D99' d='M13.22 14.63a8 8 0 1 1 1.41-1.41l4.29 4.29a1 1 0 1 1-1.41 1.41l-4.29-4.29zm-.66-2.07a6 6 0 1 0-8.49-8.49 6 6 0 0 0 8.49 8.49z'></path></svg> -->
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.6667 11.6665L14.6667 14.6665" stroke="#565865" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M13.3335 7.33325C13.3335 4.01954 10.6472 1.33325 7.3335 1.33325C4.01979 1.33325 1.3335 4.01954 1.3335 7.33325C1.3335 10.647 4.01979 13.3333 7.3335 13.3333C10.6472 13.3333 13.3335 10.647 13.3335 7.33325Z" stroke="#565865" stroke-width="1.5" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <input class="input-elevated <?php echo $search_input_class ?>" type="text" placeholder="<?php echo __('Search', 'wp-payment-form-pro'); ?>">
                    </div>
                    <div class="wpf_categories">
                        <div style="display: <?php echo $enableFeature; ?>">
                            <select class="wpf_filter_select <?php echo $category_class ?>" label="<?php echo __('Select data', 'wp-payment-form-pro'); ?>">
                            <option disabled selected><?php echo __('Filter by Categories', 'wp-payment-form-pro'); ?></option>
                            <option value="all"><?php echo __('All', 'wp-payment-form-pro') ; ?></option>
                            <?php foreach ($categories as $categoryIndex => $category) : ?>
                                <option value="<?php echo $category['value'] ?>"><?php echo $category['label'] ?></option>
                            <?php endforeach; ?>
                            </select>
                        </div>
                        <div>
                            <select class="wpf_sort_select <?php echo $sort_class ?>">
                                <option selected disabled><?php echo __('Sort By', 'wp-payment-form-pro'); ?></option>
                                <option value="name_asce"><?php echo __('Name A to Z', 'wp-payment-form-pro'); ?></option>
                                <option value="name_desce"><?php echo __('Name Z to A', 'wp-payment-form-pro'); ?></option>
                                <option value="price_asce"><?php echo __('Price Low To High', 'wp-payment-form-pro'); ?></option>
                                <option value="price_desce"><?php echo __('Price High To Low', 'wp-payment-form-pro'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <!-- start new template -->
                <div style="padding: 16px;">
                <div class="<?php echo $className; ?>">
                    <?php foreach ($products as $productIndex => $product) :
                    $thumbImage = '';
                    $product = $this->checkAndAddMetaPrice($product);
                    $enableProduct = Arr::get($product, 'enable_product', 'yes');
                    if ($enableProduct == 'yes') {
                        continue;
                    }
                    if (Arr::get($product, 'photo.image_full', false)) {
                        $thumbImage = Arr::get($product, 'photo.image_full');
                    } else {
                        $thumbImage = Arr::get($product, 'photo.0.image_full');
                        if (!$thumbImage) {
                            $thumbImage = $defaultImage;
                            $product['photo'] = array(
                                [
                                    "alt_text" => "",
                                    "image_full" => $defaultImage,
                                    "image_thumb" => $defaultImage,
                                ]
                            );
                        }
                    }
                    $product_id = 'wpf_slide_'. $itemId;
                    $product_id .= $productIndex;
                    $productName = Arr::get($product, 'product_name');
                    $product_price = Arr::get($product, 'product_price');
                    $description = Arr::get($product, 'product_description');
                    $currentProductId = $itemId . '_price_' . $productIndex;
                    $productCategory = Arr::get($product, 'category', '');
                    $assetUrl = WPPAYFORM_URL . 'assets';
                    ?>
                    <div data-wpf_tabular_name="<?php echo strtolower($productName) ?>" data-wpf_tabular_category="<?php echo $productCategory ?>" class="<?php echo $singleProductWrapperClass ?>">
                        <input class="wpf-product-checkbox_input" type="checkbox">
                        <span class="wpf-product-checkbox"></span>
                        <div class="<?php echo $productImageClass  ?>" id="<?php echo $product_id ?>">
                        <?php  
                            // If the image URL is relative (doesn't start with 'http')  
                            if (strpos($thumbImage, 'http') !== 0) {
                                $thumbImage = $assetUrl . $thumbImage;
                            }
                        ?>
                            <img style="width: 100%" src="<?php echo $thumbImage ?>" alt="">
                            <div class="wpf-product-image-overlay">
                                <span><?php echo __('View Image', 'wp-payment-form-pro'); ?></span>
                            </div>
                        </div>

                        <div class="<?php echo $productBodyClass ?>">
                            <h3 class="wpf-product-title"><?php echo $productName ?></h3>
                            <p class="wpf-product-content">
                                <?php echo $description ?>
                            </p>
                            <span data-value="<?php echo $product_price ?>" class="wpf-product-price">
                                <?php $currentProductId = $itemId . '_price_' . $productIndex; ?>
                                <?php echo wpPayFormFormattedMoney(wpPayFormConverToCents($product['product_price']), $currenySettings); ?>
                            </span>
                                <?php
                                $priceAttributes = array(
                                    'data-tabular_product' => $itemId,
                                    'class' => 'wpf_tabular_price',
                                    'name' => $currentProductId,
                                    'type' => 'checkbox',
                                    'wpf_product_name'=> $productName,
                                    'data-price' => wpPayFormConverToCents($product['product_price']),
                                    'value' => $product['product_price']
                                );
                                ?>
                                <input style="display: none;" <?php echo $this->builtAttributes($priceAttributes); ?> />
        

                            <div class="d-flex gap-8 wpf-product-footer" style="flex-wrap: wrap;">
                                <div class="wpf-product-quantity">
                                    <label for="quantity"><?php echo __('Quantity', 'wp-payment-form-pro'); ?></label>
                                    <?php
                                    $qytAttributes = [
                                        'name' => $itemId . '_qty_' . $productIndex,
                                        'value' => $product['default_quantity'] > $product['min_quantity'] ? $product['default_quantity'] : $product['min_quantity'],
                                        'def' => $product['default_quantity'],
                                        'type' => 'number',
                                        'mini' => $product['min_quantity'],
                                        'min' => 0,
                                        'class' => 'wpf_form_control wpf_tabular_qty wpf_product_qty',
                                        'data-target_product' => $currentProductId,
                                        'id' => $itemId . '_qty_' . $productIndex
                                    ];

                                    if (isset($product['max_quantity'])) {
                                        $qytAttributes['max'] = $product['max_quantity'];
                                    }
                                    ?>
                                    <input <?php echo $this->builtAttributes($qytAttributes); ?> />
                                </div>
                                <?php if (Arr::get($product, 'product_size', false) && $isEnableCustomOption) {
                                     foreach ($product['product_size'] as $optionIndex => $options) : ?>
                                     <?php $currentProductOptionId = $itemId .'_meta_'.$productIndex. '_' . str_replace(' ', '_', $options[0]['label']); ?>
                                    <div class="wpf-product-size" style="min-width: 70px">
                                        <label for="<?php echo $options[0]['label'] ?>"><?php echo $options[0]['label'] ?></label>
                                        <select class="wpf_tabular_multiple_option" id="<?php echo $currentProductOptionId ?>">
                                        <?php foreach ($options[0]['options'] as $optIndex => $opt) : ?>
                                            <option price="<?php echo $opt['price'] ?>" value="<?php echo $opt['value'] ?>"><?php echo $opt['label'] ?></option>
                                        <?php endforeach; ?>
                                        </select>
                                        <input type="hidden" name="<?php echo $currentProductOptionId ?>" class="<?php echo $currentProductOptionId; ?>" value="">
                                    </div>
                                <?php endforeach; }?>
                            </div>
                        </div>
                        <div class="wpf-product-dialog-box">
                            <div class="wpf-product-dialog-content">
                                <div class="close-dialog">+</div>

                                <div class="wpf-product-dialog">
                                    <div class="slideshow-container">
                                    <?php foreach ($product['photo'] as $imageIndex => $image) : ?>
                                        <?php 
                                            $image = Arr::get($image, 'image_full', $defaultImage);
                                            if (strpos($image, 'http') !== 0) {
                                                $image = $assetUrl . $image;
                                            }
                                        ?>
                                        <img class='<?php echo "$product_id fade" ?>' src="<?php echo $image ?>">
                                    <?php endforeach; ?>
                                        <a class="slideshow-trigger prev" style="position: absolute" data-action="-1" data-product_id="<?php echo $product_id ?>">❮</a>
                                        <a class="slideshow-trigger next" style="position: absolute" data-action="-1" data-product_id="<?php echo $product_id ?>">❯</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    </div>
                    </div>
                    <div class="wpf_product_not_found <?php echo $empty_message_wrapper ?>">
                        <img class="hide" src="<?php echo $notFoundImage; ?>" alt="">
                    </div>
                <?php if ($showSubtotal) : ?>
                        <div class="tablular_table_subtotal grid_tab_sub_total">
                            <div>
                                <th class="wpf_subtotal_th" colspan="3">
                                    <span><?php echo Arr::get($fieldOptions, 'table_subtotal_label'); ?></span>
                                </th>
                                <th>
                                    <span name="<?php echo $itemId; ?>" class="wpf_tabular_subtotal wpf_calc_tabular_<?php echo $itemId; ?>" data-target_item="<?php echo $itemId; ?>">0$</span>
                                </th>
                            </div>
                        </div>
                <?php endif; ?>
            </div>
        <?php
    
    }

    public function checkAndAddMetaPrice ($product) {
        $metaData = Arr::get($product, 'product_size', []);
        foreach ($metaData as $metaIndex => $meta) {
            foreach (Arr::get($meta, '0.options') as $key => $value) {
                if (!array_key_exists('price', $value)) {
                    $metaData[$metaIndex][0]['options'][$key]['price'] = 0;
                }
            }
        }
        $product['product_size'] = $metaData;
        return $product;
    }

    private function renderImage($product, $lightboxed = false)
    {
        $product = Arr::get($product, 'photo', ['image_thumb' => '']);
        if (Arr::get($product, 'image_thumb') === '') {
            return '';
        }
        if (Arr::get($product, 'image_full', false) !== false) {
            $product[0] = $product;
        }

        $image = $product[0];
        $thumb = Arr::get($image, 'image_thumb');
        $imageFull = Arr::get($image, 'image_full');
        $altText = Arr::get($image, 'alt_text');

        if ($imageFull === '/images/form/default_product.png') {
            $assetUrl = WPPAYFORM_URL . 'assets';
            $thumb =  $assetUrl. $imageFull;
        }

        if (!$thumb) {
            return '';
        }

        if ($lightboxed) {
            return '<a class="wpf_lightbox" href="' . $imageFull . '"><img src="' . $thumb . '" alt="' . $altText . '" /></a>';
        }
        return '<img src="' . $thumb . '" alt="' . $altText . '" />';
    }

    public function pushTabularItems($paymentItems, $formattedElements, $form_data)
    {
        $tabularItems = array_filter($formattedElements['payment'], function ($element) {
            return Arr::get($element, 'type') == 'tabular_products';
        });

        if (!$tabularItems) {
            return $paymentItems;
        }
    
        foreach ($tabularItems as $itemKey => $tabularItem) {
            $sourceProducts = Arr::get($tabularItem, 'options.products');
            $layout = Arr::get($tabularItem, 'options.layout');
            if (!$sourceProducts) {
                continue;
            }
            foreach ($sourceProducts as $index => $sourceProduct) {
                $inputQty = Arr::get($form_data, $itemKey . '_qty_' . $index, 0);
                $isChecked = Arr::get($form_data, $itemKey . '_price_' . $index, 0);

                if (!$inputQty || (($layout == 'grid' || $layout == 'row') && !$isChecked)) {
                    continue;
                }
                
                $tabularMata = [];
                foreach($form_data as $key => $value) {
                    $key = sanitize_text_field($key);
                    $value = sanitize_text_field($value);
                    $metaKey = $itemKey . '_meta_' . $index;
                    if (empty( $metaKey ) || strpos( $key, $metaKey ) !== false) {
                        array_push($tabularMata, array(
                            'key' => end(explode("_",$key)),
                            'value' => $value,
                        ));
                        foreach($sourceProduct['product_size'] as $metaPriceKey => $metaPrice) {
                            if(Arr::get($metaPrice, '0.label') == end(explode("_",$key))) {
                                foreach (Arr::get($metaPrice, '0.options') as $metaPriceKey => $metaPrice) {
                                    if (Arr::get($metaPrice, 'value') == $value) {
                                        $sourceProduct['product_price'] = intval(Arr::get($sourceProduct, 'product_price'))  + intval(Arr::get($metaPrice, 'price'));
                                    }
                                }
                            }
                        }
                    }
                }
                $sourceProductPrice = wpPayFormConverToCents($sourceProduct['product_price']);
                $paymentItemData = array(
                    'type' => 'single',
                    'parent_holder' => $itemKey,
                    'item_name' => $sourceProduct['product_name'],
                    'quantity' => $inputQty,
                    'item_price' => $sourceProductPrice,
                    'line_total' => $sourceProductPrice * $inputQty,
                    'created_at' => current_time('Y-m-d H:i:s'),
                    'updated_at' => current_time('Y-m-d H:i:s'),
                );
                if (sizeof($tabularMata)) {
                    $paymentItemData['item_meta'] = $tabularMata;
                }
                $paymentItems[] = $paymentItemData;
            }
        }

        return $paymentItems;
    }
}
