<?php

namespace WPPayFormPro\Classes\Coupons;

use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use WPPayForm\App\Models\Meta;
class CouponController
{
    public function test()
    {
        return 'testing';
    }

    public function validateCoupon()
    {
        $code = sanitize_text_field($_REQUEST['coupon']);

        parse_str($_REQUEST['form_data'], $formData);

        $formId = intval($_REQUEST['form_id']);
        $totalAmount = intval($_REQUEST['payment_total']);

        $couponModel = new CouponModel();
        $coupon = $couponModel->getCouponByCode($code);

        if (!$coupon || $coupon->status != 'active') {
            wp_send_json([
                'message' => __('The provided coupon is not valid', 'wp-payment-form-pro')
            ], 423);
        }

        $startDate = strtotime($coupon->start_date);
        $endDate = strtotime($coupon->expire_date);

        $dateTime = current_datetime();
        $localtime = $dateTime->getTimestamp() + $dateTime->getOffset();

        if ($coupon->min_amount && $totalAmount < intval($coupon->min_amount * 100)) {
            wp_send_json([
                'message' => __('The provided coupon is not applicable with this amount', 'wp-payment-form-pro')
            ], 423);
        }

        if ($startDate && $localtime <= $startDate) {
            wp_send_json([
                'message' => __('The provided coupon is not live yet', 'wp-payment-form-pro')
            ], 423);
        }

        if ($endDate && $localtime > $endDate) {
            wp_send_json([
                'message' => __('The provided coupon is outdated', 'wp-payment-form-pro')
            ], 423);
        }

        //check coupon usage limit
        $max_use = $coupon->max_use;
        $customer_email = Arr::get($formData, 'customer_email');

        if ($max_use > 0) {

            if(!$customer_email){
                wp_send_json([
                    'message' => __('The coupon has usage limit, please provide an email for validation.', 'wp-payment-form-pro')
                ], 423);
            }

            if($this->getCouponUsageCount($customer_email, $code) >= $max_use){
                wp_send_json([
                    'message' => __('You have crossed this coupon use limit.', 'wp-payment-form-pro')
                ], 423);
            }
        }


        if ($formIds = Arr::get($coupon->settings, 'allowed_form_ids')) {
            if (!in_array($formId, $formIds)) {
                wp_send_json([
                    'message' => __('The provided coupon is not valid', 'wp-payment-form-pro')
                ], 423);
            }
        }

        $formIds = Arr::get($coupon->settings, 'allowed_form_ids');

        if ($coupon->min_amount && $coupon->min_amount > $totalAmount) {
            wp_send_json([
                'message' => __('The provided coupon does not meet the requirements', 'wp-payment-form-pro')
            ], 423);
        }

        $otherCouponCodes = Arr::get($_REQUEST, 'other_coupons', '');
        if ($otherCouponCodes) {
            $otherCouponCodes = \json_decode(wp_unslash($otherCouponCodes), false);

            if ($otherCouponCodes) {
                $codes = $couponModel->getCouponsByCodes($otherCouponCodes);
                foreach ($codes as $couponItem) {
                    if (($couponItem->stackable != 'yes' || $coupon->stackable != 'yes') && $coupon->code != $couponItem->code) {
                        wp_send_json([
                            'message' => __('Sorry, You can not apply this coupon with other coupon code', 'wp-payment-form-pro')
                        ], 423);
                    }
                }
            }
        }

        wp_send_json([
            'coupon' => [
                'code' => $coupon->code,
                'title' => $coupon->title,
                'amount' => $coupon->amount,
                'coupon_type' => $coupon->coupon_type
            ]
        ], 200);
    }

    public function maybeAddCouponMeta($submission, $submissionId, $form_data)
    {

        $applied_coupons = json_decode(Arr::get($form_data, '__wpf_all_applied_coupons', ''));
        $customer_email = Arr::get($submission, 'customer_email');

        if (!$customer_email || !$applied_coupons) {
            return;
        }

        $couponModel = new CouponModel();

       foreach ($applied_coupons as $code) {

           $coupon = $couponModel->getCouponByCode($code);
           $metaKey = 'coupon_usage_count_' . $code;

           $couponUsers = Meta::where('meta_key', $metaKey)->first(); // as per coupon code

           if ($couponUsers) {
               $couponUsers = safeUnserialize($couponUsers['meta_value']);
               if (!isset($couponUsers[$customer_email])) {
                   $couponUsers[$customer_email] = 1;
               } else {
                   $couponUsers[$customer_email]++;
               }
               Meta::where('meta_key', $metaKey)
                   ->update([
                       'meta_key' => $metaKey,
                       'meta_group' => 'wpf_coupons',
                       'meta_value' => maybe_serialize($couponUsers),
                       'updated_at' => current_time('mysql'),
                   ]);
               // update query
           } else {
               $couponUsers = array();
               $couponUsers[$customer_email] = 1;
               Meta::create([
                   'meta_key' => $metaKey,
                   'option_id' => $coupon['id'],
                   'meta_group' => 'wpf_coupons',
                   'meta_value' => maybe_serialize($couponUsers),
                   'updated_at' => current_time('mysql'),
                   'created_at' => current_time('mysql'),
               ]);

           }
       }
    }

    public static function getCouponUsageCount($customer_email, $code): int
    {
        $metaKey =  'coupon_usage_count_' . $code;

        $couponUsers = Meta::select('meta_value')->where('meta_key', $metaKey)->get();
        $users = safeUnserialize($couponUsers[0]['meta_value']);
        if(!isset($users[$customer_email])){
            return 0;
        }

        return $users[$customer_email];
    }

    public function getTotalLine($coupons, $paymentTotal, $taxTotal = 0)
    {
        $totalDiscounts = 0;
        $discounts = array();

        if ($taxTotal) {
            $paymentTotal -= $taxTotal;
        }

        $totalAmount =  floatval($paymentTotal);
        foreach ($coupons as $coupon) {
            if ($coupon->coupon_type == 'percent') {
                $price = (floatval($coupon->amount) / 100) * $totalAmount;
                $totalAmount = $totalAmount - $price;
            } else {
                $price = floatval($coupon->amount) * 100;
                $totalAmount = $totalAmount - $price;
            }
            $totalDiscounts += $price;
            $item = [
                "type" => "discount",
                "parent_holder" => "payment_item",
                "item_name" => $coupon->title,
                "quantity" => 1,
                "created_at" => $coupon->created_at,
                "updated_at" => $coupon->updated_at,
                "item_price" => $price,
                "line_total" => $price,
            ];

            $discounts[] = $item;
        }

        return array(
            'discounts' => $discounts,
            'totalDiscounts' => $totalDiscounts
        );
    }
}
