<?php

namespace WPPayFormPro\Classes\EmailNotification;

use WPPayForm\App\Models\Submission;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Email Handler Class for Email Notification
 * @since 1.0.0
 */
class ResendEmail
{
    public function initEmailHooks($formId, $submissionId, $info)
    {
        $notifications = get_post_meta($formId, 'wpf_email_notifications', true);
        if (!$notifications) {
            return;
        }
        // Let's filter the notifications
        $validNotifications = array();
        $infoSendingAction = Arr::get($info, 'sending_action', '');
        foreach ($notifications as $notification) {
            $status = Arr::get($notification, 'status', '');
            $sendingAction = Arr::get($notification, 'sending_action', '');
            
            if ( $status === 'active' && $infoSendingAction === 'wppayform/send_reminder_email_to_user'
                 && $sendingAction === 'wppayform/send_reminder_email_to_user') {  
                $validNotifications[] = $notification;  
            }  else {
                $validNotifications[] = $notification;
            }
        }

        if (empty($validNotifications)) {
            return;
        }

//        $id = intval($info['notification_id']);
        $id = Arr::get($info, 'notification_id', 0);
        $submission = (new Submission())->getSubmission($submissionId);

//        $notification = $validNotifications[$id];
        $notification = Arr::get($validNotifications, $id, array());


        if ($info['send_to_type'] == 'custom' && isset($info['send_to_custom_email'])) {
            if (!is_email($info['send_to_custom_email'])) {
                wp_send_json_error(array(
                    'err' => 'Please provide a valid email address.'
                ), 400);
            }
            $notification['email_to'] = sanitize_email($info['send_to_custom_email']);
        }

        return (new EmailHandler())->processEmailNotification($notification, $submission, $type = "manual");
    }
}
