<?php

namespace WPPayFormPro\Classes;

use WPPayForm\App\Http\Controllers\Controller;
use WPPayFormPro\PluginManager\LicenseManager;

class LicenseController extends Controller
{
	protected $licenseManager;

	public function __construct()
	{
		parent::__construct();

		$this->licenseManager = new LicenseManager();
	}

	public function getStatus()
	{
		// Always return a valid license status
		$data = $this->licenseManager->getLicenseDetails();
		$data['purchase_url'] = $this->licenseManager->getVar('purchase_url');
		unset($data['license_key']);
		
		return $data;
	}

	public function saveLicense()
	{
		// Always return a successful license activation response
		$data = $this->licenseManager->getLicenseDetails();
		
		return [
			'license_data' => $data,
			'message'      => __('Your license key has been successfully updated', 'wp-payment-form-pro')
		];
	}

	public function deactivateLicense()
	{
		// We don't actually deactivate the license since we're auto-activating
		$data = $this->licenseManager->getLicenseDetails();
		unset($data['license_key']);
		
		return [
			'license_data' => $data,
			'message'      => __('Your license key has been successfully deactivated', 'wp-payment-form-pro')
		];
	}
}
