<?php

namespace WPPayFormPro\Classes;

use WPPayForm\App\Models\Submission;
use WPPayForm\App\Models\Transaction;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Form Info Handler Class
 * @since 1.0.0
 */
class PaymentHandler
{
    public function init()
    {
        // Register PayPal Payment Gateway
        $paypal = new \WPPayFormPro\GateWays\PayPal\PayPal();
        $paypal->init();

        // Register PayPal IPN
        $paypalIpn = new \WPPayFormPro\GateWays\PayPal\PayPalIpn();
        $paypalIpn->init();

        $mollie = new \WPPayFormPro\GateWays\Mollie\MollieProcessor();
        $mollie->init();

        $razorpay = new \WPPayFormPro\GateWays\Razorpay\RazorpayProcessor();
        $razorpay->init();

        $paystack = new \WPPayFormPro\GateWays\Paystack\PaystackProcessor();
        $paystack->init();

        $payrexx = new \WPPayFormPro\GateWays\Payrexx\PayrexxProcessor();
        $payrexx->init();

        $square = new \WPPayFormPro\GateWays\Square\SquareProcessor();
        $square->init();

        // register square IPN
        $squareIpn = new \WPPayFormPro\GateWays\Square\SquareIpn();
        $squareIpn->init();

        $payrexx = new \WPPayFormPro\GateWays\Sslcommerz\SslcommerzProcessor();
        $payrexx->init();

        $billplz = new \WPPayFormPro\GateWays\Billplz\BillplzProcessor();
        $billplz->init();

        // Register Stripe Event Handler
        $stripeEvent = new \WPPayFormPro\GateWays\Stripe\StripeListener();
        $stripeEvent->init();

        // Register Offline Payment Gateway
        // $offline = new \WPPayFormPro\GateWays\Offline\OfflineProcessor();
        // $offline->init();

        if (!defined('AuthorizeDotNet_FOR_PAYMATTIC')) {
            // Payment addons
            $authorizedotnet = new \WPPayFormPro\GateWays\Addons\Authorizedotnet();
            $authorizedotnet->init();
        }

        if (!defined('XENDIT_PAYMENT_FOR_PAYMATTIC')) {
            // Payment addons
            $xendit = new \WPPayFormPro\GateWays\Addons\Xendit();
            $xendit->init();
        }

        if (!defined('FLUTTERWAVE_PAYMENT_FOR_PAYMATTIC')) {
            // Payment addons
            $flutterwave = new \WPPayFormPro\GateWays\Addons\Flutterwave();
            $flutterwave->init();
        }

        if (!defined('MONERIS_PAYMENT_FOR_PAYMATTIC')) {
            // Payment addons
            $moneris = new \WPPayFormPro\GateWays\Addons\Moneris();
            $moneris->init();
        }

        if (!defined('VIVAWALLET_PAYMENT_FOR_PAYMATTIC')) {
            // Payment addons
            $viavawallet = new \WPPayFormPro\GateWays\Addons\Viavawallet();
            $viavawallet->init();
        }

        if (isset($_GET['wppayform_payment']) && isset($_GET['payment_method'])) {    
            add_action('wp', function () {
                $data = $_GET;
                $this->validateFrameLessPage($data);
                $paymentMethod = sanitize_text_field($_GET['payment_method']);
                do_action('wppayform_payment_frameless_' . $paymentMethod, $data);
            });
        }

        if (isset($_REQUEST['wpf_payment_api_notify'])) {
            add_action('wp', function () {
                $paymentMethod = sanitize_text_field($_REQUEST['payment_method']);
                do_action('wpf_ipn_endpoint_' . $paymentMethod);
            });
        }
    }

    private function validateFrameLessPage($data)
    {
        // We should verify the transaction hash from the URL
        $paymentMethod = sanitize_text_field(Arr::get($data, 'payment_method'));

        // specific for vivawallet
        if (sanitize_text_field(Arr::get($data, 'payment_method')) == 'vivawallet' && sanitize_text_field(Arr::get($data, 'wppayform_payment')) == 'wpf_success' || sanitize_text_field(Arr::get($data, 'wppayform_payment')) == 'wpf_failed') {
            if (isset($data['t']) || isset($data['ocd'])) {
                  return true;
             }
        }
        
        $submissionId = intval(Arr::get($data, 'wppayform_payment'));

        if (!$submissionId || !$paymentMethod) {
            die('Validation Failed');
        }
        if ($submissionId) {
            $transaction = Transaction::where('submission_id', $submissionId)
                ->where('payment_method', $paymentMethod)
                ->first();
            if (!$transaction) {
                die('Submission or payment method not matched!');
            }
        }

        $hash = sanitize_text_field(Arr::get($data, 'submission_hash'));
        if (!$hash) {
            $hash = sanitize_text_field(Arr::get($data, 'wpf_submission'));
        }
        if (!$hash) {
            die('Validation Failed');
        } else {
            $submission = Submission::where('submission_hash', $hash)->first();
            if (!$submission) {
                die('Submission Hash Invalid');
            }
        }
        return true;
    }
}
