<?php

namespace WPPayFormPro\Classes;

use WPPayForm\App\Http\Controllers\Controller;
use WPPayForm\App\Services\FormPlaceholders;
use WPPayForm\App\Models\Form;
use WPPayForm\App\Models\Meta;

class PaymentsController extends Controller
{
    public function index($formId)
    {
        $settings = (new PaymentsHelper())->getPaymentSettings($formId, 'admin');

        return array(
            'is_db_migrated' => get_option('wppayform_integration_status') == 'yes' ? true : false,
            'settings' => $settings,
            'shortCodes' => FormPlaceholders::getAllShortCodes($formId),
            'inputs' => Form::getInputShortcode($formId),
            'payment_methods' =>  Form::hasPaymentFields($formId),
        );
    }

    public function store($request, $formId)
    {
        return (new Meta())->updateOrderMeta('payment_settings','', '_payment_settings', $request->settings, $formId);
    }
}