<?php

namespace WPPayFormPro\Classes;

use WPPayForm\App\Models\Meta;
use WPPayForm\App\Services\GeneralSettings;

if (!defined('ABSPATH')) {
    exit;
}

class PaymentsHelper
{
    public function getPaymentSettings($formId, $scope = 'public')
    {
        static $cachedSettings = [];

        if (isset($cachedSettings[$scope . '_' . $formId])) {
            return $cachedSettings[$scope . '_' . $formId];
        }

        $defaults = [
            // 'currency'                       => '',
            'push_meta_to_stripe'            => 'no',
            'receipt_email'                  => '',
            'customer_name'                  => '',
            'transaction_type'               => 'product',
            'stripe_checkout_methods'        => ['card'],
            'stripe_meta_data'               => [
                [
                    'item_value' => '',
                    'label'      => ''
                ]
            ],
            'stripe_account_type'            => 'global',
            'disable_stripe_payment_receipt' => 'no',
            'stripe_custom_config'           => [
                'payment_mode'    => 'live',
                'publishable_key' => '',
                'secret_key'      => '',
                'test_publishable_key' => '',
                'test_secret_key' => ''
            ],
            'custom_paypal_id'               => '',
            'custom_test_paypal_id'          => '',
            'custom_paypal_mode'             => 'live',
            'paypal_account_type'            => 'global'
        ];

        $settings = Meta::getFormMeta($formId, '_payment_settings', [], 'payment_settings');
        $settings = wp_parse_args(safeUnserialize($settings), $defaults);

        // $globalSettings = GeneralSettings::getGlobalCurrencySettings();
        // if (!$settings['currency']) {
        //     $settings['currency'] = $globalSettings['currency'];
        // }
        // if ($scope == 'public') {
        //     $settings = wp_parse_args($settings, $globalSettings);
        // }
        $cachedSettings[$scope . '_' . $formId] = $settings;

        return $settings;
    }

}