<?php

namespace WPPayFormPro\GateWays\Billplz;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use WPPayForm\Framework\Support\Arr;

class API
{
    protected $header;
    protected $collectionId = '';
    protected $apiPath = "";

    public function __construct($keys)
    {
        $this->header =  array(
            'Authorization' => 'Basic ' . base64_encode(Arr::get($keys, 'api_secret') . ':'),
        );

        $this->collectionId = Arr::get($keys, 'collection_id');
        $this->apiPath = Arr::get($keys, 'api_path');
    }

    public function validation($billId)
    {
        $bill = $this->getBill($billId);

        if (is_wp_error($bill)) {
            // save message on log table for debug
            $errorMessage = $bill->get_error_message();
        }
        return $bill;
    }

    public function getBill($billId)
    {
        $url = $this->apiPath . 'v3/bills/' . $billId;
        return $this->makeApiCall($url);
    }

    public function getCollection($id = '')
    {
        $url = $this->apiPath . 'v4/collections/' . $id;
        return $this->makeApiCall($url);
    }

    public function createBill($parameter, $optional = array())
    {
        $url = $this->apiPath . 'v3/bills';

        $parameter['collection_id'] = $this->collectionId;
        $data = array_merge($parameter, $optional);
        $data['body'] = http_build_query($data);

        return $this->makeApiCall($url, $data, 'POST');
    }

    public function makeApiCall($url, $optional = [], $method="GET")
    {
        $data = array(
            'headers' => $this->header,
            'method' => $method,
            'sslverify' => false,
        );

        $data = array_merge($data, $optional);

        $response = \wp_remote_post($url, $data);

        $code = Arr::get($response, 'response.code');

        if (is_wp_error($response)) {
            return new \WP_Error(423, $response->get_error_message());
        }

        if (200 !== $code) {
            $messages = \json_decode($response['body'])->error->message;
            return new \WP_Error(
                $code,
                is_array($messages) ? implode(', ', $messages) : $messages
            );
        };

        $body = \wp_remote_retrieve_body($response);

        return json_decode($body, true);
    }
}
