<?php

namespace WPPayFormPro\GateWays\Payrexx\QueryHelper;

class Gateway extends Base
{
    protected $amount;
    protected $vatRate;
    protected $sku;
    protected $currency;
    protected $purpose;
    protected $psp;
    protected $pm;
    protected $preAuthorization = false;
    protected $reservation = false;
    protected $referenceId;
    protected $fields;
    protected $concardisOrderId;
    protected $successRedirectUrl;
    protected $failedRedirectUrl;
    protected $cancelRedirectUrl;
    protected $skipResultPage;
    protected $chargeOnAuthorization;
    protected $customerStatementDescriptor;
    protected $validity;
    protected $subscriptionState = false;
    protected $subscriptionInterval = '';
    protected $subscriptionPeriod = '';
    protected $subscriptionPeriodMinAmount = '';
    protected $subscriptionCancellationInterval = '';
    protected $buttonText;
    protected $lookAndFeelProfile;
    protected $successMessage;
    protected $basket;

    public function getAmount()
    {
        return $this->amount;
    }

    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    public function getVatRate()
    {
        return $this->vatRate;
    }

    public function setVatRate($vatRate)
    {
        $this->vatRate = $vatRate;
    }

    public function getSku()
    {
        return $this->sku;
    }

    public function setSku($sku)
    {
        $this->sku = $sku;
    }

    public function getCurrency()
    {
        return $this->currency;
    }

    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    public function getPurpose()
    {
        return $this->purpose;
    }

    public function setPurpose($purpose)
    {
        $this->purpose = $purpose;
    }

    public function getPsp()
    {
        return $this->psp;
    }

    public function setPsp($psp)
    {
        $this->psp = $psp;
    }

    public function getPm()
    {
        return $this->pm;
    }

    public function setPm($pm)
    {
        $this->pm = $pm;
    }

    public function getPreAuthorization()
    {
        return $this->preAuthorization;
    }

    public function setPreAuthorization($preAuthorization)
    {
        $this->preAuthorization = $preAuthorization;
    }

    public function getReservation()
    {
        return $this->reservation;
    }

    public function setReservation($reservation)
    {
        $this->reservation = $reservation;
    }

    public function getReferenceId()
    {
        return $this->referenceId;
    }

    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;
    }

    public function getFields()
    {
        return $this->fields;
    }

    public function addField($type, $value, $name = array())
    {
        $this->fields[$type] = array(
            'value' => $value,
            'name' => $name,
        );
    }

    public function getConcardisOrderId()
    {
        return $this->concardisOrderId;
    }

    public function setConcardisOrderId($concardisOrderId)
    {
        $this->concardisOrderId = $concardisOrderId;
    }

    public function getSuccessRedirectUrl()
    {
        return $this->successRedirectUrl;
    }

    public function setSuccessRedirectUrl($successRedirectUrl)
    {
        $this->successRedirectUrl = $successRedirectUrl;
    }

    public function getFailedRedirectUrl()
    {
        return $this->failedRedirectUrl;
    }

    public function setFailedRedirectUrl($failedRedirectUrl)
    {
        $this->failedRedirectUrl = $failedRedirectUrl;
    }

    public function getCancelRedirectUrl()
    {
        return $this->cancelRedirectUrl;
    }

    public function setCancelRedirectUrl($cancelRedirectUrl)
    {
        $this->cancelRedirectUrl = $cancelRedirectUrl;
    }

    public function isSkipResultPage()
    {
        return $this->skipResultPage;
    }

    public function setSkipResultPage($skipResultPage)
    {
        $this->skipResultPage = $skipResultPage;
    }

    public function isChargeOnAuthorization()
    {
        return $this->chargeOnAuthorization;
    }

    public function setChargeOnAuthorization($chargeOnAuthorization)
    {
        $this->chargeOnAuthorization = $chargeOnAuthorization;
    }

    public function getCustomerStatementDescriptor()
    {
        return $this->customerStatementDescriptor;
    }

    public function setCustomerStatementDescriptor(string $customerStatementDescriptor): void
    {
        $this->customerStatementDescriptor = $customerStatementDescriptor;
    }

    public function getValidity()
    {
        return $this->validity;
    }

    public function setValidity($validity)
    {
        $this->validity = $validity;
    }

    public function getResponseModel()
    {
        return new \Payrexx\Models\Response\Gateway();
    }

    public function isSubscriptionState()
    {
        return $this->subscriptionState;
    }

    public function setSubscriptionState($subscriptionState)
    {
        $this->subscriptionState = $subscriptionState;
    }

    public function getSubscriptionInterval()
    {
        return $this->subscriptionInterval;
    }

    public function setSubscriptionInterval($subscriptionInterval)
    {
        $this->subscriptionInterval = $subscriptionInterval;
    }

    public function getSubscriptionPeriod()
    {
        return $this->subscriptionPeriod;
    }

    public function setSubscriptionPeriod($subscriptionPeriod)
    {
        $this->subscriptionPeriod = $subscriptionPeriod;
    }

    public function getSubscriptionCancellationInterval()
    {
        return $this->subscriptionCancellationInterval;
    }

    public function setSubscriptionCancellationInterval($subscriptionCancellationInterval)
    {
        $this->subscriptionCancellationInterval = $subscriptionCancellationInterval;
    }

    public function getButtonText()
    {
        return $this->buttonText;
    }

    public function setButtonText($buttonText)
    {
        $this->buttonText = $buttonText;
    }

    public function getLookAndFeelProfile()
    {
        return $this->lookAndFeelProfile;
    }

    public function setLookAndFeelProfile($lookAndFeelProfile)
    {
        $this->lookAndFeelProfile = $lookAndFeelProfile;
    }

    public function getSuccessMessage()
    {
        return $this->successMessage;
    }

    public function setSuccessMessage($successMessage)
    {
        $this->successMessage = $successMessage;
    }

    public function getBasket(): array
    {
        return $this->basket;
    }

    public function setBasket(array $basket): void
    {
        $this->basket = $basket;
    }
}
