<?php

namespace WPPayFormPro\GateWays\Paystack;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

class PaystackElement extends BaseComponent
{
    public $gateWayName = 'paystack';

    public function __construct()
    {
        parent::__construct('paystack_gateway_element', 11);
        add_filter('wppayform/validate_gateway_api_' . $this->gateWayName, function ($data, $form) {
            return $this->validateApi();
        }, 2, 10);
        add_action('wppayform/payment_method_choose_element_render_paystack', array($this, 'renderForMultiple'), 10, 3);
        add_filter('wppayform/available_payment_methods', array($this, 'pushPaymentMethod'), 2, 1);
    }

    public function pushPaymentMethod($methods)
    {
        $methods['paystack'] = array(
            'label' => 'Paystack',
            'isActive' => true,
            'logo' => WPPAYFORM_URL . 'assets/images/gateways/paystack.svg',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Payment Option Label',
                    'type' => 'text',
                    'default' => 'Pay with Paystack'
                )
            )
        );
        return $methods;
    }


    public function component()
    {
        return array(
            'type' => 'paystack_gateway_element',
            'editor_title' => 'Paystack Payment',
            'editor_icon' => '',
            'conditional_hide' => true,
            'group' => 'payment_method_element',
            'method_handler' => $this->gateWayName,
            'postion_group' => 'payment_method',
            'single_only' => true,
            'is_pro' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text'
                )
            ),
            'field_options' => array(
                'label' => __('Paystack Payment Gateway', 'wp-payment-form-pro')
            )
        );
    }

    public function validateApi()
    {
        $apiKeys = PaystackSettings::getApiKeys();
        return strlen($apiKeys['api_secret']) > 0 || strlen($apiKeys['api_key']) > 0;
    }

    public function render($element, $form, $elements)
    {
        do_action('wppayform_load_checkout_js_paystack');

        if (!$this->validateApi()) { ?>
            <p class="wpf_payment_gateway_validation_error" style="color: red">You did not configure Paystack payment gateway. Please configure paystack payment
                gateway from <b>Paymattic->Payment Gateway->Paystack Settings</b> to start accepting payments</p>
            <?php return;
        }

        echo '<input data-wpf_payment_method="paystack" type="hidden" name="__paystack_payment_gateway" value="paystack" />';
    }

    public function renderForMultiple($paymentSettings, $form, $elements)
    {
        do_action('wppayform_load_checkout_js_paystack');

        $component = $this->component();
        $component['id'] = 'paystack_gateway_element';
        $component['field_options'] = $paymentSettings;
        $this->render($component, $form, $elements);
    }
}
