<?php

namespace WPPayFormPro\GateWays\Square;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

class SquareElement extends BaseComponent
{
    public $gateWayName = 'square';

    public function __construct()
    {
        parent::__construct('square_gateway_element', 9);

        add_filter('wppayform/validate_gateway_api_' . $this->gateWayName, function ($data, $form) {
            return $this->validateApi();
        }, 2, 10);
        add_action('wppayform/payment_method_choose_element_render_square', array($this, 'renderForMultiple'), 10, 3);
        add_filter('wppayform/available_payment_methods', array($this, 'pushPaymentMethod'), 2, 1);
    }

    public function pushPaymentMethod($methods)
    {
        $methods['square'] = array(
            'label' => 'Square',
            'isActive' => true,
            'logo' => WPPAYFORM_URL . 'assets/images/gateways/square.svg',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Payment Option Label',
                    'type' => 'text',
                    'default' => 'Pay with Square'
                )
            )
        );
        return $methods;
    }


    public function component()
    {
        return array(
            'type' => 'square_gateway_element',
            'editor_title' => __('Square Payment', 'wp-payment-form-pro'),
            'editor_icon' => '',
            'group' => 'payment_method_element',
            'method_handler' => $this->gateWayName,
            'postion_group' => 'payment_method',
            'single_only' => true,
            'is_pro' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text'
                )
            ),
            'field_options' => array(
                'label' => __('Square Payment Gateway', 'wp-payment-form-pro')
            )
        );
    }

    public function validateApi()
    {
        $apiKeys = SquareSettings::getApiKeys();
        return strlen($apiKeys['access_key']) > 0 || strlen($apiKeys['location_id']) > 0;
    }

    public function render($element, $form, $elements)
    {
        if (!$this->validateApi()) { ?>
            <p class="wpf_payment_gateway_validation_error" style="color: red">You did not configure Square payment gateway. Please configure square payment
                gateway from <b>Paymattic->Payment Gateway->Square Settings</b> to start accepting payments</p>
            <?php return;
        }

        echo '<input data-wpf_payment_method="square" type="hidden" name="__square_payment_gateway" value="square" />';
    }

    public function renderForMultiple($paymentSettings, $form, $elements)
    {
        $settings = (new SquareSettings())->getPaymentSettings();
        if (Arr::get($settings, 'settings.checkout_type') === 'modal') {
            do_action('wppayform_load_checkout_js_square', $settings);
        };

        $component = $this->component();
        $component['id'] = 'square_gateway_element';
        $component['field_options'] = $paymentSettings;
        $this->render($component, $form, $elements);
    }
}
