<?php

namespace WPPayFormPro\GateWays\Sslcommerz;

use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Models\Form;

if (!defined('ABSPATH')) {
    exit;
}

class SslcommerzElement extends BaseComponent
{
    public $gateWayName = 'sslcommerz';

    public function __construct()
    {
        parent::__construct('sslcommerz_gateway_element', 13);
        add_filter('wppayform/validate_gateway_api_' . $this->gateWayName, function ($data, $form) {
            return $this->validateApi();
        }, 2, 10);
        add_action('wppayform/payment_method_choose_element_render_sslcommerz', array($this, 'renderForMultiple'), 10, 3);
        add_filter('wppayform/available_payment_methods', array($this, 'pushPaymentMethod'), 2, 1);
    }

    public function pushPaymentMethod($methods)
    {
        $methods['sslcommerz'] = array(
            'label' => 'SSLCOMMERZ',
            'isActive' => true,
            'logo' => WPPAYFORM_URL . 'assets/images/gateways/sslcommerz.svg',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Payment Option Label',
                    'type' => 'text',
                    'default' => 'Pay with Sslcommerz'
                )
            )
        );
        return $methods;
    }


    public function component()
    {
        return array(
            'type' => 'sslcommerz_gateway_element',
            'editor_title' => 'SSLCommerz Payment',
            'conditional_hide' => true,
            'editor_icon' => '',
            'group' => 'payment_method_element',
            'method_handler' => $this->gateWayName,
            'postion_group' => 'payment_method',
            'single_only' => true,
            'is_pro' => 'yes',
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text'
                )
            ),
            'field_options' => array(
                'label' => __('Sslcommerz Payment Gateway', 'wp-payment-form-pro')
            )
        );
    }

    public function validateApi()
    {
        $apiKeys = SslcommerzSettings::getApiKeys();
        return strlen($apiKeys['api_key']) > 0 || strlen($apiKeys['api_secret']) > 0;
    }

    public function render($element, $form, $elements)
    {
        do_action('wppayform_load_checkout_js_sslcommerz');
        if (!$this->validateApi()) { ?>
            <p class="wpf_payment_gateway_validation_error" style="color: red">You did not configure Sslcommerz payment gateway. Please configure sslcommerz payment
                gateway from <b>Paymattic->Payment Gateway->Sslcommerz Settings</b> to start accepting payments</p>
            <?php return;
        }

        echo '<input data-wpf_payment_method="sslcommerz" type="hidden" name="__sslcommerz_payment_gateway" value="sslcommerz" />';
    }

    public function renderForMultiple($paymentSettings, $form, $elements)
    {
        do_action('wppayform_load_checkout_js_sslcommerz');

        $component = $this->component();
        $component['id'] = 'sslcommerz_gateway_element';
        $component['field_options'] = $paymentSettings;
        $this->render($component, $form, $elements);
    }
}
