<?php

namespace WPPayFormPro\Integrations\LearnDash;

use WPPayForm\Framework\Support\Arr;

class AddToCourseAction
{
    public function Add($feed, $formData, $entry, $formId)
    {
        $settings = $feed['processedValues'];

        $customerEmail = Arr::get($formData, 'customer_email');

        if (!is_email($customerEmail)) {
            return;
        }

        $user  = get_user_by('email', $customerEmail);
        $userId = $user ? $user->ID : null;

        $courseId = Arr::get($settings, 'course_id');

        if (!$courseId) {
            $message = __('Data Skipped because no course found', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
            return false;
        }

        if (!$userId) {
            $formData['user_id'] = '';
            // If no user found then let's create a user
            $welcomeEmail = Arr::get($settings, 'send_welcome_email') == 'yes' || Arr::get($settings, 'send_welcome_email') == 1;

            $userId = LearnDashHelper::createWpUserFromSubscriber($settings, $formData, $entry->id, $welcomeEmail);

            if (is_wp_error($userId)) {
                //user not created
                return false;
            }
        }

        // Autologin process start
        $do_autologin = ((Arr::get($settings, 'do_autologin') == 'yes') || (Arr::get($settings, 'do_autologin') == 1));
        
        if (true == $do_autologin)
        {
            //get the user_id of the current logged-in user (if any)
            $current_user_id = get_current_user_id(); //returns 0 if no user is currently logged-in
            
            if (0 == $current_user_id)
            {
                //$current_user_id is 0, so there is not any current logged-in user
                //execute autologin stuff
                wp_clear_auth_cookie();
                wp_set_current_user($userId);
                wp_set_auth_cookie($userId);

                do_action('wppayform_log_data', [
                    'form_id' => $formId,
                    'submission_id' => $entry->id,
                    'type' => 'failed',
                    'created_by' => 'Paymattic BOT',
                    'content' => "User automatically logged in after course purchase and registration"
                ]);
            }
        }
        // Autologin process end

        $result = false;

        if (LearnDashHelper::isInCourses([$courseId], $userId)) {
            $result = true;
        } else {
            $result = ld_update_course_access($userId, $courseId);
        }

        if (!$result) {
            $message = __('User could not be enrolled to the selected course-LearnDash', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'failed',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
            return false;
        } else {
            $message = __('User enrolled to the selected course-LearnDash', 'wp-payment-form-pro');
            do_action('wppayform_log_data', [
                'form_id' => $formId,
                'submission_id' => $entry->id,
                'type' => 'success',
                'created_by' => 'Paymattic BOT',
                'content' => $message
            ]);
        }

    }

}
