<?php

namespace WPPayFormPro\Integrations\LifterLMS;

use WPPayForm\Framework\Support\Arr;
use WPPayForm\App\Services\ConditionAssesor;
use WPPayForm\App\Services\Integrations\IntegrationManager;
use WPPayForm\Framework\Foundation\App;
use WPPayFormPro\Integrations\LifterLMS\AddToCourseAction;

class Bootstrap extends IntegrationManager
{
    public $hasGlobalMenu = false;

    public $disableGlobalSettings = 'yes';

    public function __construct()
    {
        parent::__construct(
            App::getInstance(),
            'LifterLMS',
            'lifterlms',
            '_wppayform_lifterlms_settings',
            'lifterlms_feeds',
            10
        );

        $this->logo = WPPAYFORM_URL . 'assets/images/integrations/lifterlms.png';

        $this->description = 'Connect LifterLMS with Paymattic and subscribe a contact when a form is submitted.';

        $this->category = 'lms';

        $this->registerAdminHooks();

         // It should be synchronous, so we need this line
        add_filter('wppayform_notifying_async_lifterlms', '__return_false');

        add_filter('wppayform_global_addons', array($this, 'addInstruction'));
    }

    public function addInstruction($addOns)
    {
        if (defined('LLMS_PLUGIN_FILE')) {
            return $addOns;
        }

        $instruction = array(
            'lifterlms'   => array(
                'title'        => 'LifterLMS',
                'description'  => 'Connect LifterLMS with Paymattic and subscribe a contact when a form is submitted.',
                'logo'         =>  WPPAYFORM_URL . 'assets/images/integrations/lifterlms.png',
                'enabled'      => 'no',
                'purchase_url' => 'https://wordpress.org/plugins/lifterlms/',
                'category'     => $this->category,
                'btnTxt'       => 'Install & Activate'
            ),
        );
        return array_merge($addOns, $instruction);
    }

    public function pushIntegration($integrations, $formId)
    {
        $integrations[$this->integrationKey] = [
            'title' => $this->title . ' Integration',
            'logo' => $this->logo,
            'is_active' => $this->isConfigured(),
            'configure_title' => __('Configuration required!', 'wp-payment-form-pro'),
            'config_url' => admin_url('admin.php?page=wppayform.php#/integrations/lifterlms'),
            'global_configure_url' => admin_url('admin.php?page=wppayform.php#/integrations/lifterlms'),
            'configure_message' => __('LifterLMS is not configured yet! Please configure your LifterLMS api first', 'wp-payment-form-pro'),
            'configure_button_text' => __('Set LifterLMS', 'wp-payment-form-pro')
        ];
        return $integrations;
    }

    public function getIntegrationDefaults($settings, $formId)
    {
        return [
            'name' => '',
            'email' => '',
            'course_id' => '',
            // 'skip_if_exists' => false,
            'send_welcome_email' => true,
            'remove_on_refund' => false,
            'trigger_on_payment' => false,
            'conditionals' => [
                'conditions' => [],
                'status' => false,
                'type' => 'all'
            ],
            'enabled' => true
        ];
    }

    public function getSettingsFields($settings, $formId)
    {

        return [
            'fields' => [
                [
                    'key' => 'name',
                    'label' => __('Feed Name', 'wp-payment-form-pro'),
                    'required' => true,
                    'placeholder' => __('Your Feed Name', 'wp-payment-form-pro'),
                    'component' => 'text'
                ],
                [
                    'key' => 'course_id',
                    'label' => __('LifterLMS Course', 'wp-payment-form-pro'),
                    'placeholder' => __('Select LifterLMS Course', 'wp-payment-form-pro'),
                    'tips' => __('Select the LifterLMS Course you would like enroll.', 'wp-payment-form-pro'),
                    'component' => 'select',
                    'required' => true,
                    'options' => $this->getCourses(),
                ],
                [
                    'key'                => 'CustomFields',
                    'require_list'       => false,
                    'label'              => 'Map Fields',
                    'tips'               => 'Associate your user registration fields to the appropriate Paymattic fields by selecting the appropriate form field from the list.',
                    'component'          => 'map_fields',
                    'field_label_remote' => 'User Registration Field',
                    'field_label_local'  => 'Form Field',
                    'primary_fileds'     => [
                        [
                            'key'           => 'Email',
                            'label'         => 'Email Address',
                            'required'      => true,
                            'input_options' => 'emails'
                        ],
                        [
                            'key'       => 'username',
                            'label'     => 'User name',
                            'required'  => false,
                            'help_text' => 'Keep empty if you want the username and user email is the same',
                        ],
                        [
                            'key'       => 'password',
                            'label'     => 'Password',
                            'help_text' => 'Keep empty to be auto generated',
                        ],
                    ]
                ],
                // [
                //     'key' => 'skip_if_exists',
                //     'require_list' => false,
                //     'checkbox_label' => __('Do not enroll the course if contact is not an existing WordPress User', 'wp-payment-form-pro'),
                //     'component' => 'checkbox-single'
                // ],
                [
                    'require_list'   => false,
                    'key'            => 'do_autologin',
                    'label'          => __('Auto Login', 'wp-payment-form-pro'),
                    'tips'           => __('User will be automatically logged in upon completing the purchase.', 'wp-payment-form-pro'),
                    'checkbox_label' => __('Allow the user login automatically after registration or course purchase', 'wp-payment-form-pro'),
                    'component'      => 'checkbox-single',
                ],
                [
                    'key' => 'send_welcome_email',
                    'require_list' => false,
                    'checkbox_label' => __('Send default WordPress Welcome Email for new WordPress users', 'wp-payment-form-pro'),
                    'component' => 'checkbox-single'
                ],
                [
                    'key' => 'remove_on_refund',
                    'require_list' => false,
                    'checkbox_label' => __('Remove user if refunded or subscription canceled', 'wp-payment-form-pro'),
                    'component' => 'checkbox-single'
                ],
                [
                    'key' => 'trigger_on_payment',
                    'require_list' => false,
                    'checkbox_label' => __('Enroll course on payment success only', 'wp-payment-form-pro'),
                    'component' => 'checkbox-single'
                ],
                [
                    'require_list' => false,
                    'key'          => 'conditionals',
                    'label'        => __('Conditional Logics', 'wp-payment-form-pro'),
                    'tips'         => __('Allow LifterLMS integration conditionally based on your submission values', 'wp-payment-form-pro'),
                    'component'    => 'conditional_block'
                ],
                [
                    'require_list' => false,
                    'key' => 'enabled',
                    'label' => 'Status',
                    'component' => 'checkbox-single',
                    'checkbox_label' => __('Enable This feed', 'wp-payment-form-pro')
                ]
            ],
            'button_require_list' => false,
            'integration_title' => $this->title
        ];
    }

    public function getMergeFields($list, $listId, $formId)
    {
        return [];
    }

    public static function getCourses()
    {
        $courses = get_posts(array(
            'post_type'   => 'course',
            'numberposts' => -1
        ));
        $formattedLists = [];
        foreach ($courses as $list) {
            $formattedLists[$list->ID] = $list->post_title;
        }
        return $formattedLists;
    }

    /*
     * Form Submission Hooks Here
     */
    public function notify($feed, $formData, $entry, $formId)
    {
        return (new AddToCourseAction())->add($feed, $formData, $entry, $formId);
    }

    public function isConfigured()
    {
        return defined('LLMS_PLUGIN_FILE');
    }

    public function isEnabled()
    {
        return true;
    }

    /*
     * We will remove this in future
     */
    protected function getSelectedTagIds($data, $inputData, $simpleKey = 'tag_ids', $routingId = 'tag_ids_selection_type', $routersKey = 'tag_routers')
    {
        $routing = Arr::get($data, $routingId, 'simple');
        if (!$routing || $routing == 'simple') {
            return Arr::get($data, $simpleKey, []);
        }

        $routers = Arr::get($data, $routersKey);
        if (empty($routers)) {
            return [];
        }

        return $this->evaluateRoutings($routers, $inputData);
    }

    /*
     * We will remove this in future
     */
    protected function evaluateRoutings($routings, $inputData)
    {
        $validInputs = [];
        foreach ($routings as $routing) {
            $inputValue = Arr::get($routing, 'input_value');
            if (!$inputValue) {
                continue;
            }
            $condition = [
                'conditionals' => [
                    'status' => true,
                    'is_test' => true,
                    'type' => 'any',
                    'conditions' => [
                        $routing
                    ]
                ]
            ];

            if (ConditionAssesor::evaluate($condition, $inputData)) {
                $validInputs[] = $inputValue;
            }
        }

        return $validInputs;
    }
}
